package de.schmaeck.struktogrammeditor.model.structureelement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;

/**
 * Mutter aller Strukturelemente die typ-angabe erspart reflectionsgefummel
 * 
 * @author Martin Schmaeck TODO abstrakte klasse
 */
public abstract class StructureElement implements Serializable {

  // TODO Diese Zahl jedesmal dann ndern (+1), wenn diese Klasse verndert wurde
  private final static long serialVersionUID = 142l;

  public final static int NOSE = -1;

  public final static int BLOCK = 0;

  public final static int SUBROUTINE = 1; // BLOCK

  public final static int BREAKBLOCK = 2; // BLOCK

  public final static int CONTINUEBLOCK = 3; // BLOCK

  public final static int RETURNBLOCK = 4; // BLOCK

  public final static int IFBLOCK = 5;

  // public final static int SWITCHBLOCK = 6;

  public final static int WHILELOOP = 7;

  public final static int DOWHILELOOP = 8;

  // public final static int FORLOOP = 9;

  // public final static int INFINITELOOP = 10;

  // public final static int COMMENTBLOCK = 11;

  // Ein Methoden-Objekt ist auch ein SE, da sie eine Liste mit SE enthlt
  public final static int METHODDEF = 12;

  public final static int NOTHING = 13; // fr leere SEListen

  // ---
  // public final static double MINATOMWIDTH = 50; // Mindestbreite fr ein atomares SE


  protected int structrueTyp;

  protected StructureElement parentStructureElement; // Eltern SE

  protected int parentStructureElementListIndex; // Index der SE-Liste des Eltern-SE, in der dieses SE enthalten ist

  // TODO: ?
  // protected StructureElementObserver observer; // Prinzipiell ist auch eine Liste mglich, wird derzeit aber nicht
  // bentigt

  protected int width; // aktuelle Breite in Einheiten (~Pixeln)

  protected int minWidth; // Mindestbreite der SE-Komponente

  protected int prefWidth; // Lieblingsbreite der SE-Komponente

  protected int height; // aktuelle Hhe in Einheiten (~Pixeln)

  private boolean isActive = false; // fr ProgrammSimulation


  // public StructureElementObserver getObserver () {
  // return observer;
  // }
  //
  // public void setObserver (StructureElementObserver observer) {
  // this.observer = observer;
  // }

  public StructureElement getParentStructureElement () {
    return parentStructureElement;
  }

  public ArrayList<StructureElement> getParentStructureElementList () {
    return this.parentStructureElement.getStructureElementList(this.parentStructureElementListIndex);
  }

  public void setParentStructureElement (StructureElement parentSE) {
    this.parentStructureElement = parentSE;
  }

  public int getParentStructureElementListIndex () {
    return this.parentStructureElementListIndex;
  }

  public void setParentStructureElementListIndex (int parentStructureElementListIndex) {
    this.parentStructureElementListIndex = parentStructureElementListIndex;
  }

  public int getStructureTyp () {
    return structrueTyp;
  }

  // TODO hier und in allen kindern lschen! das ist eine skinabhngige eigenschaft!
  // -> hm, wirklich?
  public int getNumberOfRows () {
    return 0;
  }

  public int getRowDistanceToChildList () {
    return 0;
  }

  // mit true zu berschreiben, wenn das SE mehr als eine SEListe enthlt (if, switch)
  public boolean implementsSeperatorMovingSE () {
    return false;
  }

  // Ist von SE mit eigenen SEListen zu berschreiben
  public int getNumberOfStructureElementLists () {
    return 0;
  }

  // Ist von SE mit eigenen SEListen zu berschreiben
  public ArrayList<StructureElement> getStructureElementList (int index) {
    return null;
  }

  // Kopiert das SE fr die Zwischenablage u..
  abstract public StructureElement copy ();

  // abstract... von loops mit true berschreiben
  // Loop-SE haben einen linken Rand, der beim Zeichnen / bei der Def. von
  // MouseZonen von Relevanz ist.
  public boolean hasLoopBorder () {
    return false;
  }

  public int getMinWidth () {
    return minWidth;
  }

  public void setMinWidth (int minWidth) {
    this.minWidth = minWidth;
  }

  public int getPrefWidth () {
    return prefWidth;
  }

  public void setPrefWidth (int prefWidth) {
    this.prefWidth = prefWidth;
  }

  public int getWidth () {
    return width;
  }

  public void setWidth (int width) {
    this.width = width;
  }

  public void setHeight (int height) {
    this.height = height;
  }

  public double getHeight () {
    return height;
  }

  public void setHasChanged () {
    StructureElement se = this;
    while (se.getStructureTyp() != StructureElement.METHODDEF) {
      se = se.getParentStructureElement();
    }
    ((StructureElementMethod) se).setChanged(true);

  }

  public void updateSize (HaSE editor) {
    int height = 0;
    int minWidth = 0;
    int prefWidth = 0;
    for (int i = 0; i < this.getNumberOfStructureElementLists(); i++) {
      int heightTemp = 0;
      int minWidthTemp = 0;
      int prefWidthTemp = 0;
      for (int j = 0; j < this.getStructureElementList(i).size(); j++) {
        this.getStructureElementList(i).get(j).updateSize(editor);
        heightTemp += this.getStructureElementList(i).get(j).getHeight();
        minWidthTemp = (int) Math.max(minWidthTemp, this.getStructureElementList(i).get(j).getMinWidth());
        prefWidthTemp = (int) Math.max(prefWidthTemp, this.getStructureElementList(i).get(j).getPrefWidth());
      }
      height = Math.max(heightTemp, height);
      minWidth += minWidthTemp;
      prefWidth += prefWidthTemp;
    }
    height += editor.environment.skin.calcSEBaseHeight(this);
    if (this.hasLoopBorder()) minWidth += editor.environment.skin.getLoopBorderWidth();
    if (this.hasLoopBorder()) prefWidth += editor.environment.skin.getLoopBorderWidth();
    minWidth = (int) Math.max(minWidth, editor.environment.skin.calcSEBaseMinWidth(this));
    prefWidth = (int) Math.max(prefWidth, editor.environment.skin.calcSEBasePrefWidth(this));
    this.height = height;
  }

  public ArrayList<StructureElement> loadSelFromXMLElement (Element sel, StructureElement parentSE,
      int parentStructureElementListIndex2, HaSE editor) {
    ArrayList<StructureElement> al = new ArrayList<StructureElement>();
    List list = sel.getChildren();

    for (int i = 0; i < list.size(); i++) {
      Element el = (Element) list.get(i);
      String seType = el.getName();
      if (seType.equals("Block")) {
        StructureElementBlock se = new StructureElementBlock(el, editor);
        se.setParentStructureElement(parentSE);
        se.setParentStructureElementListIndex(parentStructureElementListIndex2);
        al.add(se);
      } else if (seType.equals("While")) {
        StructureElementWhile se = new StructureElementWhile(el, editor);
        se.setParentStructureElement(parentSE);
        se.setParentStructureElementListIndex(parentStructureElementListIndex2);
        al.add(se);
      } else if (seType.equals("DoWhile")) {
        StructureElementDoWhile se = new StructureElementDoWhile(el, editor);
        se.setParentStructureElement(parentSE);
        se.setParentStructureElementListIndex(parentStructureElementListIndex2);
        al.add(se);
      } else if (seType.equals("If")) {
        StructureElementIf se = new StructureElementIf(el, editor);
        se.setParentStructureElement(parentSE);
        se.setParentStructureElementListIndex(parentStructureElementListIndex2);
        al.add(se);

      } else if (seType.equals("...")) {
        // ...

      }
    }
    return al;
  }

  abstract public Element toElementXML ();

  public Condition getCondition () {
    return null;
  }

  // Testet, ob an dieser Stelle ein Break bzw. Continue erlaubt ist

  public boolean isBreakAllowed (HaSE editor) {

    // Jeweils nur am Listenende erlauben
    if (getParentStructureElementList().get(getParentStructureElementList().size() - 1) == this) {

      StructureElement mother = this.getParentStructureElement();

      // falls ein break bereits existierenden code unerreichbar macht, nicht erlauben
      if (mother.getStructureTyp() == IFBLOCK) {
        StructureElementIf ifEl = (StructureElementIf) mother;
        if (!isSelEndSEAllowed(ifEl, this.getParentStructureElementListIndex(), editor)) { return false; }
      }

      while (mother != null) {
        if (mother.getStructureTyp() == DOWHILELOOP || mother.getStructureTyp() == WHILELOOP) { return true; }
        mother = mother.getParentStructureElement();
      }
    }
    return false;
  }

  // mother = SE in dem eingefgt werden soll
  // sel = sel von mother, in dem eingefgt werden soll
  // index = index innerhalb der sel, an dem eingefgt werden soll
  // Copy n Paste Code Reuse :-( verfgbarekei bestimmter Informationen machte es notewendig.
  public static boolean isNewBreakAllowed (StructureElement mother, int selIndex, int index, HaSE editor) {

    ArrayList<StructureElement> sel = mother.getStructureElementList(selIndex);
    // falls ein break bereits existierenden code unerreichbar macht, nicht erlauben
    if (mother.getStructureTyp() == IFBLOCK) {
      StructureElementIf ifEl = (StructureElementIf) mother;
      if (!isSelEndSEAllowed(ifEl, selIndex, editor)) { return false; }
    }

    if ((sel.size()) == index) {
      while (mother != null) {
        if (mother.getStructureTyp() == DOWHILELOOP || mother.getStructureTyp() == WHILELOOP) { return true; }
        mother = mother.getParentStructureElement();
      }
    }
    return false;
  }

  private static boolean isSelEndSEAllowed (StructureElementIf seIf, int selIndex, HaSE editor) {
    int alternativIndex = 1 - selIndex;
    ArrayList<StructureElement> sel = seIf.getStructureElementList(alternativIndex);

    if (sel.size() == 0) {
      // eine leere Liste kann kein break/continue/return enthalten
      return true;
    } else {
      if (sel.get(sel.size() - 1).isSelEndSE(editor)) {
        // aha. d.h. nach dem if wird kein code mehr erreicht.
        if (seIf.getParentStructureElementList().get(seIf.getParentStructureElementList().size() - 1) == seIf) {
          // es gibt nach dem if keinen folgecode.
          StructureElement mother = seIf.parentStructureElement;
          if (mother.getStructureTyp() == IFBLOCK) {
            return isSelEndSEAllowed((StructureElementIf) mother, seIf.getParentStructureElementListIndex(), editor);
          } else {
            // mutter kein if...
            return true;
          }
        } else {
          // es gibt noch folgecode, der dann unerreichbar wre.
          return false;
        }
      } else {
        // die alternative Liste knnte den code weiterfhren
        return true;
      }
    }
  }

  // ---


  public boolean isBooleanMethod (HaSE editor) {
    return isBooleanMethod(this, editor);
  }

  public static boolean isBooleanMethod (StructureElement se, HaSE editor) {
    while (se != null) {
      if (se.getStructureTyp() == METHODDEF) {
        if (editor.environment.targetProgrammingLanguage.getTypeList()[1].equals(((StructureElementMethod) se)
            .getType())) { return true; }
      }
      se = se.getParentStructureElement();
    }
    return false;
  }

  // ---

  public boolean isReturnAllowed (HaSE editor) {
    // ---

    // Jeweils nur am Listenende erlauben
    if (getParentStructureElementList().get(getParentStructureElementList().size() - 1) == this) {

      StructureElement mother = this.getParentStructureElement();

      // falls ein break/.. bereits existierenden code unerreichbar macht, nicht erlauben
      if (mother.getStructureTyp() == IFBLOCK) {
        StructureElementIf ifEl = (StructureElementIf) mother;
        if (!isSelEndSEAllowed(ifEl, this.getParentStructureElementListIndex(), editor)) { return false; }
      }
      return true;
    }
    return false;
  }

  // ---

  public static boolean isNewReturnAllowed (StructureElement mother, int selIndex, int index, HaSE editor) {

    ArrayList<StructureElement> sel = mother.getStructureElementList(selIndex);
    // falls ein break bereits existierenden code unerreichbar macht, nicht erlauben
    if (mother.getStructureTyp() == IFBLOCK) {
      StructureElementIf ifEl = (StructureElementIf) mother;
      if (!isSelEndSEAllowed(ifEl, selIndex, editor)) { return false; }
    }
    if ((sel.size()) == index) return true;
    else return false;

  }

 
  // setzt vorraus, dass ein einfaches ndern nicht erlaubt ist
  public StructureElement getRemoveSeToAllowChangeToReturn(HaSE editor) {
    if ((getParentStructureElementList().size() > 1) 
        && (getParentStructureElementList().get(getParentStructureElementList().size()-2) == this)) {
      // ist vorletztes se in einer sel
      if (getParentStructureElementList().get(getParentStructureElementList().size()-1).isReturnEquivalent(editor)) {
        // und letztes se in der sel ist return und mste gelscht werden
        return getParentStructureElementList().get(getParentStructureElementList().size()-1);
      } else {
        // regulrer code soll nicht gelscht werden, also null fr false
        return null;
      }
    } else if ((getParentStructureElementList().size() > 0) 
        && (getParentStructureElementList().get(getParentStructureElementList().size()-1) == this)
        && (getParentStructureElement().getStructureTyp() == IFBLOCK)){
      // ist letzte se in sel UND mutter ist if 
      // -> vorbot muss heien, dass if zu isReturnEquivalent wird
      // also rekursiver aufruf eine ebene hher.
      return getParentStructureElement().getRemoveSeToAllowChangeToReturn(editor);
    } else {
      // im zweifelsfall verbieten.
      return null;
    }
  }

  // setzt vorraus, dass ein einfaches ndern nicht erlaubt ist
  public static StructureElement getRemoveSeToAllowAddNewReturn(StructureElement mother, int selIndex, int index, HaSE editor) {

    ArrayList<StructureElement> sel = mother.getStructureElementList(selIndex);
    
    if (index == sel.size()-1) {
      // index wird vorletztes se in einer sel
      if (sel.get(sel.size()-1).isReturnEquivalent(editor)) {
        // und letztes se in der sel ist return und mste gelscht werden
        return sel.get(sel.size()-1);
      } else {
        // regulrer code soll nicht gelscht werden, also null fr false
        return null;
      }
    } else if ((index == sel.size()) 
        && (mother.getStructureTyp() == IFBLOCK)){
      // index wird letztes se in sel UND mutter ist if 
      // -> vorbot muss heien, dass if zu isReturnEquivalent wird
      // also rekursiver aufruf eine ebene hher.
      return mother.getRemoveSeToAllowChangeToReturn(editor);
    } else {
      // im zweifelsfall verbieten.
      return null;
    }
  }
  


  // ---


  // auf ein return: ein return darf nicht gelscht/ersetzt werden, wenn
  // - boolsche methode
  // - und: es kann zu einer situation ohne return kommen. bzw. mutter ist returnEqi
  public boolean isReturnRequired (HaSE editor) {
    if (getStructureTyp() != RETURNBLOCK) return false;
    if (!isBooleanMethod(editor)) return false;
    if (getParentStructureElement().getStructureTyp() == IFBLOCK) {
      StructureElementIf ifEl = (StructureElementIf) getParentStructureElement();
      return ifEl.isReturnEquivalent(editor);
    }
    return true;
  }

  // alternativ: CP ermitteln, an dem ein ersatz return eingefgt werden muss.


  // ---

  public boolean isReturnEquivalent (HaSE editor) {
    if (this.getStructureTyp() == RETURNBLOCK
    // && ((StructureElementBlock) this).text.equals(editor.environment.atomBlockList.get(0).getCodeText())
    ) {
      return true;
    } else {
      if (this.getStructureTyp() == IFBLOCK) {
        if ((((StructureElementIf) this).getTrueList().size() > 0)
            && (((StructureElementIf) this).getTrueList().get(((StructureElementIf) this).getTrueList().size() - 1)
                .isReturnEquivalent(editor))) {
          if ((((StructureElementIf) this).getFalseList().size() > 0)
              && (((StructureElementIf) this).getFalseList().get(((StructureElementIf) this).getFalseList().size() - 1)
                  .isReturnEquivalent(editor))) { return true; }
        }
      }
    }
    return false;
  }


  // zum testen unerreichbaren codes
  // true, falls dieses SE mit sicherheit (...) ein erreichen des folgecodes verhindert
  public boolean isSelEndSE (HaSE editor) {
    if (getStructureTyp() == BREAKBLOCK || getStructureTyp() == CONTINUEBLOCK || getStructureTyp() == RETURNBLOCK)
      return true;
    if (getStructureTyp() == IFBLOCK) {
      if ((((StructureElementIf) this).getTrueList().size() > 0)
          && (((StructureElementIf) this).getTrueList().get(((StructureElementIf) this).getTrueList().size() - 1)
              .isSelEndSE(editor))) {
        if ((((StructureElementIf) this).getFalseList().size() > 0)
            && (((StructureElementIf) this).getFalseList().get(((StructureElementIf) this).getFalseList().size() - 1)
                .isSelEndSE(editor))) { return true; }
      }
    }
    return false;
  }

  public boolean isBlockEquivalent () {
    return this.structrueTyp == BLOCK || this.structrueTyp == BREAKBLOCK || this.structrueTyp == CONTINUEBLOCK
        || this.structrueTyp == RETURNBLOCK || this.structrueTyp == SUBROUTINE;
  }

  // ist das einfgen neuer SEs erlaubt?
  public static boolean isReachableCode (ArrayList<StructureElement> sel, int index, HaSE editor) {
    if (index > 0) {
      return (!sel.get(index - 1).isSelEndSE(editor));
    } else {
      return true;
    }
  }


  public void setStructureType (int type) {
    this.structrueTyp = type;
  }

  public int getIndex () {
    for (int i = 0; i < getParentStructureElementList().size(); i++) {
      if (this == getParentStructureElementList().get(i)) return i;
    }
    return -1;
  }
  
  // tab = ein tabulator o..
  // preTab = um das muss bereits eingerckt werden
  // nl = new line
  abstract public String genSourceCode(String tab, String preTab, String nl);

  public void setIsActive (boolean isActive) {
    this.isActive = isActive;
  }
  
  public boolean isActive() {
    return this.isActive;
  }
}
