package de.schmaeck.struktogrammeditor.model.environment;

import java.io.IOException;
import java.util.ArrayList;

public class EnvironmentTargetProgrammingLanguage {

  private String identifier;
  private int version;
  private String[] fileExtensions;
  private String mainName;
  private String mainType;
  private String[][] mainParamList;
  private String[] typeList;
  private String[] typeToolTipList;
  private String defaultProgramName;
  private String defaultMethodName;
  private boolean needUniqueName; // sonst: eindeutige Signatur (Name + ParamTypen)
  private String filterDescription;
  private ArrayList<String> reservedWordList;
  
  

  public EnvironmentTargetProgrammingLanguage (String fileName) throws IOException {
    try {
      ArrayList<String> al = Environment.loadFileToAL(fileName);
      int index = 0;
      String line = al.get(index);
      this.identifier = line;

      this.version = new Integer(line = al.get(++index));
      
      line = al.get(++index);
      
      // FileExtensions laden
      int number = new Integer(line);
      this.fileExtensions = new String[number];
      
      for (int i = 0; i < number; i++) {
        line = al.get(++index);
        this.fileExtensions[i] = line;
      }
      
      this.filterDescription = al.get(++index);
      this.mainName = al.get(++index);
      this.mainType = al.get(++index);
      this.mainParamList = new String[new Integer(al.get(++index))][2];
      for (int i = 0; i < this.mainParamList.length; i++) {
        this.mainParamList[i][0] = al.get(++index);
        this.mainParamList[i][1] = al.get(++index);
      }
      this.typeList = new String[new Integer(al.get(++index))];
      this.typeToolTipList = new String[this.typeList.length];
      for (int i = 0; i < this.typeList.length; i++) {
        this.typeList[i] = al.get(++index);
        this.typeToolTipList[i] = al.get(++index);
      }
      
      this.defaultProgramName = al.get(++index);
      this.defaultMethodName = al.get(++index);
      this.needUniqueName = new Boolean(al.get(++index));
      
      this.reservedWordList = new ArrayList<String>();
      index++;
      while(index < al.size()) {
        this.reservedWordList.add(al.get(index++));
      }

      
      
    } catch (Exception e) {
      e.printStackTrace();
      throw new IOException("Laden der EnvironmentTargetProgrammingLanguage nicht erfolgreich!");
      // Optional: Fehlermeldung ber Sprachdatei ;-)
    }
//    System.out.println(this.toString());
  }
  
  // param_string[] -> 0->typ, 1->name
  // TODO: fr fremde zielsprachen u.U. ber reg. ausdrcke o.. definieren. fr den hamster reicht dieses. 
  public String genFullMethodName(String name, String type, ArrayList<String[]> param) {
    String out = type + " " + name + "(";
    for (int i = 0; i < param.size(); i++) {
      if (i > 0) out = out + ", ";
      out = out + param.get(i)[0] + " " + param.get(i)[1];
    }
    out = out + ")";
    return out;
  }
  
  // Name wie er zum aufruf verwendet wird
  public String genMethodCallName(String name, ArrayList<String[]> param) {
    String out = name + "(";
    for (int i = 0; i < param.size(); i++) {
      if (i > 0) out = out + ", ";
      out = out + param.get(i)[1];
    }
    out = out + ");";
    return out;
  }
  
  // nur fr Testzwecke
  public String toString() {
    
    return this.identifier + "\n" 
    + this.version + "\n"
    + this.fileExtensions.length + "\n"
    + this.mainName + "\n"
    + this.mainType + "\n"
    + this.mainParamList.length + "\n"
    + this.typeList.length + "\n"
    ;
  }

  public String[] getFileExtensions() {
    return this.fileExtensions;    
  }

  public String getIdentifier () {
    return identifier;
  }

  public String getMainName () {
    return mainName;
  }

  public String[][] getMainParamList () {
    return mainParamList;
  }

  public String getMainType () {
    return mainType;
  }

  public String getDefaultMethodName () {
    return defaultMethodName;
  }

  public String[][] getDefaultParamList () {
    return new String[][]{};
  }

  public String getDefaultMethodType () {
    if (typeList.length == 0) return "";
    return typeList[0];
  }
  public String[] getTypeList () {
    return typeList;
  }

  public int getVersion () {
    return version;
  }

  public String getDefaultProgramName () {
    return this.defaultProgramName;
  }

  public boolean isNeedUniqueName () {
    return needUniqueName;
  }

  public String getFilterDescription () {
    return filterDescription;
  }

  public String[] getTypeToolTipList () {
    return typeToolTipList;
  }

  public ArrayList<String> getReservedWordList () {
    return reservedWordList;
  }

}
