package de.schmaeck.struktogrammeditor.model.environment;

import java.awt.Image;
import java.lang.reflect.InvocationTargetException;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

import de.schmaeck.struktogrammeditor.HaSE;

// Thread: Um qualitativ bessere Icons zu skalieren, die dem Progamm spter zur Verfgung
// gestellt werden
public class EnvironmentSimulator extends Thread {

//  private static final int SCALEITERATIONS = 8;    // Anzahl Iterationsschritte
//  private static final float SCALEFACTOR        = 1.3f; // Wachstumsfaktor pro Iterationsschritt; muss grer 1 sein!
//  private static final float SCALEINTVALUE      = 8f; // Kleinste Pixelgre / Startwert
//  private static final float SCALETARGETVALUE   = 80f; // Grte Pixelgre / Endwert (wird leicht BERschritten)
//
//  // Wie oben, fr die Schnelle Variante die Programmstartzeit kostet
//  private static final float FASTSCALEFACTOR        = 1.3f; // Wachstumsfaktor pro Iterationsschritt; muss grer 1 sein!
//  private static final float FASTSCALEINTVALUE      = 22.84f; // Kleinste Pixelgre / Startwert
//  private static final float FASTSCALETARGETVALUE   = 22f; // Grte Pixelgre / Endwert (wird leicht UNTERschritten)
//  
  private static final int[][] SCALEVALUES = new int[][]{{32}, {32}, 
    {8, 16, 32, 64}
  , {4, 8, 12, 16, 20, 26, 32, 40, 48, 58, 68, 80, 94, 120}
  };
  
  private static final String IPWALL = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Wall.png";
  private static final String IPBLANK = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Blank.png";
  private static final String IPNORTH = "de/schmaeck/struktogrammeditor/resource/HaSE Sim North.png";
  private static final String IPEAST = "de/schmaeck/struktogrammeditor/resource/HaSE Sim East.png";
  private static final String IPSOUTH = "de/schmaeck/struktogrammeditor/resource/HaSE Sim South.png";
  private static final String IPWEST = "de/schmaeck/struktogrammeditor/resource/HaSE Sim West.png";
  private static final String IPCORNNORTH = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn North.png";
  private static final String IPCORNEAST = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn East.png";
  private static final String IPCORNSOUTH = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn South.png";
  private static final String IPCORNWEST = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn West.png";
  private static final String IPCORN0 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 0.png";
  private static final String IPCORN1 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 1.png";
  private static final String IPCORN2 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 2.png";
  private static final String IPCORN3 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 3.png";
  private static final String IPCORN4 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 4.png";
  private static final String IPCORN5 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 5.png";
  private static final String IPCORN6 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 6.png";
  private static final String IPCORN7 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 7.png";
  private static final String IPCORN8 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 8.png";
  private static final String IPCORN9 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 9.png";
  private static final String IPCORN10 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 10.png";
  private static final String IPCORN11 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 11.png";
  private static final String IPCORN12 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 12.png";
  private static final String IPCORN13 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 13.png";
  private static final String IPCORN14 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 14.png";
  private static final String IPCORN15 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 15.png";
  private static final String IPCORN16 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 16.png";
  private static final String IPCORN17 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 17.png";
  private static final String IPCORN18 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 18.png";
  private static final String IPCORN19 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 19.png";
  private static final String IPCORN20 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 20.png";
  private static final String IPCORN21 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 21.png";
  private static final String IPCORN22 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 22.png";
  private static final String IPCORN23 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 23.png";
  private static final String IPCORN24 = "de/schmaeck/struktogrammeditor/resource/HaSE Sim Corn 24.png";
  
  // --
  private static final String IPTB2NEWPROG0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 0.png";
  private static final String IPTB2NEWPROG1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 1.png";
  private static final String IPTB2NEWPROG2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 2.png";
  private static final String IPTB2OPEN0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 0.png";
  private static final String IPTB2OPEN1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 1.png";
  private static final String IPTB2OPEN2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 2.png";
  private static final String IPTB2SAVE0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 0.png";
  private static final String IPTB2SAVE1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 1.png";
  private static final String IPTB2SAVE2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 2.png";
  private static final String IPTB2WALL0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Wall 0.png";
  private static final String IPTB2WALL1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Wall 1.png";
  private static final String IPTB2WALL2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Wall 2.png";
  private static final String IPTB2HAMSTER0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Hamster 0.png";
  private static final String IPTB2HAMSTER1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Hamster 1.png";
  private static final String IPTB2HAMSTER2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Hamster 2.png";
  private static final String IPTB2KORN0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Korn 0.png";
  private static final String IPTB2KORN1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Korn 1.png";
  private static final String IPTB2KORN2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Korn 2.png";
  private static final String IPTB2HAMKORNMINUS0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornMinus 0.png";
  private static final String IPTB2HAMKORNMINUS1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornMinus 1.png";
  private static final String IPTB2HAMKORNMINUS2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornMinus 2.png";
  private static final String IPTB2HAMKORNPLUS0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornPlus 0.png";
  private static final String IPTB2HAMKORNPLUS1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornPlus 1.png";
  private static final String IPTB2HAMKORNPLUS2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 HamKornPlus 2.png";
  private static final String IPTB2RESET0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Reset 0.png";
  private static final String IPTB2RESET1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Reset 1.png";
  private static final String IPTB2RESET2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Reset 2.png";
  private static final String IPTB2PLAY0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Play 0.png";
  private static final String IPTB2PLAY1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Play 1.png";
  private static final String IPTB2PLAY2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Play 2.png";
  private static final String IPTB2STEP0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Step 0.png";
  private static final String IPTB2STEP1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Step 1.png";
  private static final String IPTB2STEP2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Step 2.png";
  private static final String IPTB2PAUSE0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Pause 0.png";
  private static final String IPTB2PAUSE1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Pause 1.png";
  private static final String IPTB2PAUSE2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Pause 2.png";
  private static final String IPTB2STOP0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Stop 0.png";
  private static final String IPTB2STOP1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Stop 1.png";
  private static final String IPTB2STOP2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Stop 2.png";
  private static final String IPTB2EDIT0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Edit 0.png";
  private static final String IPTB2EDIT1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Edit 1.png";
  private static final String IPTB2EDIT2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB2 Edit 2.png";

  
  public HaSE editor;
  
  public ImageIcon iconTTB2New0;
  public ImageIcon iconTTB2New1;
  public ImageIcon iconTTB2New2;
  public ImageIcon iconTTB2Open0;
  public ImageIcon iconTTB2Open1;
  public ImageIcon iconTTB2Open2;
  public ImageIcon iconTTB2Save0;
  public ImageIcon iconTTB2Save1;
  public ImageIcon iconTTB2Save2;
  public ImageIcon iconTTB2Reset0;
  public ImageIcon iconTTB2Reset1;
  public ImageIcon iconTTB2Reset2;
  
  public ImageIcon iconTTB2Korn0;
  public ImageIcon iconTTB2Korn1;
  public ImageIcon iconTTB2Korn2;
  public ImageIcon iconTTB2Wall0;
  public ImageIcon iconTTB2Wall1;
  public ImageIcon iconTTB2Wall2;
  public ImageIcon iconTTB2Hamster0;
  public ImageIcon iconTTB2Hamster1;
  public ImageIcon iconTTB2Hamster2;
  public ImageIcon iconTTB2HamKornPlus0;
  public ImageIcon iconTTB2HamKornPlus1;
  public ImageIcon iconTTB2HamKornPlus2;
  public ImageIcon iconTTB2HamKornMinus0;
  public ImageIcon iconTTB2HamKornMinus1;
  public ImageIcon iconTTB2HamKornMinus2;

  public ImageIcon iconTTB2Play0;
  public ImageIcon iconTTB2Play1;
  public ImageIcon iconTTB2Play2;
  public ImageIcon iconTTB2Step0;
  public ImageIcon iconTTB2Step1;
  public ImageIcon iconTTB2Step2;
  public ImageIcon iconTTB2Pause0;
  public ImageIcon iconTTB2Pause1;
  public ImageIcon iconTTB2Pause2;
  public ImageIcon iconTTB2Stop0;
  public ImageIcon iconTTB2Stop1;
  public ImageIcon iconTTB2Stop2;
  public ImageIcon iconTTB2Edit0;
  public ImageIcon iconTTB2Edit1;
  public ImageIcon iconTTB2Edit2;

  // ---
  
  public int scaleIndex;   // index der aktuell zu verwendenen icons
  public ImageIcon iconWall;
  public ImageIcon iconBlank;
  public ImageIcon iconNorth;
  public ImageIcon iconSouth;
  public ImageIcon iconEast;
  public ImageIcon iconWest;
  public ImageIcon iconCornNorth;
  public ImageIcon iconCornEast;
  public ImageIcon iconCornSouth;
  public ImageIcon iconCornWest;
  public ImageIcon[] iconCorn;

  public int[] widthArray; // gibt zu jedem index die kachelbreite in pixeln an
  public ImageIcon[] scaledIconWall;
  public ImageIcon[] scaledIconBlank;
  public ImageIcon[] scaledIconNorth;
  public ImageIcon[] scaledIconSouth;
  public ImageIcon[] scaledIconEast;
  public ImageIcon[] scaledIconWest;
  public ImageIcon[] scaledIconCornNorth;
  public ImageIcon[] scaledIconCornEast;
  public ImageIcon[] scaledIconCornSouth;
  public ImageIcon[] scaledIconCornWest;
  public ImageIcon[][] scaledIconCorn;
  
  public int[] tempWidthArray; // gibt zu jedem index die kachelbreite in pixeln an
  public ImageIcon[] tempScaledIconWall;
  public ImageIcon[] tempScaledIconBlank;
  public ImageIcon[] tempScaledIconNorth;
  public ImageIcon[] tempScaledIconSouth;
  public ImageIcon[] tempScaledIconEast;
  public ImageIcon[] tempScaledIconWest;
  public ImageIcon[] tempScaledIconCornNorth;
  public ImageIcon[] tempScaledIconCornEast;
  public ImageIcon[] tempScaledIconCornSouth;
  public ImageIcon[] tempScaledIconCornWest;
  public ImageIcon[][] tempScaledIconCorn;
  
  public EnvironmentSimulator(HaSE editor) {
    
    this.editor = editor;
    
    this.iconWall = new ImageIcon(ClassLoader.getSystemResource(IPWALL));
    this.iconBlank = new ImageIcon(ClassLoader.getSystemResource(IPBLANK));
    this.iconNorth = new ImageIcon(ClassLoader.getSystemResource(IPNORTH));
    this.iconEast = new ImageIcon(ClassLoader.getSystemResource(IPEAST));
    this.iconSouth = new ImageIcon(ClassLoader.getSystemResource(IPSOUTH));
    this.iconWest = new ImageIcon(ClassLoader.getSystemResource(IPWEST));
    this.iconCornNorth = new ImageIcon(ClassLoader.getSystemResource(IPCORNNORTH));
    this.iconCornEast = new ImageIcon(ClassLoader.getSystemResource(IPCORNEAST));
    this.iconCornSouth = new ImageIcon(ClassLoader.getSystemResource(IPCORNSOUTH));
    this.iconCornWest = new ImageIcon(ClassLoader.getSystemResource(IPCORNWEST));
    this.iconCorn = new ImageIcon[]{
        new ImageIcon(ClassLoader.getSystemResource(IPCORN0)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN1)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN2)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN3)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN4)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN5)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN6)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN7)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN8)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN9)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN10)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN11)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN12)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN13)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN14)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN15)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN16)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN17)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN18)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN19)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN20)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN21)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN22)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN23)),
        new ImageIcon(ClassLoader.getSystemResource(IPCORN24))
    };
    
    iconTTB2New0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2NEWPROG0 ));
    iconTTB2New1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2NEWPROG1 ));
    iconTTB2New2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2NEWPROG2 ));
    iconTTB2Open0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2OPEN0 ));
    iconTTB2Open1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2OPEN1 ));
    iconTTB2Open2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2OPEN2 ));
    iconTTB2Save0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2SAVE0 ));
    iconTTB2Save1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2SAVE1 ));
    iconTTB2Save2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2SAVE2 ));
    iconTTB2Reset0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2RESET0 ));
    iconTTB2Reset1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2RESET1 ));
    iconTTB2Reset2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2RESET2 ));
    
    iconTTB2Korn0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2KORN0 ));
    iconTTB2Korn1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2KORN1 ));
    iconTTB2Korn2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2KORN2 ));
    iconTTB2Wall0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2WALL0 ));
    iconTTB2Wall1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2WALL1 ));
    iconTTB2Wall2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2WALL2 ));
    iconTTB2Hamster0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMSTER0 ));
    iconTTB2Hamster1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMSTER1 ));
    iconTTB2Hamster2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMSTER2 ));
    iconTTB2HamKornPlus0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNPLUS0 ));
    iconTTB2HamKornPlus1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNPLUS1 ));
    iconTTB2HamKornPlus2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNPLUS2 ));
    iconTTB2HamKornMinus0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNMINUS0 ));
    iconTTB2HamKornMinus1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNMINUS1 ));
    iconTTB2HamKornMinus2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2HAMKORNMINUS2 ));

    iconTTB2Play0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PLAY0 ));
    iconTTB2Play1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PLAY1 ));
    iconTTB2Play2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PLAY2 ));
    iconTTB2Step0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STEP0 ));
    iconTTB2Step1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STEP1 ));
    iconTTB2Step2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STEP2 ));
    iconTTB2Pause0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PAUSE0 ));
    iconTTB2Pause1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PAUSE1 ));
    iconTTB2Pause2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2PAUSE2 ));
    iconTTB2Stop0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STOP0 ));
    iconTTB2Stop1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STOP1 ));
    iconTTB2Stop2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2STOP2 ));
    iconTTB2Edit0 = new ImageIcon(ClassLoader.getSystemResource( IPTB2EDIT0 ));
    iconTTB2Edit1 = new ImageIcon(ClassLoader.getSystemResource( IPTB2EDIT1 ));
    iconTTB2Edit2 = new ImageIcon(ClassLoader.getSystemResource( IPTB2EDIT2 ));
    
    
    // Vorbereiten der scaled Icons
    
    scaleIndex = 0;
    preScaleIconsFast();   
    
    this.setPriority(Thread.MIN_PRIORITY); // dibo
    this.start(); // startet das berechnen von qualitativ besseren icons
  }
  
  // Sucht und setzt zu einer gegebenen Wunschbreite den grtmglichen 
  // Skalierungsindex, dessen Breite kleiner gleich der Wunschbreite ist
  public void selectScaleLevel(int width) {
    //if (true) return;
    this.scaleIndex = 0;
    for (int i = this.widthArray.length-1; i >= 0; i--) {
      if (this.widthArray[i] <= width) {
        this.scaleIndex = i;
        break;
      }
    }
  }

  public void preScaleIconsFast() {
    int indexCounter = SCALEVALUES[0].length;
          
    this.scaledIconWall = new ImageIcon[indexCounter];
    this.scaledIconBlank = new ImageIcon[indexCounter];
    this.scaledIconNorth = new ImageIcon[indexCounter];
    this.scaledIconSouth = new ImageIcon[indexCounter];
    this.scaledIconEast = new ImageIcon[indexCounter];
    this.scaledIconWest = new ImageIcon[indexCounter];
    this.scaledIconCornNorth = new ImageIcon[indexCounter];
    this.scaledIconCornSouth = new ImageIcon[indexCounter];
    this.scaledIconCornEast = new ImageIcon[indexCounter];
    this.scaledIconCornWest = new ImageIcon[indexCounter];
    this.scaledIconCorn = new ImageIcon[indexCounter][25];
    this.widthArray = SCALEVALUES[0];
    
    for (int i = 0; i < indexCounter; i++) {
      scaleIconsFast(SCALEVALUES[0][i], i);
    }
  }
  
  public void run() {
    try {
      // Es gibt in der init-phase genug zu tun. Das hier kann erstmal warten.
      Thread.sleep(1); // 0.75 sec dibo
    } catch (Exception e) {
    }
    for (int i = 1; i < SCALEVALUES.length; i++) {
      preScaleSmooth(SCALEVALUES[i]);
    }
    // TODO: next: wieder lschen
    editor.viewAPI.setStatusText(">>Skalierungsberechnungen fr Kachelgrafiken abgeschlossen.<<", 3000);
  }
  
  public void preScaleSmooth(int[] scaleValues) {
    
    int indexCounter = scaleValues.length;
    
    // temp IconArrays anlegen
    this.tempScaledIconWall = new ImageIcon[indexCounter];
    this.tempScaledIconBlank = new ImageIcon[indexCounter];
    this.tempScaledIconNorth = new ImageIcon[indexCounter];
    this.tempScaledIconSouth = new ImageIcon[indexCounter];
    this.tempScaledIconEast = new ImageIcon[indexCounter];
    this.tempScaledIconWest = new ImageIcon[indexCounter];
    this.tempScaledIconCornNorth = new ImageIcon[indexCounter];
    this.tempScaledIconCornSouth = new ImageIcon[indexCounter];
    this.tempScaledIconCornEast = new ImageIcon[indexCounter];
    this.tempScaledIconCornWest = new ImageIcon[indexCounter];
    this.tempScaledIconCorn = new ImageIcon[indexCounter][25];
    this.tempWidthArray = scaleValues;
    
    int width = 0;
    // Skalierungen. Das dauert.
    for (int i = 0; i < indexCounter; i++) {

      width = scaleValues[i];

      tempScaledIconWall[i] = new ImageIcon(this.iconWall.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconBlank[i] = new ImageIcon(this.iconBlank.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconNorth[i] = new ImageIcon(this.iconNorth.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconSouth[i] = new ImageIcon(this.iconSouth.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconEast[i] = new ImageIcon(this.iconEast.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconWest[i] = new ImageIcon(this.iconWest.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconCornNorth[i] = new ImageIcon(this.iconCornNorth.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconCornSouth[i] = new ImageIcon(this.iconCornSouth.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconCornEast[i] = new ImageIcon(this.iconCornEast.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      tempScaledIconCornWest[i] = new ImageIcon(this.iconCornWest.getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      for (int j = 0; j < 25; j++) {
        tempScaledIconCorn[i][j] = new ImageIcon(this.iconCorn[j].getImage().getScaledInstance(width, width, Image.SCALE_SMOOTH));
      }
    }
    
    // ersetzten der temp. FAST-Icons durch die neuen Guten. 
    try {
      SwingUtilities.invokeAndWait(new Runnable() {
        public void run () {
          scaledIconBlank = tempScaledIconBlank;
          scaledIconWall = tempScaledIconWall;
          scaledIconNorth = tempScaledIconNorth;
          scaledIconSouth = tempScaledIconSouth;
          scaledIconEast = tempScaledIconEast;
          scaledIconWest = tempScaledIconWest;
          scaledIconCornNorth = tempScaledIconCornNorth;
          scaledIconCornSouth = tempScaledIconCornSouth;
          scaledIconCornEast = tempScaledIconCornEast;
          scaledIconCornWest = tempScaledIconCornWest;
          scaledIconCorn = tempScaledIconCorn;
          widthArray = tempWidthArray;
          
          tempScaledIconBlank = null;
          tempScaledIconWall = null;
          tempScaledIconBlank = null;
          tempScaledIconNorth = null;
          tempScaledIconSouth = null;
          tempScaledIconEast = null;
          tempScaledIconWest = null;
          tempScaledIconCornNorth = null;
          tempScaledIconCornSouth = null;
          tempScaledIconCornEast = null;
          tempScaledIconCornWest = null;
          tempScaledIconCorn = null;
          
          editor.gui.getSimulatorPanel().updateView(true);
        }
      });
    } catch (InterruptedException e) {
    } catch (InvocationTargetException e) {
    }
  }

  
  private void scaleIconsFast(int width, int targetIndex) {
    this.scaledIconWall[targetIndex] = new ImageIcon(this.iconWall.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconBlank[targetIndex] = new ImageIcon(this.iconBlank.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconNorth[targetIndex] = new ImageIcon(this.iconNorth.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconSouth[targetIndex] = new ImageIcon(this.iconSouth.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconEast[targetIndex] = new ImageIcon(this.iconEast.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconWest[targetIndex] = new ImageIcon(this.iconWest.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconCornNorth[targetIndex] = new ImageIcon(this.iconCornNorth.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconCornSouth[targetIndex] = new ImageIcon(this.iconCornSouth.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconCornEast[targetIndex] = new ImageIcon(this.iconCornEast.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    this.scaledIconCornWest[targetIndex] = new ImageIcon(this.iconCornWest.getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    //this.scaledIconCorn[targetIndex] = new ImageIcon[25];
    for (int i = 0; i < 25; i++) {
      this.scaledIconCorn[targetIndex][i] = new ImageIcon(this.iconCorn[i].getImage().getScaledInstance(width, width, Image.SCALE_FAST));
    }
  }
  



  // Diese Getter liefern die Icons abhngig von der aktuell eingestellten Skalierungsstufe
  public ImageIcon getScaledIconWall() {
    return this.scaledIconWall[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconBlank() {
    return this.scaledIconBlank[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconNorth() {
    return this.scaledIconNorth[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconSouth() {
    return this.scaledIconSouth[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconEast() {
    return this.scaledIconEast[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconWest() {
    return this.scaledIconWest[this.scaleIndex];
  }

  public ImageIcon getScaledIconCornNorth() {
    return this.scaledIconCornNorth[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconCornEast() {
    return this.scaledIconCornEast[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconCornSouth() {
    return this.scaledIconCornSouth[this.scaleIndex];
  }
  
  public ImageIcon getScaledIconCornWest() {
    return this.scaledIconCornWest[this.scaleIndex];
  }
  
  public ImageIcon[] getScaledIconCorn() {
    return this.scaledIconCorn[this.scaleIndex];
  }
   
}
