package de.schmaeck.struktogrammeditor.model.environment;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

/**
 * - Sprachkonstanten
 * 
 * @author Martin Schmaeck
 * 
 */
public class EnvironmentLanguage {

	// allg.
	public static final int TITLE = 0;
	public static final int TITLECONDITIONDIALOG = TITLE + 1;
	public static final int DIALOGOK = TITLE + 2;
	public static final int DIALOGCANCEL = TITLE + 3;
	public static final int CONDITIONCOMPOSING = TITLE + 4;
	public static final int TOOLTIPPOPUPMENUBLOCKTYP = TITLE + 5;
	public static final int TOOLTIPPOPUPMENUCONDITIONTYP = TITLE + 6;
	public static final int TOOLTIPPOPUPMENUMETHODTYPE = TITLE + 7;
	public static final int SUBCONDITIONATOM = TITLE + 8;
	public static final int SUBCONDITIONSELF = TITLE + 9;
	public static final int SUBCONDITIONCOMPOSING = TITLE + 10;
	public static final int SUBCONDITIONCOMPOSINGENCLOSE = TITLE + 11;
	public static final int SUBCONDITIONCOMPOSINGREPLACEA = TITLE + 12;
	public static final int SUBCONDITIONCOMPOSINGREPLACEB = TITLE + 13;
	public static final int DNDTOOLTIP = TITLE + 14;
	public static final int DNDMOVE = TITLE + 15;
	public static final int DNDCOPY = TITLE + 16;
	public static final int DNDCANCEL = TITLE + 17;
	public static final int METHODNAMECHANGE = TITLE + 18;
	public static final int TITLEMETHODNAMEDIALOG = TITLE + 19;
	public static final int METHODNAMENOTALLOWED = TITLE + 20;

	// status
	public static final int STATUSDEFAULTTEXT = TITLE + 21;
	public static final int STATUSNONSAVED = STATUSDEFAULTTEXT + 1;
	public static final int STATUSSAVED = STATUSDEFAULTTEXT + 2;
	public static final int STATUSSAVING = STATUSDEFAULTTEXT + 3;
	public static final int STATUSNEW = STATUSDEFAULTTEXT + 4;
	public static final int STATUSOPEN = STATUSDEFAULTTEXT + 5;
	public static final int STATUSSAVE = STATUSDEFAULTTEXT + 6;
	public static final int STATUSNEWMETHOD = STATUSDEFAULTTEXT + 7;
	public static final int STATUSCUT = STATUSDEFAULTTEXT + 8;
	public static final int STATUSCOPY = STATUSDEFAULTTEXT + 9;
	public static final int STATUSPASTE = STATUSDEFAULTTEXT + 10;
	public static final int STATUSPASTENOT = STATUSDEFAULTTEXT + 11;
	public static final int STATUSDELETE = STATUSDEFAULTTEXT + 12;
	public static final int STATUSPRINT = STATUSDEFAULTTEXT + 13;
	public static final int STATUSNEWSEBLOCK = STATUSDEFAULTTEXT + 14;
	public static final int STATUSNEWSEIF = STATUSDEFAULTTEXT + 15;
	public static final int STATUSNEWSEFIRSTLOOP = STATUSDEFAULTTEXT + 16;
	public static final int STATUSNEWSELASTLOOP = STATUSDEFAULTTEXT + 17;
	public static final int STATUSPOSITIONCURSOR = STATUSDEFAULTTEXT + 18;
	public static final int STATUSSEEDIT = STATUSDEFAULTTEXT + 19;
	public static final int STATUSSESELECTTYPE = STATUSDEFAULTTEXT + 20;
	public static final int STATUSSESELECTSE = STATUSDEFAULTTEXT + 21;
	public static final int STATUSMTBCUT = STATUSDEFAULTTEXT + 22;
	public static final int STATUSMTBCOPY = STATUSDEFAULTTEXT + 23;
	public static final int STATUSMTBPASTE = STATUSDEFAULTTEXT + 24;
	public static final int STATUSMTBDELETE = STATUSDEFAULTTEXT + 25;
	public static final int STATUSUNDO = STATUSDEFAULTTEXT + 26;
	public static final int STATUSREDO = STATUSDEFAULTTEXT + 27;
	public static final int STATUSOPENFAILED = STATUSDEFAULTTEXT + 28;
	public static final int STATUSRETURNREMOVE = STATUSDEFAULTTEXT + 29;
	public static final int STATUSNEWCALL = STATUSDEFAULTTEXT + 30;
	public static final int STATUSMETHODNAMECHANGE = STATUSDEFAULTTEXT + 31;

	// menu: file
	public static final int FILE = STATUSDEFAULTTEXT + 32;
	public static final int NEWPROGRAM = FILE + 1;
	public static final int OPEN = FILE + 2;
	public static final int CLOSE = FILE + 3;
	public static final int CLOSEALL = FILE + 4;
	public static final int SAVE = FILE + 5;
	public static final int SAVEAS = FILE + 6;
	public static final int SOURCEGEN = FILE + 7;
	public static final int IMPORT = FILE + 8;
	public static final int EXPORT = FILE + 9;
	public static final int EDITPROG = FILE + 10;
	public static final int PRINT = FILE + 11;
	public static final int PRINT2 = FILE + 12;
	public static final int OPENRECENT = FILE + 13;
	public static final int EXIT = FILE + 14;

	// menu: edit
	public static final int EDIT = FILE + 15;
	public static final int UNDO = EDIT + 1;
	public static final int REDO = EDIT + 2;
	public static final int CUT = EDIT + 3;
	public static final int COPY = EDIT + 4;
	public static final int INSERT = EDIT + 5;
	public static final int DELETE = EDIT + 6;
	public static final int SELECTALL = EDIT + 7;
	public static final int EDITSE = EDIT + 8;
	public static final int NEWMETHOD = EDIT + 9;

	// menu: extras
	public static final int EXTRAS = EDIT + 10;
	public static final int OPTIONS = EXTRAS + 1;

	// menu: info
	public static final int INFO = EXTRAS + 2;
	public static final int ABOUTHASE = INFO + 1;
	public static final int HELP = INFO + 2;
	public static final int WEBHAMSTER = INFO + 3;
	public static final int WEBHASE = INFO + 4;
	public static final int WEBUPDATE = INFO + 5;
	public static final int CONTACT = INFO + 6;
	public static final int ERRORREPORT = INFO + 7;
	public static final int IMPROVEMENT = INFO + 8;
	public static final int GUESTBOOK = INFO + 9;
	public static final int STRUKTOGRAMME = INFO + 4; // dibo

	private static int LABELSIZE = 22; // == last index +1
	private ArrayList<String> label; // enthlt die bezeichnungen

	/**
   */
	public EnvironmentLanguage(String fileName) {
		this.label = Environment.loadFileToAL(fileName);
	}

	// public EnvironmentLanguage () {
	// this.loadDefaults();
	// }
	//
	// /**
	// * Defaultwerte erzeugen
	// *
	// */
	// private void loadDefaults () {
	// this.label = new String[]{
	// "HaSE Hamster StruktogrammEditor [DE] [file]",
	// "Have a nice day!"};
	// // TODO! Optional. aber erst, wenn die languagedateien mal 'fertig' sind
	//
	//
	// }

	public String get(int index) {
		return this.label.get(index);
	}

}
