package de.schmaeck.struktogrammeditor.model.environment;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.ImageIcon;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.RequestRejectedExecption;
import de.schmaeck.struktogrammeditor.controller.ControlAPI;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.view.skins.SimpleISOSkin;
import de.schmaeck.struktogrammeditor.view.skins.Skin;

/**
 * - Quasi-Globale Umgebungsvariablen - Erbt von Thread weil: Nebenlufiges laden spart Zeit
 * 
 * hinweis: neue Umgebungsvariablen mssen an folgenden Stellen hinzugefgt werden: 
 *   - als objektvariable, suche: HIER ... 
 *   - mit getter/setter, suche: HIER ... (oder halt als public o..)
 *   - beim load, suche: HIER ... 
 *   - beim save, suche: HIER ... 
 *   - beim load_defualts, suche HIER: ... 
 *   - value in der config-datei
 * 
 * @author Martin Schmaeck
 * 
 */
public class Environment extends Thread {


  // ---[ Konstanten ]---------------------------------------------------------

  public static final int MINWIDTH = 120;
  // Standarddateiname der Konfigurationsdatei
  private static final String FILENAME = ".HamsterStruktogrammEditor.config";
  
  // IconPath
  private static final String IPPROGRAM = "de/schmaeck/struktogrammeditor/resource/HaSE Icon32.png";
  private static final String IPHAMSTER2B = "de/schmaeck/struktogrammeditor/resource/Hamster2bOrNot2b.png";

  private static final String IPSPACEBUTTONBLOCK0 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Block 0.png";
  private static final String IPSPACEBUTTONBLOCK1 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Block 1.png";
  private static final String IPSPACEBUTTONBLOCK2 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Block 2.png";
  private static final String IPSPACEBUTTONBLOCK3 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Block 3.png";
  private static final String IPSPACEBUTTONIF0 = "de/schmaeck/struktogrammeditor/resource/HaSE Space If 0.png";
  private static final String IPSPACEBUTTONIF1 = "de/schmaeck/struktogrammeditor/resource/HaSE Space If 1.png";
  private static final String IPSPACEBUTTONIF2 = "de/schmaeck/struktogrammeditor/resource/HaSE Space If 2.png";
  private static final String IPSPACEBUTTONIF3 = "de/schmaeck/struktogrammeditor/resource/HaSE Space If 3.png";
  private static final String IPSPACEBUTTONFIRSTLOOP0 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestFirstLoop 0.png";
  private static final String IPSPACEBUTTONFIRSTLOOP1 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestFirstLoop 1.png";
  private static final String IPSPACEBUTTONFIRSTLOOP2 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestFirstLoop 2.png";
  private static final String IPSPACEBUTTONFIRSTLOOP3 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestFirstLoop 3.png";
  private static final String IPSPACEBUTTONLASTLOOP0 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestLastLoop 0.png";
  private static final String IPSPACEBUTTONLASTLOOP1 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestLastLoop 1.png";
  private static final String IPSPACEBUTTONLASTLOOP2 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestLastLoop 2.png";
  private static final String IPSPACEBUTTONLASTLOOP3 = "de/schmaeck/struktogrammeditor/resource/HaSE Space TestLastLoop 3.png";
  private static final String IPSPACEBUTTONINSERT0 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Paste 0.png";
  private static final String IPSPACEBUTTONINSERT1 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Paste 1.png";
  private static final String IPSPACEBUTTONINSERT2 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Paste 2.png";
  private static final String IPSPACEBUTTONINSERT3 = "de/schmaeck/struktogrammeditor/resource/HaSE Space Paste 3.png";

  private static final String IPSEBUTTONCUT0 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Cut 0.png";
  private static final String IPSEBUTTONCUT1 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Cut 1.png";
  private static final String IPSEBUTTONCUT2 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Cut 2.png";
  private static final String IPSEBUTTONCUT3 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Cut 3.png";
  private static final String IPSEBUTTONCOPY0 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Copy 0.png";
  private static final String IPSEBUTTONCOPY1 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Copy 1.png";
  private static final String IPSEBUTTONCOPY2 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Copy 2.png";
  private static final String IPSEBUTTONCOPY3 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Copy 3.png";
  private static final String IPSEBUTTONDELETE0 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Delete 0.png";
  private static final String IPSEBUTTONDELETE1 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Delete 1.png";
  private static final String IPSEBUTTONDELETE2 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Delete 2.png";
  private static final String IPSEBUTTONDELETE3 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Delete 3.png";
  private static final String IPSEBUTTONEDIT0 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Edit 0.png";
  private static final String IPSEBUTTONEDIT1 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Edit 1.png";
  private static final String IPSEBUTTONEDIT2 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Edit 2.png";
  private static final String IPSEBUTTONEDIT3 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Edit 3.png";
  private static final String IPSEBUTTONSELECT0 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Select 0.png";
  private static final String IPSEBUTTONSELECT1 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Select 1.png";
  private static final String IPSEBUTTONSELECT2 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Select 2.png";
  private static final String IPSEBUTTONSELECT3 = "de/schmaeck/struktogrammeditor/resource/HaSE Se Select 3.png";
  private static final String IPSESEPERATOR = "de/schmaeck/struktogrammeditor/resource/HaSE Se Seperator.png";
  private static final String IPMTBNEWMETHOD0 = "de/schmaeck/struktogrammeditor/resource/HaSE MTB NewMethod 0.png";
  private static final String IPMTBNEWMETHOD1 = "de/schmaeck/struktogrammeditor/resource/HaSE MTB NewMethod 1.png";
  private static final String IPMTBNEWMETHOD2 = "de/schmaeck/struktogrammeditor/resource/HaSE MTB NewMethod 2.png";

  private static final String IPBUTTONBAR3 = "de/schmaeck/struktogrammeditor/resource/HaSE IconBox3.png";
  private static final String IPBUTTONBAR2 = "de/schmaeck/struktogrammeditor/resource/HaSE IconBox2.png";
  private static final String IPBUTTONBAR1 = "de/schmaeck/struktogrammeditor/resource/HaSE IconBox1.png";

  private static final String IPPICTRUE = "de/schmaeck/struktogrammeditor/resource/HaSE true.png";
  private static final String IPPICFALSE = "de/schmaeck/struktogrammeditor/resource/HaSE false.png";
  
  private static final String IPTBNEWPROG0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 0.png";
  private static final String IPTBNEWPROG1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 1.png";
  private static final String IPTBNEWPROG2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB New 2.png";
  private static final String IPTBOPEN0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 0.png";
  private static final String IPTBOPEN1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 1.png";
  private static final String IPTBOPEN2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Open 2.png";
  private static final String IPTBSAVE0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 0.png";
  private static final String IPTBSAVE1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 1.png";
  private static final String IPTBSAVE2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Save 2.png";
  private static final String IPTBPRINT0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Print 0.png";
  private static final String IPTBPRINT1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Print 1.png";
  private static final String IPTBPRINT2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Print 2.png";
  private static final String IPTBPUNDO0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Undo 0.png";
  private static final String IPTBPUNDO1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Undo 1.png";
  private static final String IPTBPUNDO2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Undo 2.png";
  private static final String IPTBPUNDO3 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Undo 3.png";
  private static final String IPTBPREDO0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Redo 0.png";
  private static final String IPTBPREDO1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Redo 1.png";
  private static final String IPTBPREDO2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Redo 2.png";
  private static final String IPTBPREDO3 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Redo 3.png";
  private static final String IPTBPCUT0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Cut 0.png";
  private static final String IPTBPCUT1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Cut 1.png";
  private static final String IPTBPCUT2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Cut 2.png";
  private static final String IPTBPCUT3 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Cut 3.png";
  private static final String IPTBPCOPY0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Copy 0.png";
  private static final String IPTBPCOPY1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Copy 1.png";
  private static final String IPTBPCOPY2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Copy 2.png";
  private static final String IPTBPCOPY3 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Copy 3.png";
  private static final String IPTBPPASTE0 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Paste 0.png";
  private static final String IPTBPPASTE1 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Paste 1.png";
  private static final String IPTBPPASTE2 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Paste 2.png";
  private static final String IPTBPPASTE3 = "de/schmaeck/struktogrammeditor/resource/HaSE TTB Paste 3.png";

  
  private static final String TABCLOSEBUTTONICON = "de/schmaeck/struktogrammeditor/resource/HaSE Icon TabClose.png";
  private static final String IPTTBSEPERATOR = "de/schmaeck/struktogrammeditor/resource/HaSE Icon TTB Seperator.png";

  // Namensbasis der Sprachdateien, Defaultnamen von Konfiurationsdateien
  private static final String LANGUAGEDEFAULTFILENAME = ".HamsterStruktogrammEditorLanguage."; // +de, +en, ...
  private static final String ATOMBLOCKDEFAULTFILENAME = "AtomicVoidStructureElementBlocks.config";
  private static final String ATOMCONDITIONDEFAULTFILENAME = "AtomicBooleanStructureElementConditions.config";
  private static final String CONDITIONCOMPOSITIONDEFAULTFILENAME = "ComposingConditionFunctions.confg";
  
  private static final String KEYBINDINGDEFAULTFILENAME = ".KeyBindings.config";
  
  // Ladesatus Konstanten mit Werten von 0 bis 100 Prozent
  public static final int LOADEDNOTHING =  15;
  public static final int LOADEDICON    =  25;
  public static final int LOADEDLAF     =  30;
  public static final int LOADEDGUISIZE =  35;
  public static final int LOADEDCONTROLAPI = 40;
  public static final int LOADEDLANGUAGEFILE   =  45;
  public static final int LOADEDFILE2   =  50;
  public static final int LOADEDFILE3   =  55;
  public static final int LOADEDFILE4   =  60;
  public static final int LOADEDKEYBINDINGS = 65;
  public static final int LOADEDTARGETPROGRAMMINGLANGUAGE = 70;
  public static final int LOADEDSKIN    =  90;
  public static final int LOADEDALL     = 100;

  


  // ---[ Variablen ]----------------------------------------------------------

  private HaSE editor;
  
  // nimmt Fehlermeldungen, bestimmte Statusmeldungen und Debuginformationen entgegen
  public ErrorLog errorLog;

  // Ladestatus der Umgebungsvariablen. Wird zur partiellen Synchronisation mit dem GUI verwendet.
  private int loadingState;

  // Enthlt das aktuelle 'Skin', welches insbesondere fr das Zeichnen der Struktogramme zustndig ist.
  public Skin skin;

  // Enthlt in der GUI verwendete Bezeichnungen in der aktuell eingestellten Sprache
  public EnvironmentLanguage language;
  public EnvironmentTargetProgrammingLanguage targetProgrammingLanguage;
  public EnvironmentSimulator simulator;

  // elementare Programmiersprachenbestandteile
  public ArrayList<AtomicItem> atomBlockList;
  public ArrayList<Integer> atomBlockSeperatorList;
  public ArrayList<AtomicItem> atomConditionList;
  public ArrayList<Integer> atomConditionSeperatorList;
  public ArrayList<ConditionComposition> conditionCompositionList;
  public ArrayList<Integer> conditionCompositionSeperatorList;
  
  public ArrayList<KeyBinding> keyBindings;

  // Soll eine Konfigurationsdatei zum Laden und Speichern der Umgebungsvariablen verwendet werden?
  private boolean useConfigFile;

  // Pfad inkl. Dateinamen der Konfigurationsdatei
  private String configFileName;

  // Java Properties
  private String sep; // FileSeperator

  private String nl; // new line

  private String userTmpDir; // temp-dir

  private String userHome; // home-dir

  private String userDir; // aktuelles Verzeichnis (!= programmverzeichnis!)

  private String userName;

  private String userLanguage;

  // TODO: load/save: Skin

  // Liste mit verfgbaren Skins
  private Skin[] skinList;


  // --- Konfigurationsdateivariablen -----
  private boolean useLaF; // Look and Feel

  private String nameLaF;

  private boolean useSavedGUICoordinates;

  private int windowExtendedState; // -> maximiert, normal, minimiert

  private int windowWidth;

  private int windowHeight;

  private int windowPositionX; // Kante links

  private int windowPositionY; // Kante oben

  // TODO -> skin
  private Color backGroundColor;

  private boolean enableHiddenFeatures;

  private boolean easyMode;

  private String languageFile;

  private int skinSelection = 0; // builtInSkin-Index oder -1 [...]

  private String skinPath;

  private int fontSize = 18;

  private int fontSelection = -1;

  private String atomBlockFile;

  private String atomConditionFile;

  private String conditionCompositionFile;
  private String keyBindingsFile;
  private int undoDepth;
  private String targetProgrammingLanguageFileName;
  private int messageLifeTime;

  // Programmicon
  public ImageIcon icon;
  public ImageIcon hamster2bOrNot2b;
  public ImageIcon iconTabClose;
  
  public ImageIcon iconTrue;
  public ImageIcon iconFalse;

  public ImageIcon iconSpaceBlock0;
  public ImageIcon iconSpaceBlock1;
  public ImageIcon iconSpaceBlock2;
  public ImageIcon iconSpaceBlock3;
  public ImageIcon iconSpaceIf0;
  public ImageIcon iconSpaceIf1;
  public ImageIcon iconSpaceIf2;
  public ImageIcon iconSpaceIf3;
  public ImageIcon iconSpaceFirstLoop0;
  public ImageIcon iconSpaceFirstLoop1;
  public ImageIcon iconSpaceFirstLoop2;
  public ImageIcon iconSpaceFirstLoop3;
  public ImageIcon iconSpaceLastLoop0;
  public ImageIcon iconSpaceLastLoop1;
  public ImageIcon iconSpaceLastLoop2;
  public ImageIcon iconSpaceLastLoop3;
  public ImageIcon iconSpaceInsert0;
  public ImageIcon iconSpaceInsert1;
  public ImageIcon iconSpaceInsert2;
  public ImageIcon iconSpaceInsert3;

  public ImageIcon iconSeCut0;
  public ImageIcon iconSeCut1;
  public ImageIcon iconSeCut2;
  public ImageIcon iconSeCut3;
  public ImageIcon iconSeCopy0;
  public ImageIcon iconSeCopy1;
  public ImageIcon iconSeCopy2;
  public ImageIcon iconSeCopy3;
  public ImageIcon iconSeDelete0;
  public ImageIcon iconSeDelete1;
  public ImageIcon iconSeDelete2;
  public ImageIcon iconSeDelete3;
  public ImageIcon iconSeSelect0;
  public ImageIcon iconSeSelect1;
  public ImageIcon iconSeSelect2;
  public ImageIcon iconSeSelect3;
  public ImageIcon iconSeEdit0;
  public ImageIcon iconSeEdit1;
  public ImageIcon iconSeEdit2;
  public ImageIcon iconSeEdit3;
  public ImageIcon iconSeSeperator;
  public ImageIcon iconMTBNewMethod0;
  public ImageIcon iconMTBNewMethod1;
  public ImageIcon iconMTBNewMethod2;

  public ImageIcon iconBar3;
  public ImageIcon iconBar2;
  public ImageIcon iconBar1;
  public ImageIcon iconTTBNew0;
  public ImageIcon iconTTBNew1;
  public ImageIcon iconTTBNew2;
  public ImageIcon iconTTBOpen0;
  public ImageIcon iconTTBOpen1;
  public ImageIcon iconTTBOpen2;
  public ImageIcon iconTTBSave0;
  public ImageIcon iconTTBSave1;
  public ImageIcon iconTTBSave2;
  public ImageIcon iconTTBPrint0;
  public ImageIcon iconTTBPrint1;
  public ImageIcon iconTTBPrint2;
  public ImageIcon iconTTBSeperator;
  public ImageIcon iconTTBCut0;
  public ImageIcon iconTTBCut1;
  public ImageIcon iconTTBCut2;
  public ImageIcon iconTTBCut3;
  public ImageIcon iconTTBCopy0;
  public ImageIcon iconTTBCopy1;
  public ImageIcon iconTTBCopy2;
  public ImageIcon iconTTBCopy3;
  public ImageIcon iconTTBPaste0;
  public ImageIcon iconTTBPaste1;
  public ImageIcon iconTTBPaste2;
  public ImageIcon iconTTBPaste3;
  public ImageIcon iconTTBUndo0;
  public ImageIcon iconTTBUndo1;
  public ImageIcon iconTTBUndo2;
  public ImageIcon iconTTBUndo3;
  public ImageIcon iconTTBRedo0;
  public ImageIcon iconTTBRedo1;
  public ImageIcon iconTTBRedo2;
  public ImageIcon iconTTBRedo3;


  // HIER neues Umgebungsvariablen


  /**
   * zur initialisierung wird der thread gestartet (StructogramEditor); gui synchronisiert sich am laufzeitende des
   * environment-threads. config-file-suchreihenfolge: - parameter, - home-verzeichnis, - aktuelles verzeichnis
   * fileNameParam ist null oder pfad+fileName einer config-datei
   * 
   * der parameter fileNameParam ist i.d.R. == null (-> defaultNamen suchen). nur falls ein Kommandozeilenparameter mit
   * Dateinamen bergeben wurde, wird dieser mittels fileNameParam bergeben
   */
  public Environment (String fileNameParam, HaSE editor) {
    this.editor = editor;
    this.errorLog = new ErrorLog(); // TODO: optioanl: Zieldatei via config bestimmen
    if (fileNameParam != null && fileNameParam.equals("NOCONFIG")) {
      this.configFileName = FILENAME; // zum Speichern spter die Defaultdatei nehmen
      this.useConfigFile = false;
    } else {
      this.configFileName = fileNameParam; // == null xoder config-file-pfadangabe
      this.useConfigFile = true;
    }
    this.loadingState = Environment.LOADEDNOTHING;
  }


  /**
   * bernimmt das Laden der Umgebungsvariablen aus der config-datei
   */
  public void run () {

    // Java Properties
    this.sep = System.getProperty("file.separator");
    this.nl = System.getProperty("line.separator");
    this.userTmpDir = System.getProperty("java.io.tmpdir");
    this.userHome = System.getProperty("user.home");
    this.userDir = System.getProperty("user.dir");
    this.userName = System.getProperty("user.name");
    this.userLanguage = System.getProperty("user.language");

    this.icon = new ImageIcon(ClassLoader.getSystemResource(IPPROGRAM));
    this.hamster2bOrNot2b = new ImageIcon(ClassLoader.getSystemResource(IPHAMSTER2B));
    this.iconTabClose = new ImageIcon(ClassLoader.getSystemResource(TABCLOSEBUTTONICON));
    this.iconTTBSeperator = new ImageIcon(ClassLoader.getSystemResource(IPTTBSEPERATOR));

    this.iconTrue = new ImageIcon(ClassLoader.getSystemResource(IPPICTRUE));
    this.iconFalse = new ImageIcon(ClassLoader.getSystemResource(IPPICFALSE));

    this.iconSpaceBlock0 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONBLOCK0));
    this.iconSpaceBlock1 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONBLOCK1));
    this.iconSpaceBlock2 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONBLOCK2));
    this.iconSpaceBlock3 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONBLOCK3));
    this.iconSpaceIf0 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONIF0));
    this.iconSpaceIf1 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONIF1));
    this.iconSpaceIf2 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONIF2));
    this.iconSpaceIf3 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONIF3));
    this.iconSpaceFirstLoop0 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONFIRSTLOOP0));
    this.iconSpaceFirstLoop1 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONFIRSTLOOP1));
    this.iconSpaceFirstLoop2 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONFIRSTLOOP2));
    this.iconSpaceFirstLoop3 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONFIRSTLOOP3));
    this.iconSpaceLastLoop0 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONLASTLOOP0));
    this.iconSpaceLastLoop1 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONLASTLOOP1));
    this.iconSpaceLastLoop2 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONLASTLOOP2));
    this.iconSpaceLastLoop3 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONLASTLOOP3));
    this.iconSpaceInsert0 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONINSERT0));
    this.iconSpaceInsert1 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONINSERT1));
    this.iconSpaceInsert2 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONINSERT2));
    this.iconSpaceInsert3 = new ImageIcon(ClassLoader.getSystemResource(IPSPACEBUTTONINSERT3));

    this.iconSeCut0 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCUT0));
    this.iconSeCut1 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCUT1));
    this.iconSeCut2 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCUT2));
    this.iconSeCut3 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCUT3));
    this.iconSeCopy0 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCOPY0));
    this.iconSeCopy1 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCOPY1));
    this.iconSeCopy2 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCOPY2));
    this.iconSeCopy3 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONCOPY3));
    this.iconSeDelete0 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONDELETE0));
    this.iconSeDelete1 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONDELETE1));
    this.iconSeDelete2 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONDELETE2));
    this.iconSeDelete3 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONDELETE3));
    this.iconSeSelect0 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONSELECT0));
    this.iconSeSelect1 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONSELECT1));
    this.iconSeSelect2 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONSELECT2));
    this.iconSeSelect3 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONSELECT3));
    this.iconSeEdit0 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONEDIT0));
    this.iconSeEdit1 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONEDIT1));
    this.iconSeEdit2 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONEDIT2));
    this.iconSeEdit3 = new ImageIcon(ClassLoader.getSystemResource(IPSEBUTTONEDIT3));
    this.iconSeSeperator = new ImageIcon(ClassLoader.getSystemResource(IPSESEPERATOR));
    this.iconMTBNewMethod0 = new ImageIcon(ClassLoader.getSystemResource(IPMTBNEWMETHOD0));
    this.iconMTBNewMethod1 = new ImageIcon(ClassLoader.getSystemResource(IPMTBNEWMETHOD1));
    this.iconMTBNewMethod2 = new ImageIcon(ClassLoader.getSystemResource(IPMTBNEWMETHOD2));

    this.iconBar3 = new ImageIcon(ClassLoader.getSystemResource(IPBUTTONBAR3));
    this.iconBar2 = new ImageIcon(ClassLoader.getSystemResource(IPBUTTONBAR2));
    this.iconBar1 = new ImageIcon(ClassLoader.getSystemResource(IPBUTTONBAR1));

    this.iconTTBNew0 = new ImageIcon(ClassLoader.getSystemResource(IPTBNEWPROG0));
    this.iconTTBNew1 = new ImageIcon(ClassLoader.getSystemResource(IPTBNEWPROG1));
    this.iconTTBNew2 = new ImageIcon(ClassLoader.getSystemResource(IPTBNEWPROG2));
    this.iconTTBOpen0 = new ImageIcon(ClassLoader.getSystemResource(IPTBOPEN0));
    this.iconTTBOpen1 = new ImageIcon(ClassLoader.getSystemResource(IPTBOPEN1));
    this.iconTTBOpen2 = new ImageIcon(ClassLoader.getSystemResource(IPTBOPEN2));
    this.iconTTBSave0 = new ImageIcon(ClassLoader.getSystemResource(IPTBSAVE0));
    this.iconTTBSave1 = new ImageIcon(ClassLoader.getSystemResource(IPTBSAVE1));
    this.iconTTBSave2 = new ImageIcon(ClassLoader.getSystemResource(IPTBSAVE2));
    this.iconTTBPrint0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPRINT0));
    this.iconTTBPrint1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPRINT1));
    this.iconTTBPrint2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPRINT2));
    this.iconTTBCut0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCUT0));
    this.iconTTBCut1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCUT1));
    this.iconTTBCut2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCUT2));
    this.iconTTBCut3 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCUT3));
    this.iconTTBCopy0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCOPY0));
    this.iconTTBCopy1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCOPY1));
    this.iconTTBCopy2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCOPY2));
    this.iconTTBCopy3 = new ImageIcon(ClassLoader.getSystemResource(IPTBPCOPY3));
    this.iconTTBPaste0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPPASTE0));
    this.iconTTBPaste1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPPASTE1));
    this.iconTTBPaste2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPPASTE2));
    this.iconTTBPaste3 = new ImageIcon(ClassLoader.getSystemResource(IPTBPPASTE3));
    this.iconTTBUndo0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPUNDO0));
    this.iconTTBUndo1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPUNDO1));
    this.iconTTBUndo2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPUNDO2));
    this.iconTTBUndo3 = new ImageIcon(ClassLoader.getSystemResource(IPTBPUNDO3));
    this.iconTTBRedo0 = new ImageIcon(ClassLoader.getSystemResource(IPTBPREDO0));
    this.iconTTBRedo1 = new ImageIcon(ClassLoader.getSystemResource(IPTBPREDO1));
    this.iconTTBRedo2 = new ImageIcon(ClassLoader.getSystemResource(IPTBPREDO2));
    this.iconTTBRedo3 = new ImageIcon(ClassLoader.getSystemResource(IPTBPREDO3));


    
    
    this.loadingState = Environment.LOADEDICON;

    if (!this.useConfigFile) {
      // Falls der SGEditor mit NOCONFIG gestartet wurde:
      this.loadDefaults();

    } else {

      // Der FileReader kann sequentiell eine Textdatei auslesen
      FileReader fr = null;
      boolean loadingError = false;

      // Config-Datei suchen:
      // 1. Parameter fileNameParam testen
      if (this.configFileName != null) {
        try {
          fr = new FileReader(this.configFileName);
        } catch (FileNotFoundException e) {
          loadingError = true;
        }
      } else {
        loadingError = true;
      }

      // 2. home-Verzeichnis testen
      if (loadingError) {
        loadingError = false;
        this.configFileName = this.userHome + this.sep + FILENAME;
        try {
          fr = new FileReader(this.configFileName);
        } catch (FileNotFoundException e) {
          loadingError = true;
        }
      }

      // 3. aktuelles Verzeichnis testen
      if (loadingError) {
        loadingError = false;
        this.configFileName = this.userDir + this.sep + FILENAME;
        try {
          fr = new FileReader(this.configFileName);
        } catch (FileNotFoundException e) {
          loadingError = true;
        }
      }

      // Falls erfolgreich ein FileReader-Objekt erstellt wurde: config-Datei laden
      if (!loadingError) {
        // Der BufferedReader buffert ganze Zeilen, so dass die Textdatei
        // Zeilenweise ausgelesen werden kann.
        BufferedReader br = new BufferedReader(fr);

        // Zeilenweise auslesen...
        try {
          br.readLine();
          br.readLine();
          br.readLine();
          this.useLaF = new Boolean(br.readLine());
          br.readLine();
          this.nameLaF = br.readLine();

          this.loadingState = Environment.LOADEDLAF;

          br.readLine();
          this.useSavedGUICoordinates = new Boolean(br.readLine());
          br.readLine();
          this.windowExtendedState = new Integer(br.readLine());
          br.readLine();
          this.windowWidth = new Integer(br.readLine());
          br.readLine();
          this.windowHeight = new Integer(br.readLine());
          br.readLine();
          this.windowPositionX = new Integer(br.readLine());
          br.readLine();
          this.windowPositionY = new Integer(br.readLine());

          this.loadingState = Environment.LOADEDGUISIZE;

          br.readLine();
          this.backGroundColor = new Color(new Integer(br.readLine()));
          br.readLine();
          this.enableHiddenFeatures = new Boolean(br.readLine());
          br.readLine();
          this.easyMode = new Boolean(br.readLine());
          br.readLine();
          this.languageFile = br.readLine();
          br.readLine();
          this.atomBlockFile = br.readLine();
          br.readLine();
          this.atomConditionFile = br.readLine();
          br.readLine();
          this.conditionCompositionFile = br.readLine();
          br.readLine();
          this.keyBindingsFile = br.readLine();
          br.readLine();
          this.undoDepth = new Integer(br.readLine());
          br.readLine();
          this.targetProgrammingLanguageFileName = br.readLine();
          br.readLine();
          this.messageLifeTime = new Integer(br.readLine());
          
          // font setting laden/speichern, update 2012
          br.readLine();
          this.setFont(br.readLine());
          br.readLine();
          this.fontSize = new Integer(br.readLine());

          // HIER neue Attribute einfgen (LADEN)

          // this.sussesfulLoaded = true;
        } catch (Exception e) { // IOException oder Typumwandlungsfehler
          // this.sussesfulLoaded = false;
          loadingError = true;
        }

        try {
          fr.close();
        } catch (IOException e1) {
          // ...
        }
      }

      // Ladefehler? Dann feste Defaultwerte verwenden
      if (loadingError) {
        this.loadDefaults();
      }
    }
    
    this.editor.setControlAPI(new ControlAPI(this.editor));
    this.loadingState = LOADEDCONTROLAPI;
    
    // Sprachdatei Laden
    this.language = new EnvironmentLanguage(this.languageFile);
    this.loadingState = LOADEDLANGUAGEFILE;

    // ...
    // Laden ...
    this.atomBlockSeperatorList = new ArrayList<Integer>();
    this.atomConditionSeperatorList = new ArrayList<Integer>();
    this.conditionCompositionSeperatorList = new ArrayList<Integer>();
    this.atomBlockList = builtAtomBlockList(loadConfigFileToAL(atomBlockFile), atomBlockSeperatorList);
    this.loadingState = LOADEDFILE2;
    this.atomConditionList = builtAtomConditionList(loadConfigFileToAL(atomConditionFile), atomConditionSeperatorList);
    this.loadingState = LOADEDFILE3;
    this.conditionCompositionList = builtConditionComposingList(loadConfigFileToAL(conditionCompositionFile), conditionCompositionSeperatorList);
    this.loadingState = LOADEDFILE4;
    
    
    this.loadKeyBindings(this.keyBindingsFile);
    this.loadingState = LOADEDKEYBINDINGS;

    // TODO: Fehlerbehandlung mit kontrolliertem Abbruch nach oben durchreichen
    try {
      this.targetProgrammingLanguage = new EnvironmentTargetProgrammingLanguage(this.targetProgrammingLanguageFileName);
    } catch (IOException e) {
      
    }
    this.loadingState = LOADEDTARGETPROGRAMMINGLANGUAGE;

    this.buildSkinList();
    this.selectSkin(this.skinSelection);
    this.loadingState = LOADEDSKIN;

    this.simulator = new EnvironmentSimulator(editor);

    this.loadingState = Environment.LOADEDALL;
  }

  private void loadKeyBindings (String keyBindingsFile) {
    this.keyBindings = new ArrayList<KeyBinding>();
    ArrayList<String> al = loadFileToAL(keyBindingsFile);
    // die -1 soll sicherstellen, dass auch immer zwei Strings vorhanden sind
    for (int i = 0; i < al.size()-1; i+=2) {
      this.keyBindings.add(new KeyBinding(al.get(i), al.get(i+1)));
    }
  }


  private ArrayList<ConditionComposition> builtConditionComposingList (ArrayList<String> al, ArrayList<Integer> conditionCompositionSeperatorList) {
    ArrayList<ConditionComposition> conditionCompositionList = new ArrayList<ConditionComposition>();
    for (int i = 0; i < (al.size() - 2); i += 3) {
      if (al.get(i).equals("\\SEPERATOR")) {
        conditionCompositionSeperatorList.add(conditionCompositionList.size());
      } else {
        conditionCompositionList.add(new ConditionComposition(al.get(i + 0), al.get(i + 1), al.get(i + 2), conditionCompositionList.size()));
      }
    }
    return conditionCompositionList;
  }


  private ArrayList<AtomicItem> builtAtomConditionList (ArrayList<String> al, ArrayList<Integer> atomConditionSeperatorList) {
    ArrayList<AtomicItem> conditionList = new ArrayList<AtomicItem>();
    for (int i = 0; i < (al.size() - 2); i += 3) {
      if (al.get(i).equals("\\SEPERATOR")) {
        atomConditionSeperatorList.add(conditionList.size());
      } else {
        conditionList.add(new AtomicItem(al.get(i + 0), al.get(i + 1), al.get(i + 2)));
      }
    }
    return conditionList;
  }


  private ArrayList<AtomicItem> builtAtomBlockList (ArrayList<String> al, ArrayList<Integer> atomBlockSeperatorList) {
    ArrayList<AtomicItem> blockList = new ArrayList<AtomicItem>();
    for (int i = 0; i < (al.size() - 2); i += 3) {
      if (al.get(i).equals("\\SEPERATOR")) {
        atomBlockSeperatorList.add(blockList.size());
      } else {
        blockList.add(new AtomicItem(al.get(i + 0), al.get(i + 1), al.get(i + 2)));
      }
    }
    return blockList;
  }


  private ArrayList<String> loadConfigFileToAL (String fileName) {
   
    ArrayList<String> alOut = new ArrayList<String>();
    ArrayList<String> alIn = loadFileToAL(fileName);
    for (int i = 0; i < alIn.size(); i++) {
      if (alIn.get(i).equals("\\SEPERATOR")) {
        alOut.add("\\SEPERATOR");
        alOut.add("\\SEPERATOR");
        alOut.add("\\SEPERATOR");
      } else {
        alOut.add(alIn.get(i));
      }
    }
    return alOut;
  }
  
  public static void writeXMLFile(String fileName, Document doc) {
    // TODO: Fehlerbehandlung
    try{
    // outputter: berfhrt die xml-struktur in einen xml-text
    // XMLOutputter out = new XMLOutputter(Format.getCompactFormat());
    XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    // XMLOutputter out = new XMLOutputter(Format.getRawFormat());

    // out.output( doc, System.out ); // Textausgabe
    out.output(doc, new FileWriter(new File(fileName))); // Fileausgabe
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  public static Document loadXMLFile(String fileName) throws RequestRejectedExecption {
    SAXBuilder builder = new SAXBuilder();
    Document doc = null;
    try {
      doc = builder.build(new File(fileName));
    } catch (JDOMException e) {
      throw new RequestRejectedExecption();
    } catch (IOException e) {
      throw new RequestRejectedExecption();
    }
    return doc;
  }

  // Ldt eine Textdatei Zeilenweise in eine ArrayList<String>
  // Zeilen die mit einem # an pos. 0 beginnen, werden rausgefiltert
  public static ArrayList<String> loadFileToAL (String fileName) {
    ArrayList al = new ArrayList<String>();
    String line;
    try {
      FileReader fr = new FileReader(fileName);
      BufferedReader br = new BufferedReader(fr);

      line = br.readLine();
      while (line != null) {
        if (line.length() > 0 && line.charAt(0) == '#') {
          // Kommentarzeile -> ignorieren und zur nchsten Zeile springen
          line = br.readLine();
          continue;
        } else {
          // keine Kommentarzeile, also Zeile zwischenspeichern
          al.add(line);
        }
        line = br.readLine();
      }

      fr.close();
    } catch (Exception e) {
      return null;
    }

    return al;
  }
  
  private void buildSkinList () {
    this.skinList = new Skin[1];
    this.skinList[0] = new SimpleISOSkin(this, this.editor);
    // this.skinList[0] = new SimpleSkin(this);
    // TODO ...
  }

  public void selectSkin (int index) {
    this.skinSelection = index;
    if (index == -1) {
      // TODO: File By Name laden
      // this.skinPath;
    } else {
      this.skin = this.skinList[skinSelection];
    }

  }

  public void save () {
    
    // --- save environment ---
    try {
      FileWriter fw = new FileWriter(this.configFileName);
      fw.write("# HamsterStruktogrammEditor Config-Datei" + nl);
      fw.write("# Es wird immer jede zweite Zeile eingelesen, beginnend mit der 4. Zeile." + nl);
      fw.write("# Soll ein Java LaF (Look and Feel) gesetzt werden?" + nl);
      fw.write("" + this.useLaF + nl);
      fw.write("# Name des LaF" + nl);
      fw.write("" + this.nameLaF + nl);
      fw.write("# Sollen alte Fensterposition und -gre beim Programmstart geladen werden?" + nl);
      fw.write("" + this.useSavedGUICoordinates + nl);
      fw.write("# windowExtendedState (Minimiert, Maximert, Normal, ...)" + nl);
      fw.write("" + this.windowExtendedState + nl);
      fw.write("# Fensterbreite" + nl);
      fw.write("" + this.windowWidth + nl);
      fw.write("# Fensterhhe" + nl);
      fw.write("" + this.windowHeight + nl);
      fw.write("# Fenster-X-Position" + nl);
      fw.write("" + this.windowPositionX + nl);
      fw.write("# Fenster-Y-Position" + nl);
      fw.write("" + this.windowPositionY + nl);
      fw.write("# Hintergrundfarbe" + nl);
      fw.write("" + this.backGroundColor.getRGB() + nl);
      fw.write("# HiddenFeatures verwenden?" + nl);
      fw.write("" + this.enableHiddenFeatures + nl);
      fw.write("# easyMode?" + nl);
      fw.write("" + this.easyMode + nl);
      fw.write("# LanguageFile" + nl);
      fw.write(this.languageFile + nl);
      fw.write("# Konfigurationsdatei mit atomaren Anweisungsblcken" + nl);
      fw.write(this.atomBlockFile + nl);
      fw.write("# Konfigurationsdatei mit atomaren boolschen Funktionen / Konstanten" + nl);
      fw.write(this.atomConditionFile + nl);
      fw.write("# Konfigurationsdatei mit zusammengesetzten boolschen Funktionen" + nl);
      fw.write(this.conditionCompositionFile + nl);
      fw.write("# KeyBinding-Datei" + nl);
      fw.write(this.keyBindingsFile + nl);
      fw.write("# UndoTiefe pro Programm" + nl);
      fw.write("" + this.undoDepth + nl);
      fw.write("# Konfig-Datei der Zielprogrammiersprache. Default ist der Java/Hamster-Dialekt" + nl);
      fw.write(this.targetProgrammingLanguageFileName + nl);
      fw.write("# Lebenszeit fr Statuszeilennachrichten in Milisekunden" + nl);
      fw.write(this.messageLifeTime + nl);

      fw.write("# Name der gewaehlten Schriftart" + nl);
      fw.write(this.getFontname() + nl);
      fw.write("# groesse der gewaehlten Schriftart" + nl);
      fw.write(this.fontSize + nl);

      // HIER neue Attribute einfgen (SPEICHERN)

      fw.close();
    } catch (IOException e) {
      // TODO: Fehlermeldung?
    }
  }

  /**
   * Defaultwerte erzeugen
   * 
   */
  private void loadDefaults () {
    this.useLaF = false;
    this.nameLaF = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    this.windowExtendedState = java.awt.Frame.NORMAL;
    this.windowWidth = 600;
    this.windowHeight = 400;
    this.windowPositionX = 300;
    this.windowPositionY = 200;
    this.backGroundColor = Color.WHITE;
    this.enableHiddenFeatures = true; // TODO: default = false
    this.useSavedGUICoordinates = false;
    this.easyMode = true;
    if (this.userLanguage.equals("de")) {
      this.languageFile = LANGUAGEDEFAULTFILENAME + "de";
    } else {
      this.languageFile = LANGUAGEDEFAULTFILENAME + "en";
    }
    this.atomBlockFile = ATOMBLOCKDEFAULTFILENAME;
    this.atomConditionFile = ATOMCONDITIONDEFAULTFILENAME;
    this.conditionCompositionFile = CONDITIONCOMPOSITIONDEFAULTFILENAME;
    this.keyBindingsFile = KEYBINDINGDEFAULTFILENAME;
    this.undoDepth = 16;
    this.targetProgrammingLanguageFileName = ".TargetProgrammingLanguage.config";
    this.messageLifeTime = 5000;
    this.fontSelection = -1;
    this.fontSize = 18;
    // HIER neue Attribute einfgen (DEFAULT)

  }

  public Color getBackGroundColor () {
    return backGroundColor;
  }

  public void setBackGroundColor (Color backGroundColor) {
    this.backGroundColor = backGroundColor;
  }

  public boolean isEasyMode () {
    return easyMode;
  }

  public void setEasyMode (boolean easyMode) {
    this.easyMode = easyMode;
  }

  public boolean isEnableHiddenFeatures () {
    return enableHiddenFeatures;
  }

  public void setEnableHiddenFeatures (boolean enableHiddenFeatures) {
    this.enableHiddenFeatures = enableHiddenFeatures;
  }

  public int getLoadingState () {
    return this.loadingState;
  }

  public boolean isLoaded () {
    return this.loadingState == Environment.LOADEDALL;
  }

  public String getNl () {
    return nl;
  }

  public void setNl (String nl) {
    this.nl = nl;
  }

  public String getSep () {
    return sep;
  }

  public void setSep (String sep) {
    this.sep = sep;
  }

  public boolean isUseConfigFile () {
    return useConfigFile;
  }

  public void setUseConfigFile (boolean useConfigFile) {
    this.useConfigFile = useConfigFile;
  }

  public String getUserDir () {
    return userDir;
  }

  public void setUserDir (String userDir) {
    this.userDir = userDir;
  }

  public String getUserHome () {
    return userHome;
  }

  public void setUserHome (String userHome) {
    this.userHome = userHome;
  }

  public String getUserLanguage () {
    return userLanguage;
  }

  public void setUserLanguage (String userLanguage) {
    this.userLanguage = userLanguage;
  }

  public String getUserName () {
    return userName;
  }

  public void setUserName (String userName) {
    this.userName = userName;
  }

  public String getUserTmpDir () {
    return userTmpDir;
  }

  public void setUserTmpDir (String userTmpDir) {
    this.userTmpDir = userTmpDir;
  }

  public int getWindowHeight () {
    return windowHeight;
  }

  public void setWindowHeight (int windowHeight) {
    this.windowHeight = windowHeight;
  }

  public int getWindowPositionX () {
    return windowPositionX;
  }

  public void setWindowPositionX (int windowPositionX) {
    this.windowPositionX = windowPositionX;
  }

  public int getWindowPositionY () {
    return windowPositionY;
  }

  public void setWindowPositionY (int windowPositionY) {
    this.windowPositionY = windowPositionY;
  }

  public int getWindowWidth () {
    return windowWidth;
  }

  public void setWindowWidth (int windowWidth) {
    this.windowWidth = windowWidth;
  }


  public String getFontname() {
    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    if (this.fontSelection == -1) {
      return "Monospaced";
    } else {
      return ge.getAvailableFontFamilyNames()[this.fontSelection];
    }
  }

  // Zum Laden eines Fonts ueber den Namen
  public void setFont(String name) {
    this.fontSelection = -1;
    if (name == null) return;
    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    String[] fontNameList = ge.getAvailableFontFamilyNames();
    for (int index = 0; index < fontNameList.length; index++) {
      if (fontNameList[index].equals(name)) {
        this.fontSelection = index;
        return;
      }
    }
  }

  // changed 2012-10 nitram, font bug
  public Font getFont () {
    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();

    // return new Font(ge.getAvailableFontFamilyNames()[23], Font.PLAIN, 12);
    // return new Font("Comic Sans MS", Font.PLAIN, 16);
    
    // bugfix hack:
    // der besondere indexwert -1 bewirkt die verwendung des logischen monospacefont
    // das ist ein sinnvoller default falls keine andere schriftart ausgewaehlt wurde.
    if (this.fontSelection < 0 || this.fontSelection >= ge.getAvailableFontFamilyNames().length) {
      return new Font("Monospaced", Font.PLAIN, this.fontSize);
    } else {
      return new Font(ge.getAvailableFontFamilyNames()[this.fontSelection], Font.PLAIN, this.fontSize);
    }

  }

  public Skin[] getSkinList () {
    return skinList;
  }

  public void setSkinList (Skin[] skinList) {
    this.skinList = skinList;
  }

  public String getSkinPath () {
    return skinPath;
  }

  public void setSkinPath (String skinPath) {
    this.skinPath = skinPath;
  }

  public int getSkinSelection () {
    return skinSelection;
  }

  public int getFontSelection () {
    return fontSelection;
  }

  public void setFontSelection (int fontSelection) {
    this.fontSelection = fontSelection;
  }

  public int getFontSize () {
    return fontSize;
  }

  public void setFontSize (int fontSize) {
    this.fontSize = fontSize;
    this.skin.calcRowHeight();
    ArrayList<ProgramModel> pl = this.editor.controlAPI.getProgramList();
    for (int i = 0; i < pl.size(); i++) {
      pl.get(i).updateSize();
    }
    this.editor.viewAPI.markStructureElementMethodAsChanged();
  }

  public boolean useSavedGUICoordinates () {
    return this.useSavedGUICoordinates;
  }

  public void setWindowExtendedState (int extendedState) {
    this.windowExtendedState = extendedState;
  }

  public int getWindowExtendedState () {
    return this.windowExtendedState;
  }

  public ImageIcon getIcon () {
    return this.icon;
  }
  
  public ImageIcon getTabCloseIcon () {
    return this.iconTabClose;
  }

  public String getLaFName () {
    return this.nameLaF;
  }

  public boolean useLaF () {
    return this.useLaF;
  }


  public String getAtomBlockFile () {
    return atomBlockFile;
  }


  public void setAtomBlockFile (String atomBlockFile) {
    this.atomBlockFile = atomBlockFile;
  }


  public ArrayList<AtomicItem> getAtomBlockList () {
    return atomBlockList;
  }


  public void setAtomBlockList (ArrayList<AtomicItem> atomBlockList) {
    this.atomBlockList = atomBlockList;
  }


  public String getAtomConditionFile () {
    return atomConditionFile;
  }


  public void setAtomConditionFile (String atomConditionFile) {
    this.atomConditionFile = atomConditionFile;
  }


  public ArrayList<AtomicItem> getAtomConditionList () {
    return atomConditionList;
  }


  public void setAtomConditionList (ArrayList<AtomicItem> atomConditionList) {
    this.atomConditionList = atomConditionList;
  }


  public String getConditionCompositionFile () {
    return conditionCompositionFile;
  }


  public void setConditionCompositionFile (String conditionCompositionFile) {
    this.conditionCompositionFile = conditionCompositionFile;
  }


  public ArrayList<ConditionComposition> getConditionCompositionList () {
    return conditionCompositionList;
  }


  public void setConditionCompositionList (ArrayList<ConditionComposition> conditionCompositionList) {
    this.conditionCompositionList = conditionCompositionList;
  }


  public String getConfigFileName () {
    return configFileName;
  }


  public void setConfigFileName (String configFileName) {
    this.configFileName = configFileName;
  }


  public EnvironmentLanguage getLanguage () {
    return language;
  }


  public void setLanguage (EnvironmentLanguage language) {
    this.language = language;
  }


  public String getLanguageFile () {
    return languageFile;
  }


  public void setLanguageFile (String languageFile) {
    this.languageFile = languageFile;
  }


  public String getNameLaF () {
    return nameLaF;
  }


  public void setNameLaF (String nameLaF) {
    this.nameLaF = nameLaF;
  }


  public Skin getSkin () {
    return skin;
  }


  public void setSkin (Skin skin) {
    this.skin = skin;
  }


  public boolean isUseLaF () {
    return useLaF;
  }


  public void setUseLaF (boolean useLaF) {
    this.useLaF = useLaF;
  }


  public boolean isUseSavedGUICoordinates () {
    return useSavedGUICoordinates;
  }


  public void setUseSavedGUICoordinates (boolean useSavedGUICoordinates) {
    this.useSavedGUICoordinates = useSavedGUICoordinates;
  }


  public void setIcon (ImageIcon icon) {
    this.icon = icon;
  }


  public void setLoadingState (int loadingState) {
    this.loadingState = loadingState;
  }


  public void setSkinSelection (int skinSelection) {
    this.skinSelection = skinSelection;
  }


  public ArrayList<KeyBinding> getKeyBindings () {
    return this.keyBindings;
  }


  public int getUndoDepth () {
    
    return this.undoDepth;
  }


  public int getMessageLifeTime () {
    return this.messageLifeTime;
  }
  



}