package de.schmaeck.struktogrammeditor.model.environment;

import java.io.Serializable;
import java.util.StringTokenizer;

public class ConditionComposition implements Serializable {
  
  // TODO Diese Zahl jedesmal dann ndern (+1), wenn diese Klasse verndert wurde
  private final static long serialVersionUID = 142l;
  
  private String[] codeText;
  private String[] humanText;
  private String toolTip;
  boolean singleValue;
  private int conditionCompositionIndex;
  
  public ConditionComposition(String codeText, String humanText, String toolTip, int conditionCompositionIndex) {
    this.conditionCompositionIndex = conditionCompositionIndex;
    this.toolTip = toolTip;
    this.codeText = new String[3];
    this.humanText = new String[3];
    
    StringBuilder sb = new StringBuilder();
    StringTokenizer st = new StringTokenizer(codeText, "\\", true);
    int index = 0;
    while(st.hasMoreTokens()) {
      String temp = st.nextToken();
      if (temp.equals("\\")) {
        String temp2 = st.nextToken();
        if (temp2.equals("\\")) {
          sb.append("\\");
        } else if (temp2.charAt(0) == 'A' || temp2.charAt(0) == 'B') {
          this.codeText[index] = sb.toString();
          sb = new StringBuilder();
          sb.append(temp2.substring(1));
          index++;
        }
      } else {
        sb.append(temp);
      }
    }
    this.codeText[index] = sb.toString();

    sb = new StringBuilder();
    st = new StringTokenizer(humanText, "\\", true);
    index = 0;
    while(st.hasMoreTokens()) {
      String temp = st.nextToken();
      if (temp.equals("\\")) {
        String temp2 = st.nextToken();
        if (temp2.equals("\\")) {
          sb.append("\\");
        } else if (temp2.charAt(0) == 'A' || temp2.charAt(0) == 'B') {
          this.humanText[index] = sb.toString();
          sb = new StringBuilder();
          sb.append(temp2.substring(1));
          index++;
        }
      } else {
        sb.append(temp);
      }
    }
    this.humanText[index] = sb.toString();
    

    // Wenn es kein \B im String gab, hat diese Condition nur einen Parameter
    this.singleValue = (index == 1);
    
  }

  public String[] getCodeText () {
    return codeText;
  }

  public String[] getHumanText () {
    return humanText;
  }

  public boolean isSingleValue () {
    return singleValue;
  }

  public String getToolTip () {
    return toolTip;
  }
  
  public String toString() {
    if (this.singleValue) {
      return codeText[0] + "<a>" + codeText[1] + "\n"
      + humanText[0] + "<a>" + humanText[1] + "\n"
      + toolTip;
    } else {
      return codeText[0] + "<a>" +codeText[1] + "<b>" + codeText[2] + "\n"
      + humanText[0] + "<a>" +humanText[1] + "<b>" + humanText[2] + "\n"
      + toolTip;
    }
  }
  
  public static void main(String[] a) {
    System.out.println(new ConditionComposition("(\\A) && (\\B)", "(\\A) und (\\B)", "ToolTip", 0));
  }

  public int getIndex () {
    return this.conditionCompositionIndex;
  }
  
  

}
