package de.schmaeck.struktogrammeditor.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.jdom.Document;
import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.Instruction;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;

public class ProgramModel {
  
//  String name;
//  ... Filename, Programname, ...
//  xml-baum laden/speichern
//  
  ArrayList<StructureElementMethod> methodList;
  private String fileName;
  private HaSE editor;
  private String name;

  
  public ProgramModel(Document doc, String path, HaSE editor) {
    this.editor = editor;
    
    Element root = doc.getRootElement();
    this.name = root.getAttributeValue("Name");
    this.fileName = path;
    
    // Liste der Methoden
    this.methodList = new ArrayList<StructureElementMethod>();

    List methodListXML = root.getChildren();
    for (int i = 0; i < methodListXML.size(); i++) {
      StructureElementMethod methodSE = new StructureElementMethod((Element) methodListXML.get(i), editor);
      this.methodList.add(methodSE);
    }    
  }
  
  public ProgramModel(HaSE editor, String name) {
    
    this.editor = editor;
    this.name = name;
    this.fileName = null;
    
    // Liste der Methoden
    this.methodList = new ArrayList<StructureElementMethod>();

    // Die obligatorische main-Methode
    StructureElementMethod methodSE = new StructureElementMethod(
        editor.environment.targetProgrammingLanguage.getMainName(),
        editor);
    methodSE.setType(editor.environment.targetProgrammingLanguage.getMainType());
    for (int i = 0; i < editor.environment.targetProgrammingLanguage.getMainParamList().length; i++) {
      methodSE.addParam(editor.environment.targetProgrammingLanguage.getMainParamList()[i]);
    }
    this.methodList.add(methodSE);
  }

  // -----
  
  public int addNewMethod () {
    //  neuen Namen, Typ, Signatur ermitteln
    String name = editor.environment.targetProgrammingLanguage.getDefaultMethodName();
    ArrayList<String[]> param = new ArrayList<String[]>();
    String[][] param_temp = editor.environment.targetProgrammingLanguage.getDefaultParamList();
    for (int i = 0; i < param_temp.length; i++) {
      param.add(param_temp[i]);
    }
    String type = editor.environment.targetProgrammingLanguage.getDefaultMethodType();
    
    // Signatur oder Name muss eindeutig sein
    if (editor.environment.targetProgrammingLanguage.isNeedUniqueName()) {
      boolean unique = true;
      for (int i = 0; i < this.methodList.size(); i++) {
        if (this.methodList.get(i).getName().equals(name)) {
          unique = false;
          break;
        }
      }
      String name_temp = name;
      int number = 0;
      while (!unique) {
        number++;
        name_temp = name + number;
        unique = true;
        for (int i = 0; i < this.methodList.size(); i++) {
          if (this.methodList.get(i).getName().equals(name_temp)) {
            unique = false;
            break;
          }
        }
      }
      name = name_temp;
    } else {
      boolean unique = true;
      for (int i = 0; i < this.methodList.size(); i++) {
        StructureElementMethod m = this.methodList.get(i);
        if (m.getName().equals(name) && m.getParam().size() == param.size()) {
          unique = false;
          for (int j = 0; j < param.size(); j++) {
            if (!m.getParam().get(j)[0].equals(param.get(j)[0])) {
              unique = true;
              break;
            }
          }
          if (!unique) break;
        }
      }
      String name_temp = name;
      int number = 0;
      while (!unique) {
        number++;
        name_temp = name + number;
        unique = true;
        for (int i = 0; i < this.methodList.size(); i++) {
          StructureElementMethod m = this.methodList.get(i);
          if (m.getName().equals(name_temp) && m.getParam().size() == param.size()) {
            unique = false;
            for (int j = 0; j < param.size(); j++) {
              if (!m.getParam().get(j)[0].equals(param.get(j)[0])) {
                unique = true;
                break;
              }
            }
            if (!unique) break;
          }
        }
        
      }
      name = name_temp;
    }
    
    // ok, name ist eindeutig, param und type sind bekannt
    
    
    StructureElementMethod methodSE = new StructureElementMethod(
        name,
        editor);
    methodSE.setType(type);
    methodSE.setParam(param);
    this.methodList.add(methodSE);
    return this.methodList.size()-1;
  }
  
  public void deleteMethod(int index) {
    this.methodList.remove(index);
  }
  
  public String getFileName () {
    return fileName;
  }
  
  public StructureElementMethod getMethod(int index) {
    return this.methodList.get(index);
  }

  public ArrayList<StructureElementMethod> getMethodList () {
    return methodList;
  }

  public String getName () {
    return name;
  }
  
  

  public void setFileName (String fileName) {
    this.fileName = fileName;
  }

  public void setName (String name) {
    this.name = name;
  }

  public Document toXML() {
    Element root = new Element("Program");
    Document doc = new Document(root);
    // EditorDTD + Version
    root.setAttribute("Identifier", editor.environment.targetProgrammingLanguage.getIdentifier());
    root.setAttribute("Version", ""+editor.environment.targetProgrammingLanguage.getVersion());
    root.setAttribute("Name", this.name);
    
    for (int i = 0; i < this.methodList.size(); i++) {
      this.methodList.get(i).addMethodToXML(root);
    }
    return doc;
  }

  public void updateSize () {
    for (int i = 0; i < this.methodList.size(); i++) {
      this.methodList.get(i).updateSize(editor);
    }
    
  }
  
  public int getNumberOfVoidMethods() {
    int counter = 0;
    for (int i = 0; i < this.methodList.size(); i++) {
      if (this.methodList.get(i).getType().equals(editor.environment.targetProgrammingLanguage.getTypeList()[0])) {
        counter++;
      }
    }
    return counter;
  }

  public int getNumberOfBooleanMethods() {
    int counter = 0;
    for (int i = 0; i < this.methodList.size(); i++) {
      if (this.methodList.get(i).getType().equals(editor.environment.targetProgrammingLanguage.getTypeList()[1])) {
        counter++;
      }
    }
    return counter;
  }
  
  public boolean verifyMethodName(String newName, String oldName) {
    // TODO: es werden keine methodenparamter angeboten. sollte sich das einmal
    // ndern, reicht eine eindeutige signatur statt eindeutiger name.

    // true, falls der name nicht gendert wurde
    if (newName.equals(oldName)) return true;
    
    // false, falls der name schon existiert
    for (int i = 0; i < this.methodList.size(); i++) {
      if (this.methodList.get(i).getName().equals(newName)) return false;
    }

    // false, falls ein reserviertes Wort verwendet wurde
    for (int i = 0; i < editor.environment.targetProgrammingLanguage.getReservedWordList().size(); i++) {
      if (editor.environment.targetProgrammingLanguage.getReservedWordList().get(i).equals(newName)) return false;
    }
    
    // wurden nur erlaubte zeichen verwendet?
    if (newName.length() == 0) return false;
    if (!isAlpha(newName.charAt(0))) return false;
    for (int i = 1; i < newName.length(); i++) {
      if (!isAlphaPlus(newName.charAt(i))) return false;
    }
    return true;
  }
  
  public static boolean isAlpha(char c) {
    if (((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z'))) return true;
    return false;
  }

  public static boolean isAlphaPlus(char c) {
    if ((c == '0')
        || (c == '1')
        || (c == '2')
        || (c == '3')
        || (c == '4')
        || (c == '5')
        || (c == '6')
        || (c == '7')
        || (c == '8')
        || (c == '9')
        || (c == '_') ) return true;
    return isAlpha(c);
  }

}
