package de.schmaeck.struktogrammeditor.model;

public class MethodNameValidator {

  private final static char[] allowedFirstChar = new char[] { 
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n'
    , 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B'
    , 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'
    , 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

  private final static char[] allowedChar = new char[] {
    '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
  };

  public static boolean validate (String name) {
    boolean validChar;
    for (int i = 0; i < name.length(); i++) {
      validChar = false;
      for (int j = 0; j < allowedFirstChar.length; j++) {
        if (name.charAt(i) == allowedFirstChar[j]) {
          validChar = true;
        }
      }
      if (i > 0) {
        for (int j = 0; j < allowedChar.length; j++) {
          if (name.charAt(i) == allowedChar[j]) {
            validChar = true;
          }
        }
      }
      if (!validChar) return false;
    }
    return true;
  }

}
