package de.schmaeck.struktogrammeditor.model;

import de.schmaeck.struktogrammeditor.controller.Instruction;


/**
 * 
 * @author Martin Schmaeck
 * @deprecated
 *
 */
public class InstructionRingBuffer {

  private final static int INIT_SIZE = 2; // initiale Arraygre
  private final static int GROW = 2;      // Arrayvergrerungssummand
  
  Instruction[] ring;      // Array of Instruction
  int producerIndex = 0;   // nchster zu erstellender Datensatz
  int consumerIndex = 0;   // nchster zu verbrauchender Datensatz
  int fillSize = 0;        // Anzahl an gespeicherten Datenstzen
  int maxSize = INIT_SIZE; // Gre des Arrays 
  

  public InstructionRingBuffer () {
    this.ring = new Instruction[INIT_SIZE];
    this.producerIndex = 0;
    this.consumerIndex = 0;
    this.fillSize = 0;
    this.maxSize = INIT_SIZE;
  }

  public void produce (Instruction inst) {
    // im Bedarfsfall wachsen
    if (this.fillSize == this.maxSize) grow();
      
    this.ring[this.producerIndex] = inst;

    this.producerIndex = (this.producerIndex + 1) % this.maxSize;
    fillSize++;
  }
  
  private void grow() {
    this.maxSize += GROW;
    Instruction[] newRing = new Instruction[maxSize];
    // Den alten Ringinhalt kopieren
    for (int i = 0; i < this.ring.length; i++) {
      newRing[i] = ring[(this.producerIndex + i) % this.ring.length];
    }
    this.producerIndex = this.ring.length;
    this.consumerIndex = 0;
    // Den freien Rest mit leeren Instruktionen auffllen
//    for (int i = this.ring.length; i < maxSize; i++) {
//      newRing[i] = new Instruction();
//    }
    this.ring = newRing;
  }

  public Instruction consume () throws NothingToDoException {
    if (this.fillSize == 0) throw new NothingToDoException();
        
    Instruction inst = this.ring[this.consumerIndex];
    this.ring[this.consumerIndex] = null; // Das Objekt soll hier nicht mehr referenziert werden
    this.consumerIndex = (this.consumerIndex + 1) % this.maxSize;
    this.fillSize--;
    return inst;
  }
  
  public boolean isEmpty() {
    return this.fillSize == 0;
  }

}
