package de.schmaeck.struktogrammeditor.model;

import java.io.Serializable;
import java.util.List;

import org.jdom.Content;
import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.ConditionComposition;

// TODO!!
public class Condition implements Serializable {
  
  // TODO Diese Zahl jedesmal dann ndern (+1), wenn diese Klasse verndert wurde
  private final static long serialVersionUID = 142l;

  
  private boolean isAtomic; // true falls diese Bedingung atomar ist, 
  // false, falls es sich um eine zusammengesetzte Bedingung handelt
  
  // fr atomare Bedingungen
  private String text;
  
  // Fr zusammengesetzte Bedingungen
  private Condition a;
  private Condition b;
  private ConditionComposition composition;

  //Boolsche Funktion: kornDa, vornFrei, maulLeer
  // Wertevergleich / ausdruck
  // freier text

  public Condition(HaSE editor) {
    this.isAtomic = true;
    this.text = editor.environment.atomConditionList.get(0).getCodeText();
    this.a = null;
    this.b = null;
    this.composition = null;
  }
  
  public Condition(String conditionText) {
    this.isAtomic = true;
    this.text = conditionText;
    this.a = null;
    this.b = null;
    this.composition = null;
  }
  
  public void resetText(HaSE editor) {
    this.text = editor.environment.atomConditionList.get(0).getCodeText();
  }
  
  public Condition (Condition c) {
    copyData(c);
  }

  public Condition (Element element, HaSE editor) {

    this.text = element.getAttributeValue("Text");
    this.isAtomic = new Boolean(element.getAttributeValue("IsAtomic"));
    int compIndex = new Integer(element.getAttributeValue("Composition"));
    if (compIndex == -1) {
      this.composition = null;
    } else {
      this.composition = editor.environment.conditionCompositionList.get(compIndex);
    }
    this.a = null;
    this.b = null;
    List children = element.getChildren();
    if (children.size() > 0) {
      this.a = new Condition((Element) children.get(0), editor);
      if (children.size() > 1) {
        this.b = new Condition((Element) children.get(1), editor);
      }
    }
  }

  public String toString() {
    if (this.isAtomic) {
      return this.text;
    } else {
      if (this.composition.isSingleValue()) {
        return this.composition.getCodeText()[0] 
          + this.a.toString()                                
          + this.composition.getCodeText()[1]; 
      } else {
        return this.composition.getCodeText()[0] 
          + this.a.toString()                                
          + this.composition.getCodeText()[1]
          + this.b.toString()                                 
          + this.composition.getCodeText()[2];
      }
    }
  }

  public void setText (String codeText) {
    this.text = codeText;
    this.isAtomic = true;
  }

  public void copyData (Condition c) {
    this.isAtomic = c.isAtomic;
    this.text = c.text;
    this.a = (c.a == null) ? null : new Condition(c.a);
    this.b = (c.b == null) ? null : new Condition(c.b);
    this.composition = c.composition;
  }

  public Condition getA () {
    return a;
  }

  public void setA (Condition a) {
    this.a = a;
  }

  public Condition getB () {
    return b;
  }

  public void setB (Condition b) {
    this.b = b;
  }

  public ConditionComposition getComposition () {
    return composition;
  }

  public void setComposition (ConditionComposition composition) {
    this.composition = composition;
  }

  public boolean isAtomic () {
    return isAtomic;
  }

  public void setAtomic (boolean isAtomic) {
    this.isAtomic = isAtomic;
  }

  public String getText () {
    return text;
  }

  public void changeToComposition (ConditionComposition cc, HaSE editor) {
    this.composition = cc;
    this.isAtomic = false;
    if (this.a == null) this.a = new Condition(editor);
    if (this.b == null) this.b = new Condition(editor);
  }

  public void surroundWithComposition (ConditionComposition cc, HaSE editor) {
    Condition c = new Condition(this);
    changeToComposition(cc, editor);
    this.a = c;
    this.b = new Condition(editor);
  }
  
  public void replaceWithChildA() {
    if (this.a != null) this.copyData(this.a);
  }

  public void replaceWithChildB() {
    if (this.b != null) this.copyData(this.b);
  }

  public Element toElementXML () {
    Element el = new Element("Condition"); 
    el.setAttribute("Text", ""+this.text);
    el.setAttribute("IsAtomic", ""+this.isAtomic);
    
    if (this.composition == null) {
      el.setAttribute("Composition", "-1");
    } else {      
      el.setAttribute("Composition", "" + this.composition.getIndex());
    }

    if (this.a != null) {
      Element conditionA = this.a.toElementXML();
      el.addContent(conditionA);
    }

    if (this.b != null) {
      Element conditionB = this.b.toElementXML();
      el.addContent(conditionB);
    }

    return el;
  }

}
