package de.schmaeck.struktogrammeditor.hamsterInterface;

import java.util.ArrayList;

public class ApplicationExitManager {
  
  private static ArrayList<ExitableApplication> appList = new ArrayList<ExitableApplication>();
  
  public static int addApplication(ExitableApplication app) {
    appList.add(app);
    return appList.size() - 1;
  }
  
  private static void removeApp(int index) {
    for (int i = index +1; i < appList.size(); i++) {
      appList.get(i).changeId(i-1);
    }
    appList.remove(index);
  }
  
  public static void exitApplication(int index) {
    System.out.println("exitApplication #"+index);
    removeApp(index);
    if (appList.size() == 0) {
      System.exit(0);
    }
  }
  
  /**
   * Markiert den durch den Index angegebenen angemeldeten Applikationsteil als 
   * beendet und fordert alle anderen Applikationsteile ber ihre exit-Methode 
   * auf, sich ebenfalls zu beenden.
   * @param index
   */
  public static void exitAllApplications(int index) {
    removeApp(index);
    for (int i = 0; i < appList.size(); i++) {
      if (appList.get(i).exit()) {
        removeApp(i);
        i--;
      }
    }
  }

}
