package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

/** 
 * Reprsentiert die Daten in Form eines ArrayList<StructureElements>-Objektes, 
 * die bei 'Drag and Drop' respektive bei 
 * 'Cut, Copy and Paste' Vorgngen transportiert werden.
 * 
 * @author Martin Schmaeck
 *
 */


public class TransferableSEL implements Transferable {

  public static final int ASK  = 0;
  public static final int COPY = 1;
  public static final int MOVE = 2;

  public DataFlavorSELSelection dataFlavorSELSelection;

  private DataFlavor[] supportedDataFlavors;
  private ArrayList<StructureElement> content;
  private int mode = ASK;
  private HaSE editor;
  private long id;
  private boolean isReturnEquivalent;
  private boolean isMethod;
  private boolean isEmpty;

  
  // ===[ Transferable ]=====
  
  public TransferableSEL (HaSE editor) {
    this.editor = editor;
    this.isReturnEquivalent = false;
    this.isMethod = false;
    this.isEmpty = false;
    this.content = new ArrayList<StructureElement>();
    this.dataFlavorSELSelection = new DataFlavorSELSelection();
    this.id = System.currentTimeMillis();
    this.supportedDataFlavors = new DataFlavor[4];
    this.supportedDataFlavors[0] = DataFlavor.stringFlavor;
    this.supportedDataFlavors[1] = DataFlavor.imageFlavor;
    this.supportedDataFlavors[2] = DataFlavor.getTextPlainUnicodeFlavor();
    this.supportedDataFlavors[3] = dataFlavorSELSelection;
  }
  
  public Object getTransferData (DataFlavor df) throws UnsupportedFlavorException, IOException {
    if (dataFlavorSELSelection.equals(df)) {
      //                  0              1           2             3                      4            5 
      return new Object[]{this.content, this.mode, this.id, this.isReturnEquivalent, this.isMethod, this.isEmpty};
    } else if (df.equals(this.supportedDataFlavors[0])) {
      String code = "";
      for (int i = 0; i < this.content.size(); i++) {
        code += this.content.get(i).genSourceCode("    ", "", editor.environment.getNl());
      }
      return code;
    } else if (df.equals(this.supportedDataFlavors[1])) {
      return editor.environment.icon.getImage(); // TODO: Render Pic and export
    } else if (df.equals(this.supportedDataFlavors[2])) {
      String code = "";
      for (int i = 0; i < this.content.size(); i++) {
        code += this.content.get(i).genSourceCode("    ", "", editor.environment.getNl());
      }
      return code;
    } else {
      throw new UnsupportedFlavorException(df);
    }
  }

  public DataFlavor[] getTransferDataFlavors () {
    return this.supportedDataFlavors;
  }

  public boolean isDataFlavorSupported (DataFlavor df) {
    for (int i = 0; i < this.supportedDataFlavors.length; i++) {
      if (this.supportedDataFlavors[i].equals(df)) return true;
    }
    return false;
  }

  // ---
  
  public void copySelection() {
    try {
      this.isMethod = editor.viewAPI.getSelectionList().isMethodSelected();
    } catch (Exception ex) {
    }
    content = editor.controlAPI.copySelectionToList(null, 0);
    this.isEmpty = this.content.size() == 0;
    
    this.isReturnEquivalent = content.get(content.size()-1).isReturnEquivalent(editor);
  }

  public void moveSelection () {
    try {
      this.isMethod = editor.viewAPI.getSelectionList().isMethodSelected();
    } catch (Exception ex) {
    }
    content = editor.controlAPI.moveSelectionToList(null, 0);
    this.isEmpty = this.content.size() == 0;
    
    this.isReturnEquivalent = content.get(content.size()-1).isReturnEquivalent(editor);
  }

  public void setMode(int mode) {
    this.mode = mode;
  }
  
  public int getMode() {
    return this.mode;
  }

  public void genId () {
    this.id = System.currentTimeMillis();
  }
  
  public long getId() {
    return this.id;
  }



}
