package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.SeperatorMovingSE;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.skins.Skin;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.SeperatorMovingZone;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

public class StructureChartComponentMouseAndMotionListener implements MouseListener, MouseMotionListener,
    MouseWheelListener {

  private HaSE editor;

  // Maussensitive Bereiche
  private ArrayList<SeperatorMovingZone> seperatorMovingZoneList; // Bereich zum ndern interne Breiten

  private ArrayList<MouseOverSEZone> mouseOverSEZoneList; // MouseOver bei SE

  private ArrayList<MouseOverSpaceZone> mouseOverSpaceZoneList; // MouseOver bei SE-Zwischenrumen

  private MethodPixelWidthZone methodPixelWidthZone; // Bereich zum ndern der Gesamtbreite

  // Selektionsinformationen
  private int selectedSeperatorIndex = 0; // wird ein Seperator zum Verschieben selektiert, wird hier sein Index

  // gespeichert

  private int selectedSEIndex = 0; // bei einem SE MouseOver steht hier der Index.

  private int selectedSpaceIndex = 0; // bei einem Zwischenraum ('space') MouseOver steht hier der Index.

  private MouseEvent lastME;

  private int mode = NORMAL;

  private boolean down;

  private final static int NORMAL = 1;

  private final static int SEPERATORMOVING = 2;

  private final static int METHODWIDTHMOVING = 4;

  private final static int MOUSEOVERSE = 8;

  private final static int MOUSEOVERSPACE = 16;

  private final static int SELECTING = 32;


  public StructureChartComponentMouseAndMotionListener (HaSE editor) {
    this.editor = editor;
    this.seperatorMovingZoneList = new ArrayList<SeperatorMovingZone>();
    this.mouseOverSEZoneList = new ArrayList<MouseOverSEZone>();
    this.mouseOverSpaceZoneList = new ArrayList<MouseOverSpaceZone>();
    this.methodPixelWidthZone = new MethodPixelWidthZone();

    this.down = false;
    this.lastME = null;
  }

  public void mouseClicked (MouseEvent me) {
    // setzt den aktuellen modus
    this.mouseMoved(me);

    this.lastME = me;
    System.out.println("click " + this.modeToString() + " " + this.getSEButtonFromRight());

    // Space -> neue CursorPositon
    if (this.mode == MOUSEOVERSPACE) {
      // Erst den Cursor umpositionieren. Es wird nmlich an der aktuellen Cursorposition eingefgt
      CursorPosition cp = this.mouseOverSpaceZoneList.get(this.selectedSpaceIndex).getCursorPosition();
      try {
        editor.viewAPI.getCursorPosition().setData(cp);
      } catch (Exception e) {
      }
      this.editor.viewAPI.markStructureElementMethodAsChanged();
      if (editor.controlAPI.isReachableCode()) {
        if (this.getSpaceButtonFromLeft() == 0) {
          editor.controlAPI.newSE(StructureElement.BLOCK, me.getX(), me.getY());
        } else if (this.getSpaceButtonFromLeft() == 1) {
          editor.controlAPI.newSE(StructureElement.IFBLOCK, me.getX(), me.getY());
        } else if (this.getSpaceButtonFromLeft() == 2) {
          editor.controlAPI.newSE(StructureElement.WHILELOOP, me.getX(), me.getY());
        } else if (this.getSpaceButtonFromLeft() == 3) {
          editor.controlAPI.newSE(StructureElement.DOWHILELOOP, me.getX(), me.getY());
        }
      }
      if (this.getSpaceButtonFromRight() == 0) {
        if (editor.controlAPI.isClipboardWithSEL()) {
          editor.controlAPI.pasteFromClipboard();
        }
      }


      // ------------------------------------------------------------------------

    } else if (this.mode == MOUSEOVERSE) {
      StructureElement se = this.mouseOverSEZoneList.get(this.selectedSEIndex).getSe();

      // SE (nur) selektieren; erster Index, Lnge der Selektion, SE-ArrayList
      if (se.getStructureTyp() != StructureElement.METHODDEF) {
        try {
          editor.viewAPI.getSelectionList().setSelection(
              se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex()).indexOf(
                  se), 1,
              se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex()));

          this.editor.viewAPI.markStructureElementMethodAsChanged();
        } catch (Exception e) {
          System.out.println("HHHAAAAAAAAA!");
          try {
            editor.controlAPI.proofStructure(editor.viewAPI.getSelectedStructureElementMethod(), 2);
          } catch (Exception exx) {
          }
          System.out.println(se);

          e.printStackTrace();
        }
      } else {
        try {
          editor.viewAPI.getSelectionList().selectMethod();
          this.editor.viewAPI.markStructureElementMethodAsChanged();
        } catch (Exception ex) {
          System.out.println("hmmm");
        }
      }
      try {
        // Select Pulldownmenu
        if (this.getSEButtonFromRight() == 0) {

          if (se.isBlockEquivalent()) {
            editor.viewAPI.popupSelectSETypeMenu(me.getX(), me.getY(), false);
          } else if (se.getStructureTyp() == StructureElement.IFBLOCK) {
            editor.viewAPI.popupSelectConditionMenu(me.getX(), me.getY(), StructureElement.NOSE);
          } else if (se.getStructureTyp() == StructureElement.WHILELOOP) {
            editor.viewAPI.popupSelectConditionMenu(me.getX(), me.getY(), StructureElement.NOSE);
          } else if (se.getStructureTyp() == StructureElement.DOWHILELOOP) {
            editor.viewAPI.popupSelectConditionMenu(me.getX(), me.getY(), StructureElement.NOSE);
          } else if (se.getStructureTyp() == StructureElement.METHODDEF && editor.controlAPI.isMethodEditAllowed()) {
            editor.viewAPI.popupSelectMethodMenu(me.getX(), me.getY(), false);
          }


        } else if (this.getSEButtonFromRight() == 2) {
          // Del
          if (se.getStructureTyp() == StructureElement.METHODDEF) {
            editor.controlAPI.deleteMethod();
          } else {
            editor.controlAPI.deleteSelection();
          }

        } else if (this.getSEButtonFromRight() == 3) {
          // Copy
          if (se.getStructureTyp() == StructureElement.METHODDEF) {
            editor.controlAPI.copyMethod();
          } else {
            editor.controlAPI.copySelection();
          }

        } else if (this.getSEButtonFromRight() == 4) {
          // Cut

          if (se.getStructureTyp() == StructureElement.METHODDEF) {
            editor.controlAPI.cutMethod();
          } else {
            editor.controlAPI.cutSelection();
          }


        }
      } catch (Exception ex) {
        System.out.println("..!..");
        ex.printStackTrace();

      }
    }


    // Damit die KeyBindings funktionieren wird ein Fokus bentigt
    ((StructureChartComponent) me.getSource()).requestFocus();
  }

  public void mouseEntered (MouseEvent me) {
    this.mouseMoved(me);
  }

  // ntzlich zum deselektieren von MouseOver-Bereichen
  public void mouseExited (MouseEvent me) {
    this.mouseMoved(me);
  }

  public void mousePressed (MouseEvent me) {
    this.lastME = me;
    this.down = true;

    // setzt den aktuellen modus
    this.mouseMoved(me);


    // System.out.println("MODE: " + this.modeToString());

    if (this.mode == NORMAL) {

      // Alle SeperatorMovingZones berprfen
      if (this.methodPixelWidthZone.isMouseInZone(me.getX(), me.getY())) {
        this.mode = METHODWIDTHMOVING;
        Cursor c = Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);
        ((JComponent) me.getSource()).setCursor(c);
        return;
      }

      for (int i = 0; i < this.seperatorMovingZoneList.size(); i++) {
        if (Math.abs(me.getX() - this.seperatorMovingZoneList.get(i).position) < this.seperatorMovingZoneList.get(i).width
            && this.seperatorMovingZoneList.get(i).top <= me.getY()
            && this.seperatorMovingZoneList.get(i).bottom >= me.getY()) {
          this.mode = SEPERATORMOVING;
          this.selectedSeperatorIndex = i;
          Cursor c = Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);
          ((JComponent) me.getSource()).setCursor(c);
          return;

        }
      }
    } else if (this.mode == MOUSEOVERSE) {
      StructureElement se = this.mouseOverSEZoneList.get(this.selectedSEIndex).getSe();

      // SE selektieren; erster Index, Lnge der Selektion, SE-ArrayList
      try {
        if (!this.editor.viewAPI.getSelectionList().isSeInSelection(se)) {
          System.out.println(":-) + " + se);
          if (se.getStructureTyp() != StructureElement.METHODDEF) {
            editor.viewAPI.getSelectionList().setSelection(
                se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex())
                    .indexOf(se), 1,
                se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex()));
            this.editor.viewAPI.markStructureElementMethodAsChanged();
          } else {
            // TODO: Select Method
          }
        }
      } catch (Exception ex) {
        System.out.println("Ui");
        ex.printStackTrace();
      }
    }
    // } if (this.mode == MOUSEOVERSPACE) {
  }

  public void mouseReleased (MouseEvent me) {
    this.lastME = me;
    this.down = false;

    // beim Breite Verndern (dragging) muss der Modus wieder frei gegeben werden
    if (this.mode == METHODWIDTHMOVING || this.mode == SEPERATORMOVING || this.mode == SELECTING) {
      this.mode = NORMAL;
      this.editor.viewAPI.markStructureElementMethodAsChanged();
    }
  }

  public void mouseDragged (MouseEvent me) {
    mouseMoved(me);
  }

  public void mouseMoved (MouseEvent me) {
    this.lastME = me;

    // System.out.println(this.mode);
    // System.out.println(this.methodPixelWidthZone.isMouseInZone(me.getX(), me.getY()));

    if (this.mode == SEPERATORMOVING) {
      // Cursor c = Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);
      // ((JComponent) me.getSource()).setCursor(c);

      this.seperatorMovingZoneList.get(this.selectedSeperatorIndex).update(me.getX());
      // ((JComponent) me.getSource()).repaint(); // ...
      this.editor.viewAPI.markStructureElementMethodAsChanged();

      // ----------------------------------------------------------------------------

    } else if (this.mode == METHODWIDTHMOVING) {
      this.methodPixelWidthZone.update(me.getX());
      this.editor.viewAPI.markStructureElementMethodAsChanged();
      this.editor.gui.repaint();
      // ((JComponent) me.getSource()).repaint(); // ...

      // ----------------------------------------------------------------------------

    } else if (this.mode == MOUSEOVERSE) {
      if (this.getSEButtonFromRight() == 0) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSSESELECTTYPE), 0);
      } else if (this.getSEButtonFromRight() == 2) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDELETE), 0);
      } else if (this.getSEButtonFromRight() == 3) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSCOPY), 0);
      } else if (this.getSEButtonFromRight() == 4) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSCUT), 0);
      } else {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSSESELECTSE), 0);
      }

      // wieder deselektieren beim verlassen
      if (!this.mouseOverSEZoneList.get(this.selectedSEIndex).isMouseInZone(me.getX(), me.getY())) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT), 0);
        this.mode = NORMAL;
        // vorsichtshalber aus sicht des neuen modus nochmal die neue Mausposition interpretieren
        this.mouseMoved(me);
        return;
      }

      // ----------------------------------------------------------------------------

    } else if (this.mode == MOUSEOVERSPACE) {
      // TODO Optional: controlAPI.if not isReachableCode -> nicht mglich statustexte
      if (this.getSpaceButtonFromLeft() == 0) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSNEWSEBLOCK), 0);
      } else if (this.getSpaceButtonFromLeft() == 1) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSNEWSEIF), 0);
      } else if (this.getSpaceButtonFromLeft() == 2) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSNEWSEFIRSTLOOP), 0);
      } else if (this.getSpaceButtonFromLeft() == 3) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSNEWSELASTLOOP), 0);
      } else if (this.getSpaceButtonFromRight() == 0) {
        if (editor.controlAPI.isClipboardWithSEL()) {
          editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSPASTE), 0);
        } else {
          editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSPASTENOT), 0);
        }
      } else {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSPOSITIONCURSOR), 0);
      }

      // wieder deselektieren beim verlassen
      // dafr den Test auf die 'erweiterten' Grenzen durchfhren
      if (!this.mouseOverSpaceZoneList.get(this.selectedSpaceIndex).isMouseInExtendedZone(me.getX(), me.getY())) {
        editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT), 0);
        if (this.down) {
          this.mode = SELECTING;
        } else {
          this.mode = NORMAL;
        }

        // vorsichtshalber aus sicht des neuen modus nochmal die neue Mausposition interpretieren
        this.mouseMoved(me);

        return;
      }

      // ----------------------------------------------------------------------------

    } else if (this.mode == SELECTING) {
      for (int i = 0; i < this.mouseOverSpaceZoneList.size(); i++) {
        if (this.mouseOverSpaceZoneList.get(i).isMouseInZone(me.getX(), me.getY())) {

          CursorPosition cp1 = this.mouseOverSpaceZoneList.get(selectedSpaceIndex).getCursorPosition();
          CursorPosition cp2 = this.mouseOverSpaceZoneList.get(i).getCursorPosition();

          try {
            editor.viewAPI.getSelectionList().setSelection(cp1, cp2);
          } catch (Exception ex) {

          }
          this.editor.viewAPI.markStructureElementMethodAsChanged();

          ((JComponent) me.getSource()).repaint(); // ...

          return;
        }
      }

      // ----------------------------------------------------------------------------

    } else if (this.mode == NORMAL) {


      // 2. MovingZones
      if (this.methodPixelWidthZone.isMouseInZone(me.getX(), me.getY())) {
        Cursor c = Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);
        ((JComponent) me.getSource()).setCursor(c);
        return;
      }
      for (int i = 0; i < this.seperatorMovingZoneList.size(); i++) {
        if (Math.abs(me.getX() - this.seperatorMovingZoneList.get(i).position) < this.seperatorMovingZoneList.get(i).width
            && this.seperatorMovingZoneList.get(i).top <= me.getY()
            && this.seperatorMovingZoneList.get(i).bottom >= me.getY()) {
          // System.out.println("IN!");
          Cursor c = Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);
          ((JComponent) me.getSource()).setCursor(c);
          return;

        }
      }
      Cursor c = Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR);
      ((JComponent) me.getSource()).setCursor(c);

      // 3. MouseOverSpace & -SE
      for (int i = 0; i < this.mouseOverSEZoneList.size(); i++) {
        if (this.mouseOverSEZoneList.get(i).isMouseInZone(me.getX(), me.getY())) {
          this.selectedSEIndex = i;
          this.mode = MOUSEOVERSE;
          // this.mouseMoved(me);
          ((JComponent) me.getSource()).repaint(); // ...
          // System.out.println("IN!");
          // c = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
          // ((JComponent) me.getSource()).setCursor(c);

          return;
        }
      }
      for (int i = 0; i < this.mouseOverSpaceZoneList.size(); i++) {
        if (this.mouseOverSpaceZoneList.get(i).isMouseInZone(me.getX(), me.getY())) {
          this.selectedSpaceIndex = i;
          this.mode = MOUSEOVERSPACE;
          // this.mouseMoved(me);
          ((JComponent) me.getSource()).repaint(); // ...
          // System.out.println("IN!");
          // c = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
          // ((JComponent) me.getSource()).setCursor(c);

          return;
        }
      }
    }
  }


  // -> nur Reinit falls mode == NORMAL
  private boolean doNotReinitMouseZonesMode () {
    if (this.mode == NORMAL) return false;
    if (this.mode == MOUSEOVERSE) return false;
    if (this.mode == MOUSEOVERSPACE) return false;
    return true;
  }

  public void skinInitMouseZones () {
    // if (this.mode != NORMAL ) return;
    if (this.doNotReinitMouseZonesMode()) return;
    this.mode = NORMAL;

    this.seperatorMovingZoneList.clear();
    this.mouseOverSEZoneList.clear();
    this.mouseOverSpaceZoneList.clear();
  }

  public void addNewSeperatorZone (int maxLeft, int maxRight, SeperatorMovingSE se, int index, int top, int bottom,
      int position, int width) {
    if (doNotReinitMouseZonesMode()) return;
    this.seperatorMovingZoneList
        .add(new SeperatorMovingZone(maxLeft, maxRight, se, index, top, bottom, position, width));
  }

  public void addNewSpaceZone (int o, int u, int l, int r, CursorPosition cp) {
    if (doNotReinitMouseZonesMode()) return;
    this.mouseOverSpaceZoneList.add(new MouseOverSpaceZone(o, u, l, r, cp));

  }

  public void addNewSEZone (int o, int u, int l, int r, StructureElement se) {
    if (doNotReinitMouseZonesMode()) return;
    this.mouseOverSEZoneList.add(new MouseOverSEZone(o, u, l, r, se));
  }

  public void setMethodPixelWidthZone (int o, int u, int position, int width, StructureElementMethod method) {
    if (doNotReinitMouseZonesMode()) return;
    this.methodPixelWidthZone.setData(o, u, position, width, method);
    // this.editor.gui.repaint(); // haHA! hier lag die neuzeichnen-endlosschleife begrndet :-)
  }


  public boolean isMouseOverSE () {
    return this.mode == MOUSEOVERSE;
  }

  public boolean isMouseOverSpace () {
    return this.mode == MOUSEOVERSPACE;
  }

  public MouseOverSEZone getMouseOverSEZone () {
    if (this.isMouseOverSE()) {
      return this.mouseOverSEZoneList.get(this.selectedSEIndex);
    } else {
      return null;
    }
  }

  public MouseOverSpaceZone getMouseOverSpaceZone () {
    if (this.isMouseOverSpace()) {
      return this.mouseOverSpaceZoneList.get(this.selectedSpaceIndex);
    } else {
      return null;
    }
  }

  public void mouseWheelMoved (MouseWheelEvent mwe) {
    if (mwe.isControlDown()) {
      this.editor.environment.setFontSize(this.editor.environment.getFontSize() + mwe.getWheelRotation());
    }
  }

  public int getSpaceButtonFromLeft () {
    if (this.mode != MOUSEOVERSPACE || this.lastME == null) return -1;
    return this.mouseOverSpaceZoneList.get(this.selectedSpaceIndex).getButtonNumberFromLeft(lastME.getX(),
        lastME.getY());
  }

  public int getSpaceButtonFromRight () {
    if (this.mode != MOUSEOVERSPACE || this.lastME == null) return -1;
    return this.mouseOverSpaceZoneList.get(this.selectedSpaceIndex).getButtonNumberFromRight(lastME.getX(),
        lastME.getY());
  }

  public int getSEButtonFromRight () {
    if (this.mode != MOUSEOVERSE || this.lastME == null) return -1;
    return this.mouseOverSEZoneList.get(this.selectedSEIndex).getButtonNumberFromRight(lastME.getX(), lastME.getY());
  }

  public CursorPosition getCursorForCoordinates (Point p) {
    for (int i = 0; i < this.mouseOverSpaceZoneList.size(); i++) {
      if (this.mouseOverSpaceZoneList.get(i).isMouseInExtendedZone(p.x, p.y)) { return this.mouseOverSpaceZoneList.get(
          i).getCursorPosition(); }
    }
    return null; // TODO: Alternativ eine NichtsGefunden-Exception
  }

  public boolean isDown () {
    return this.down;
  }

  // wird insb. nach DnD aktionen aufgerufen - falls das normale
  // MouseReleased-Event nicht wie gewnscht ausgefhrt wird. sehr sinnig
  public void resetMode () {
    this.mode = NORMAL;
    this.down = false;
  }

  // fr debug-zwecke
  public String modeToString () {
    switch (this.mode) {
      case NORMAL: {
        return "NORMAL";
      }
      case SEPERATORMOVING: {
        return "SEPERATORMOVING";
      }
      case METHODWIDTHMOVING: {
        return "METHODWIDTHMOVING";
      }
      case MOUSEOVERSE: {
        return "MOUSEOVERSE";
      }
      case MOUSEOVERSPACE: {
        return "MOUSEOVERSPACE";
      }
      case SELECTING: {
        return "SELECTING";
      }
    }
    return "";
  }
}