package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;

public class MouseOverSpaceZone {

  private int o, u, l, r;

  private CursorPosition cursorPosition;

  public MouseOverSpaceZone (int o, int u, int l, int r, CursorPosition cp) {
    this.o = o;
    this.u = u;
    this.l = l;
    this.r = r;
    this.cursorPosition = cp.copy();
  }

  // wird zum betreten verwendet
  public boolean isMouseInZone (int x, int y) {
    return (o <= y && u >= y && l <= x && r >= x);
  }

  // wird zum verlassen verwendet.
  // ist etwas grer (oben und unten +/- 5)
  // -> erschwert ein versehendliches abrutschen mit der maus
  public boolean isMouseInExtendedZone (int x, int y) {
    return (o - 5 <= y && u + 5 >= y && l <= x && r >= x);
  }

  // x, y: mousekoordinaten
  // liefert einen zhler zurck
  // unter der annahme, dass im MouseOverSpaceZone-Bereich von links
  // her Icons/Buttons aufgereiht werden, welches Icon wird gerade getroffen?
  // Dafr ist es unerheblich, ob es dort 'wirklich' Icons/Buttons gibt.
  // Icongre = 30x28 (breite inkl. Abstand zum nchsten Icon)
  public int getButtonNumberFromLeft (int x, int y) {
    // 19 = breite der 'slots'
    // 3 = abstand des ersten icons zum linken rand
    return (((x - 3) - l) < 0) ? -1 : ((x - 3) - l) / 19;
  }

  public int getButtonNumberFromRight (int x, int y) {
    // 19 = breite der 'slots'
    // 3 = abstand des ersten icons zum linken rand
    return (((r - 3) - x) < 0) ? -1 : ((r - 3) - x) / 19;
  }

  public CursorPosition getCursorPosition () {
    return cursorPosition;
  }

  public void setCursorPosition (CursorPosition cp) {
    this.cursorPosition = cp.copy();
  }

  public int getL () {
    return l;
  }

  public int getO () {
    return o;
  }

  public int getR () {
    return r;
  }

  public int getU () {
    return u;
  }

}
