package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class MouseOverSEZone {
  private int o, u, l, r;
  private StructureElement se;

  public MouseOverSEZone (int o, int u, int l, int r, StructureElement se) {
    this.o = o;
    this.u = u;
    this.l = l;
    this.r = r;
    this.se = se;
  }
  
  public boolean isMouseInZone(int x, int y) {
    return (o <= y && u >= y && l <= x && r >= x);
  }

  public StructureElement getSe () {
    return se;
  }

  public void setSe (StructureElement se) {
    this.se = se;
  }

  public int getL () {
    return l;
  }

  public int getO () {
    return o;
  }

  public int getR () {
    return r;
  }

  public int getU () {
    return u;
  }

  public int getButtonNumberFromRight (int x, int y) {
    
    if (y < (u-20)) return -1;
    // 32 = breite der 'slots'
    // 3 = abstand des ersten icons zum linken rand
    return (((r - 3) - x) < 0) ? -1 : ((r - 3) - x) / 20;
  }
  
  

}
