package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;

public class MethodPixelWidthZone {
  
  private int o, u, position, width;
  private StructureElementMethod method = null;

  public MethodPixelWidthZone() {
    this.o = 0;
    this.u = 0;
    this.position = 0;
    this.width = 0;
  }
  
  public void setData(int o, int u, int position, int width, StructureElementMethod method) {
    this.o = o;
    this.u = u;
    this.position = position;
    this.width = width;
    this.method = method;
  }
  
  public boolean isMouseInZone(int x, int y) {
    return (y > o && y < u && (position - x) < width);
  }

  public double getO () {
    return o;
  }

  public void setO (int o) {
    this.o = o;
  }

  public double getPosition () {
    return position;
  }

  public void setPosition (int position) {
    this.position = position;
  }

  public double getU () {
    return u;
  }

  public void setU (int u) {
    this.u = u;
  }

  public double getWidth () {
    return width;
  }

  public void setWidth (int width) {
    this.width = width;
  }

  public void update (int x) {
    this.position = x + (width / 2);
    this.method.setWidth(this.position);
  }

  
}
