package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.view.dialog.DnDPopupMenu;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;

/**
 * Managet die Drag and Drop Funktionalitt von Strukturelementen. Es gibt pro Struktogramm einen eigenen
 * HaSEDragNDropManager.
 * 
 * @author Martin Schmaeck
 * 
 */
public class HaSEDragNDropManager implements DragSourceListener, DragGestureListener, DropTargetListener {

  private HaSE editor;

  private DragSource dragSource;

  private DropTarget dropTarget;

  // Reprsentiert die serialisierten Daten die bertragen werden.
  // Es gibt pro HaSEDragNDropManager jeweils nur ein transferable, dessen Inhalt
  // bei jeder Drag-Aktion aktualisiert wird.
  private TransferableSEL transferable;


  // --------------------------------------------------------------------------


  // ===[ Konstruktor ]=====

  public HaSEDragNDropManager (HaSE editor, JComponent component) {

    this.editor = editor;

    this.transferable = new TransferableSEL(editor);

    this.dragSource = new DragSource();

    // Param: Component, int=ActionType, DragGestureListener
    this.dragSource.createDefaultDragGestureRecognizer(component, DnDConstants.ACTION_COPY_OR_MOVE, this);

    // Param: Component, DropTargetListener
    this.dropTarget = new DropTarget(component, this);
  }


  // --------------------------------------------------------------------------


  // ===[ DragGestureListener ]=====

  // Ergnzt u.U. einen vorhandenen MouseListener
  // Sollte auf verschiedenen Plattformen getestet werden, da sich die DnD-Gesten
  // unterscheiden knnen.
  // TODO: Test on MS Windows XP:
  // TODO: Test on Linux (KDE, Gnome, ..?):
  // TODO: Test on MacOS ...:

  // hier wird eine Drag-Aktion ausgelst.
  public void dragGestureRecognized (DragGestureEvent e) {


    // Der aktuelle MouseListener wird konsultiert, um gltige Dragbereiche identifizierne zu knnen
    StructureChartComponentMouseAndMotionListener ml = null;
    try {
      ml = this.editor.viewAPI.getHaSEMouseListener();
    } catch (Exception ex) {
      // Zugriff auf notwendige Komponenten nicht mglich? abbruch.
      return;
    }

    if (ml.isMouseOverSE()) {

      this.transferable.copySelection();
      this.transferable.genId();

      int eventModifiersEx = e.getSourceAsDragGestureRecognizer().getTriggerEvent().getModifiersEx();
      if ((eventModifiersEx & InputEvent.BUTTON3_DOWN_MASK) == InputEvent.BUTTON3_DOWN_MASK) {

        // Nachfragen
        this.transferable.setMode(TransferableSEL.ASK);

      } else if ((eventModifiersEx & InputEvent.CTRL_DOWN_MASK) == InputEvent.CTRL_DOWN_MASK) {

        // Kopieren
        this.transferable.setMode(TransferableSEL.COPY);

      } else {

        // Verschieben
        this.transferable.setMode(TransferableSEL.MOVE);

      }

      // Param: DragGestureEvent, Cursur, Transferable, DragSourceListener
      dragSource.startDrag(e, DragSource.DefaultMoveDrop, this.transferable, this);

      // TODO (Optional): bug noch aktuell? workarount implementieren?
      // vergl. know bug # 4874070
      // Sonst htte sehr schn eine Miniaturansicht der Selektion gerendert und
      // an den Cursor gehngt werden knnen. :-(
      //
      // if (DragSource.isDragImageSupported()) {
      //
      // // Param: DragGestureEvent, Cursur, Image, Point, Transferable, DragSourceListener
      // dragSource.startDrag(e, DragSource.DefaultCopyDrop, editor.environment.icon.getImage(), new Point(0, 0),
      // this.transferable, this);
      //
      // } else {
      //
      // // Param: DragGestureEvent, Cursur, Transferable, DragSourceListener
      // dragSource.startDrag(e, DragSource.DefaultMoveDrop, this.transferable, this);
      // }
    }
  }


  // --------------------------------------------------------------------------


  // ===[ DragSourceListener ]=====
  // Diese Methoden beziehen sich auf die Quelle einer Drag-and-Drop-Aktion
  public void dropActionChanged (DragSourceDragEvent e) {
  }

  public void dragExit (DragSourceEvent e) {
    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
  }

  public void dragEnter (DragSourceDragEvent e) {
    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
  }

  public void dragOver (DragSourceDragEvent e) {
  }

  public void dragDropEnd (DragSourceDropEvent e) {
    // Ein *Verschieben* in externe Anwendungen (auch vom gleichen Typ) wird nicht untersttzt.
    // Eine dragDropEnd()-Behandlung (Bspw. das Lschen einer Selektion) auf der
    // -> Source-Seite muss daher nicht mehr angeboten werden.
    // 
    // Workarount:
    // Bei einem anwendungsinternen Drag-And-Drop wird innerhalb der drop-Methode des
    // DropTargetListener (s.u.) eine entsprechende Funktion (copy, move, ask) gewhlt,
    // die ggf. auch das Lschen der alten Selektion bernimmt (source und target
    // befinden sich in der selben Applikationsinstanz, so dass auch die target-Seite
    // notwenige nderungen an der source-Seite ausfhren kann).
    //
    // Ein bisher ungelstes Problem: Bei einem Drop mit der rechten Maustaste
    // soll ein Popupmenu eingeblendet werden, durch welches die Drop-Aktion (copy, move, cancel)
    // bestimmt wird. Nur muss zum Anzeigen und Interagieren mit einer Swing-GUI-Komponete der
    // Event Dispatch Thread wieder freigegeben werden - also die drop()-Methode muss vor der Anzeige
    // eines Popups beendet sein. Damit kann die drop()-Methode selbst nicht mehr von dem Ergebnis
    // der Auswahl profitieren und das bergebene DropTargetDropEvent ist in keinem verwertbaren
    // Zustand mehr.
    // ...
    // Das ist zwar nichts wirklich Wichtiges, aber es wre ein nice-to-have-feature.
    // Insbesondere wrde es eine sauberere Trennung von source- und target-Behandlungen erlauben.
    //
    // Ich werde mich in absehbarer Zeit (heute == 2008-10-xx) nicht mehr damit befassen.
    // Da es sich um ein fr mich ungelstes Problem handelt:
    // Lsungshinweise o.. bitte via E-Mail an: hase@schmaeck.de

    // ---

    // if (e.getDropSuccess() && e.getDropAction() == DnDConstants.ACTION_MOVE) {
    // // lschen der Selektion
    // }
  }


  // ===[ DropTargetListener ]=====

  public void dragExit (DropTargetEvent e) {
  }

  public void dragEnter (DropTargetDragEvent e) {
  }

  // Drag nur erlauben, wenn a) MouseOver Space und b) SEL-Selection-Transferabel
  public void dragOver (DropTargetDragEvent e) {
    try {
      StructureChartComponentMouseAndMotionListener ml = this.editor.viewAPI.getHaSEMouseListener();

      // liefert die CursorPosition eines spaceOver-Maus-Points oder null, falls der
      // Point keine spaceOver-Zone trifft.
      CursorPosition cp = ml.getCursorForCoordinates(e.getLocation());

      if (e.isDataFlavorSupported(this.transferable.dataFlavorSELSelection) && (cp != null)) {
        e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
      } else {
        e.acceptDrag(DnDConstants.ACTION_NONE);
      }
    } catch (Exception ex) {

    }
  }

  public void dropActionChanged (DropTargetDragEvent e) {
  }

  public void drop (DropTargetDropEvent e) {
    try {

      StructureChartComponentMouseAndMotionListener ml = this.editor.viewAPI.getHaSEMouseListener();
      ml.resetMode();
      CursorPosition cp = ml.getCursorForCoordinates(e.getLocation());

      // Nur bei einem Drop mit korrektem DataFlavor und korrektem Zielpunkt
      // wird ein Drop tatschlich durchgefhrt.
      if (e.isDataFlavorSupported(this.transferable.dataFlavorSELSelection) && (cp != null)) {

        // Anmerkung: Fr externe Applikationen steht eh nur ein >copy< zur Verfgung;
        // applikationsintern wird diese Eigenschaft nicht genutzt, da ihr korrekter Wert u.U. erst nach
        // einem Popupdialog und damit lange nach Beenden dieser Methode bestimmbar ist.
        // vergl. Text oben
        e.acceptDrop(DnDConstants.ACTION_COPY);


        // Daten des Transferable extrahieren
//        ArrayList<StructureElement> content = (ArrayList<StructureElement>) ((Object[]) e.getTransferable()
//            .getTransferData(this.transferable.dataFlavorSELSelection))[0];
        Object[] contentArray = ((Object[]) e.getTransferable()
            .getTransferData(this.transferable.dataFlavorSELSelection));
        int mode = (Integer) ((Object[]) e.getTransferable().getTransferData(this.transferable.dataFlavorSELSelection))[1];
        long id = (Long) ((Object[]) e.getTransferable().getTransferData(this.transferable.dataFlavorSELSelection))[2];

        // DnD innerhalb dieser Applikation?
        // Dann: Es stehen copy, move & ask zur Auswahl
        // Sonst: Quelle war eine andere Application. Nur copy erlauben, da von
        // hier aus nicht auf die DragSource zugegriffen werden kann. (vergl. Text weiter oben)
        System.out.println("id " + id + " " + (id == this.transferable.getId()) + " " + this.transferable.getId());

        if (id == this.transferable.getId()) {
          switch (mode) {
            case TransferableSEL.ASK: {
              // DnDPopupMenu m =
              new DnDPopupMenu(editor, contentArray, cp, editor.viewAPI.getSelectedStructureChartComponent(), e
                  .getLocation().x, e.getLocation().y);
              break;
            }
            case TransferableSEL.COPY: {
              this.editor.controlAPI.dndCopy(contentArray, cp);
              break;
            }
            case TransferableSEL.MOVE: {

              this.editor.controlAPI.dndMove(contentArray, cp);
              break;
            }
          }
        } else {
          // nur copy erlauben
          this.editor.controlAPI.dndCopy(contentArray, cp);
        }
        e.getDropTargetContext().dropComplete(true);
      } else {
        e.rejectDrop();
        // e.dropComplete(false);
      }
    } catch (Exception ex) {
      // tja, *sollte* nie eintreten.
      // System.out.println("debug ex1 DnD");
      // ex.printStackTrace();
      try {
        e.rejectDrop();
        // e.dropComplete(false);
      } catch (Exception ex2) {
        // ... !.
        // System.out.println("debug ex2 DnD");
        // ex.printStackTrace();
        // e.dropComplete(true);
      }
    }
  }

  // ----

  public TransferableSEL getTransferable () {
    return this.transferable;
  }


}
