package de.schmaeck.struktogrammeditor.controller.mouseandtransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class HaSEClipboardManager implements ClipboardOwner, FlavorListener {

  private TransferableSEL tranferable;
  private HaSE editor;
  
  public HaSEClipboardManager (HaSE editor) {
    this.editor = editor;
    this.tranferable = new TransferableSEL(editor);
    Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
    sc.addFlavorListener(this); // Ist ein Paste mglich?
//    this.dfss = new DataFlavorSELSelection();
  }
  
  public void copySelection() {
    this.tranferable.copySelection();
    Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
    sc.setContents(this.tranferable, this);
  }
  
  public void moveSelection() {
    this.tranferable.moveSelection();
    Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
    sc.setContents(this.tranferable, this);
  }
  


  // ===[ ClipboardOwner ]=====
  public void lostOwnership (Clipboard cb, Transferable t) {
    this.editor.gui.repaint(); // update der cut-, copy-, paste-icons
  }
  // ---

  public boolean isHasContent () {
    Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
    return sc.isDataFlavorAvailable(this.tranferable.dataFlavorSELSelection);
  }
  
  public boolean isReturnEquivalentInClipboard() {
    try {
      Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
      if (sc.isDataFlavorAvailable(this.tranferable.dataFlavorSELSelection))
      return (Boolean)((Object[]) sc.getData(this.tranferable.dataFlavorSELSelection))[3];
    } catch (Exception e) {
    }
    return false;
  }

  public boolean isMethodInClipboard() {
    try {
      Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
      if (sc.isDataFlavorAvailable(this.tranferable.dataFlavorSELSelection))
      return (Boolean)((Object[]) sc.getData(this.tranferable.dataFlavorSELSelection))[4];
    } catch (Exception e) {
    }
    return false;
  }

  public boolean isEmptyInClipboard() {
    try {
      Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
      if (sc.isDataFlavorAvailable(this.tranferable.dataFlavorSELSelection))
      return (Boolean)((Object[]) sc.getData(this.tranferable.dataFlavorSELSelection))[5];
    } catch (Exception e) {
    }
    return false;
  }

  public ArrayList<StructureElement> pasteContent () {
    ArrayList<StructureElement> out = new ArrayList<StructureElement>();
    try {
      Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
      //sc.setContents(this.tranferable, this);
      if (sc.isDataFlavorAvailable(this.tranferable.dataFlavorSELSelection))
      out = (ArrayList<StructureElement>) ((Object[]) sc.getData(this.tranferable.dataFlavorSELSelection))[0];
    } catch (Exception e) {
      
    }
    return out;
  }
  // ---

  // ===[ FlavorListener ]=====
  /** 
   * Forciert ein gui.repaint(), um neu zu ermitteln, ob ein Einfgen aus der 
   * Zwischenablage sinnvoll mglich ist und damit Paste-Aktionen angeboten werden 
   * drfen. 
   */
  public void flavorsChanged (FlavorEvent arg0) {
    this.editor.gui.repaint(); // update der paste-icons
  }
  
}
