package de.schmaeck.struktogrammeditor.controller;

import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.MainFrameContentPanelProgramView;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

public class Instruction {

  public static final int NOTHING = -1;

  public static final int DELETE = 104;

  public static final int UNDO = 107;

  public static final int REDO = 108;


  private int typ;

  private HaSE editor;

  Object[] param;


  // private static ArrayList<Instruction> recycling = new ArrayList<Instruction>();


  public Instruction () {
    this.typ = NOTHING;
  }

  public Instruction (HaSE editor, int typ, Object[] param) {
    this.typ = typ;
    this.param = param;
    this.editor = editor;
  }


  // Recycling ist zwar eine nette idee, bringt aber praktisch nichts.
  // public static Instruction getNewInstruction() {
  // Instruction inst;
  // if (Instruction.recycling.size() > 0) {
  // inst = Instruction.recycling.remove(Instruction.recycling.size()-1);
  // } else {
  // inst = new Instruction();
  // }
  // return inst;
  // }
  //  
  // public void recycle() {
  // Instruction.recycling.add(this);
  // }

  public void doit () {
    // TODO
    switch (this.typ) {
      case NOTHING:
        break;
      case DELETE:
        ControlAPI.removeSE((ArrayList<StructureElement>) this.param[4], (Integer) this.param[5]);
        ((StructureElementMethod) this.param[6]).updateSize(this.editor);
        ((StructureElementMethod) this.param[6]).setChanged(true);
        break;
    }
  }

  public void undo () {
    // TODO
    switch (this.typ) {
      case NOTHING:
        break;
      case DELETE:
        ControlAPI.restoreSE((StructureElement) this.param[3], (ArrayList<StructureElement>) this.param[4],
            (Integer) this.param[5]);
        ((StructureElementMethod) this.param[6]).updateSize(this.editor);
        ((StructureElementMethod) this.param[6]).setChanged(true);
        break;
    }
    this.updateView();

  }

  public int getTyp () {
    return this.typ;
  }

  public void redo () {
    this.doit();
    this.updateView();


  }


  // Zum Ort des Geschehens springen
  private void updateView () {
    switch (this.typ) {
      case DELETE:
        this.editor.viewAPI.setSelectedProgramView((MainFrameContentPanelProgramView) param[0]);
        this.editor.viewAPI.setSelectedStructureChartComponent((StructureChartComponent) param[1]);
        try {
        this.editor.viewAPI.getCursorPosition().setData((CursorPosition) param[2]);
        } catch (Exception e) {
          editor.environment.errorLog.println("Instruction.updateView()");
          editor.environment.errorLog.println(e.toString());
        }
    }
  }

}
