package de.schmaeck.struktogrammeditor.controller;

import java.io.File;
import javax.swing.filechooser.FileFilter;

import de.schmaeck.struktogrammeditor.HaSE;

public class HaseFileFilter extends FileFilter {
  
  private HaSE editor;

  public HaseFileFilter(HaSE editor) {
    this.editor = editor;
  }

  @Override
  public boolean accept (File file) {
    if (file.isDirectory()) return true;
    String[] extensions = editor.environment.targetProgrammingLanguage.getFileExtensions();
    for (int i = 0; i < extensions.length; i++) {
      if (file.getName().endsWith(extensions[i])) return true;
    }
    return false;
  }

  @Override
  public String getDescription () {
    return editor.environment.targetProgrammingLanguage.getFilterDescription();
  }
}
