package de.schmaeck.struktogrammeditor.controller;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.StructureChartComponentMouseAndMotionListener;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.ConditionComposition;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.dialog.ConditionDialog;
import de.schmaeck.struktogrammeditor.view.environment.EnvironmentSettingFrame;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

/**
 * Definiert 'Aktionen' insb. zur Manipulation des DatenModells. TODO: UNDO/REDO
 * gehrt NICHT hier rein! alles weiterleiten zu controlAPI!
 * 
 * @author Martin Schmaeck
 * 
 */
public class EditorAction implements Action, ActionListener, PopupMenuListener {

	public static final int UP = 100;

	public static final int DOWN = 101;

	public static final int LEFT = 102;

	public static final int RIGHT = 103;

	public static final int DELETE = 104;

	public static final int BACKSPACE = 105;

	public static final int PRINT = 106;

	public static final int UNDO = 107;

	public static final int REDO = 108;

	public static final int OPEN = 109;

	public static final int SAVE = 110;

	public static final int SAVEAS = 111;

	public static final int OPTIONS = 112;

	public static final int NEWPROGRAM = 113;

	public static final int NEWMETHOD = 114;

	public static final int ABOUTHASE = 115;

	public static final int CONTACTME = 116;

	public static final int HELP = 117;

	public static final int IMPROVEMENT = 118;

	public static final int ERRORREPORT = 119;

	public static final int WEBUPDATE = 120;

	public static final int WEBHASE = 121;

	public static final int WEBHAMSTER = 122;

	public static final int STRUKTOGRAMME = 9001;

	public static final int GUESTBOOK = 123;

	public static final int CLOSE = 124;

	public static final int CLOSEALL = 125;

	public static final int SOURCEGEN = 126;

	public static final int IMPORT = 127;

	public static final int EXPORT = 128;

	public static final int EDITPROG = 129;

	public static final int PRINT2 = 130;

	public static final int EXIT = 131;

	public static final int CUTSELECTION = 132;

	public static final int COPYSELECTION = 133;

	public static final int INSERTSELECTION = 134;

	public static final int SELECTALL = 135;

	public static final int EDITSE = 136;

	public static final int CHANGEATOMICBLOCKTYPE = 137;

	// public static final int CREATEATOMICBLOCKTYPE = StructureElement.BLOCK;

	public static final int CHANGECONDITON = 139;

	public static final int CHANGECONDITONFROMDIALOGAI = 140;

	public static final int CHANGECONDITONFROMDIALOGCC = 141;

	public static final int CHANGECONDITONFROMDIALOGCCENCLOSE = 142;

	public static final int CHANGECONDITONFROMDIALOGWITHCHILDA = 143;

	public static final int CHANGECONDITONFROMDIALOGWITHCHILDB = 144;

	public static final int DNDMOVE = 145;

	public static final int DNDCOPY = 146;

	public static final int DNDCANCEL = 147;
	public static final int CREATERETURNBLOCKANDREMOVESE = 148;
	public static final int CHANGEATOMICBLOCKTYPEANDREMOVESE = 149;
	public static final int CHANGEMETHODTYPE = 150;

	public static final int CREATERETURNBLOCKWITHCONDITION = 151;
	public static final int CHANGEATOMICBLOCKTYPEWITHCONDITION = 152;
	public static final int CHANGEATOMICBLOCKTYPEANDREMOVESEWITHCONDITION = 153;
	public static final int CREATERETURNBLOCKANDREMOVESEWITHCONDITION = 154;
	public static final int CHANGEMETHODNAME = 155;

	public static final int TEST = 666;

	private int actionTyp;

	private HaSE editor;

	private Object param; // Optionaler Parameter

	public EditorAction(int actionTyp, HaSE editor) {
		this.actionTyp = actionTyp;
		this.editor = editor;
	}

	// Object == AtomItem xor ConditionComposition
	public EditorAction(int actionTyp, HaSE editor, Object o) {
		this.actionTyp = actionTyp;
		this.editor = editor;
		this.param = o;
	}

	public void actionPerformed(ActionEvent arg0) {

		// --- ... -----
		switch (this.actionTyp) {
		case EXIT:
			System.exit(0);
			return;
		case NEWPROGRAM:
			editor.controlAPI.newProgram();
			return;
		case OPEN:
			editor.controlAPI.openProgram();
			return;
		case SAVE:
			editor.controlAPI.saveProgram();
			return;
		case SAVEAS:
			editor.controlAPI.saveAsProgram();
			return;
		case OPTIONS:
			// Settings, Extras, Optionen, erweiterte Einstellungen
			new EnvironmentSettingFrame(this.editor.gui, this.editor);
			return;

		case CHANGECONDITON:
			try {
				Object[] ob = (Object[]) param;
				editor.controlAPI.changeCondition((AtomicItem) ob[0], null,
						editor.viewAPI.getSelectedSE().getCondition());
			} catch (Exception e) {
			}
			return;
		case CHANGEMETHODTYPE:
			try {
				editor.controlAPI.changeMethodType((String) param);
			} catch (Exception e) {
			}
			return;
		case CHANGEMETHODNAME:
			try {
				editor.controlAPI.changeMethodName();
			} catch (Exception e) {
			}
			return;
		case CHANGECONDITONFROMDIALOGAI: {
			ConditionDialog dialog = (ConditionDialog) ((Object[]) param)[0];
			AtomicItem item = (AtomicItem) ((Object[]) param)[1];
			Condition condition = (Condition) ((Object[]) param)[2];
			editor.controlAPI.changeCondition(item, dialog, condition);
			return;
		}
		case CHANGECONDITONFROMDIALOGCC: {
			ConditionDialog dialog = (ConditionDialog) ((Object[]) param)[0];
			ConditionComposition cc = (ConditionComposition) ((Object[]) param)[1];
			Condition condition = (Condition) ((Object[]) param)[2];
			editor.controlAPI.changeCondition(cc, dialog, condition);
			return;
		}
		case CHANGECONDITONFROMDIALOGCCENCLOSE: {
			ConditionDialog dialog = (ConditionDialog) ((Object[]) param)[0];
			ConditionComposition cc = (ConditionComposition) ((Object[]) param)[1];
			Condition condition = (Condition) ((Object[]) param)[2];
			editor.controlAPI.surroundWithCondition(cc, dialog, condition);
			return;
		}
		case CHANGECONDITONFROMDIALOGWITHCHILDA: {
			ConditionDialog dialog = (ConditionDialog) ((Object[]) param)[0];
			Condition condition = (Condition) ((Object[]) param)[1];
			editor.controlAPI.replaceWithConditionChildA(dialog, condition);
			return;
		}
		case CHANGECONDITONFROMDIALOGWITHCHILDB: {
			ConditionDialog dialog = (ConditionDialog) ((Object[]) param)[0];
			Condition condition = (Condition) ((Object[]) param)[1];
			editor.controlAPI.replaceWithConditionChildB(dialog, condition);
			return;
		}
		case CREATERETURNBLOCKWITHCONDITION: {
			// new return with condition
			editor.controlAPI.newSE(StructureElement.RETURNBLOCK,
					editor.environment.getAtomBlockList().get(0));

			// condition
			try {
				Object[] ob = (Object[]) param;
				editor.controlAPI.changeCondition((AtomicItem) ob[0], null,
						editor.viewAPI.getSelectedSE().getCondition());
			} catch (Exception e) {
			}
			return;
		}
		case CHANGEATOMICBLOCKTYPEWITHCONDITION: {
			// type to RETURN
			editor.controlAPI.changeBlockType(editor.environment
					.getAtomBlockList().get(0), StructureElement.RETURNBLOCK);

			// condition
			try {
				Object[] ob = (Object[]) param;
				editor.controlAPI.changeCondition((AtomicItem) ob[0], null,
						editor.viewAPI.getSelectedSE().getCondition());
			} catch (Exception e) {
			}
			return;
		}

		case CREATERETURNBLOCKANDREMOVESEWITHCONDITION: {
			// new return with condition
			editor.controlAPI.newSE(StructureElement.RETURNBLOCK,
					editor.environment.getAtomBlockList().get(0));

			// condition
			try {
				Object[] ob = (Object[]) param;
				editor.controlAPI.changeCondition((AtomicItem) ob[0], null,
						editor.viewAPI.getSelectedSE().getCondition());

				StructureElement se = (StructureElement) ob[1];
				ControlAPI.removeSE(se.getParentStructureElementList(), se
						.getIndex());
			} catch (Exception e) {
			}
			return;
		}
		case CHANGEATOMICBLOCKTYPEANDREMOVESEWITHCONDITION: {
			// type to RETURN
			editor.controlAPI.changeBlockType(editor.environment
					.getAtomBlockList().get(0), StructureElement.RETURNBLOCK);

			// condition
			try {
				Object[] ob = (Object[]) param;
				editor.controlAPI.changeCondition((AtomicItem) ob[0], null,
						editor.viewAPI.getSelectedSE().getCondition());

				StructureElement se = (StructureElement) ob[1];
				ControlAPI.removeSE(se.getParentStructureElementList(), se
						.getIndex());
			} catch (Exception e) {
			}
			return;
		}
		case CHANGEATOMICBLOCKTYPE: {
			Object[] ob = (Object[]) param;
			editor.controlAPI.changeBlockType((AtomicItem) ob[0],
					(Integer) ob[1]);
			return;
		}
			// case CREATEATOMICBLOCKTYPE:
			// editor.controlAPI.newSE((AtomicItem) param);
			// return;
		case CREATERETURNBLOCKANDREMOVESE: {
			Object[] ob = (Object[]) param;
			StructureElement se = (StructureElement) ob[2];
			editor.controlAPI.newSE(StructureElement.RETURNBLOCK,
					(AtomicItem) ob[0]);
			ControlAPI.removeSE(se.getParentStructureElementList(), se
					.getIndex());
			return;

		}
		case CHANGEATOMICBLOCKTYPEANDREMOVESE: {
			Object[] ob = (Object[]) param;
			editor.controlAPI.changeBlockType((AtomicItem) ob[0],
					(Integer) ob[1]);
			StructureElement se = (StructureElement) ob[2];
			ControlAPI.removeSE(se.getParentStructureElementList(), se
					.getIndex());
			return;
		}
		case DNDMOVE: {
			this.editor.controlAPI.dndMove(
					(Object[]) ((Object[]) this.param)[0],
					(CursorPosition) ((Object[]) this.param)[1]);
			return;
		}
		case DNDCOPY: {
			this.editor.controlAPI.dndCopy(
					(Object[]) ((Object[]) this.param)[0],
					(CursorPosition) ((Object[]) this.param)[1]);
			return;
		}
		case DNDCANCEL: {
			this.editor.controlAPI.dndCancel(
					(Object[]) ((Object[]) this.param)[0],
					(CursorPosition) ((Object[]) this.param)[1]);
			return;
		}
		case CUTSELECTION: {
			this.editor.controlAPI.cutSelection();
			return;
		}
		case COPYSELECTION: {
			this.editor.controlAPI.copySelection();
			return;
		}
		case INSERTSELECTION: {
			this.editor.controlAPI.pasteFromClipboard();
			return;
		}
			// --- Info-Menu -----

		case ABOUTHASE:
			try {
				Desktop desktop = Desktop.getDesktop();
				File file = new File("./documentation/about.html");
				desktop.browse(file.toURI().normalize());
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case HELP:
			try {
				Desktop desktop = Desktop.getDesktop();
				File file = new File("./documentation/help.html");
				desktop.browse(file.toURI().normalize());
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case WEBHAMSTER:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop.browse(new URI("http://www.java-hamster-modell.de/"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case STRUKTOGRAMME: // dibo
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop
						.browse(new URI(
								"http://de.wikipedia.org/wiki/Nassi-Shneiderman-Diagramm"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case WEBHASE:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop.browse(new URI("http://www.schmaeck.de/hase"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case WEBUPDATE:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop.browse(new URI(
						"http://www.schmaeck.de/hase/updateTest.php")); // TODO
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case CONTACTME:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop
						.mail(new URI(
								"mailto:HaSE@Schmaeck.de?subject=[CONTACT]%20Betrefftext"
										+ "&body=Hallo,%0D%0A%0D%0Aich%20habe%20folgende%20Frage%20/%20folgendes%20Anliegen:%20...%0D%0A%0D%0A"
										+ "Besonders%20gut%20gefllt%20mir:%20...%0D%0A%0D%0A"
										+ "Nicht%20so%20gut%20finde%20ich:%20...%0D%0A%0D%0A"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case ERRORREPORT:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop
						.mail(new URI(
								"mailto:HaSE@Schmaeck.de?subject=[ERRORREPORT]%20Betrefftext"
										+ "&body=Hallo,%0D%0A%0D%0Aich%20habe%20folgenden%20Fehler%20gefunden:%20..."));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case IMPROVEMENT:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop
						.mail(new URI(
								"mailto:HaSE@Schmaeck.de?subject=[IMPROVEMENT]%20Betrefftext"
										+ "&body=Hallo,%0D%0A%0D%0Avielleicht%20koennte%20folgendes%20helfen%20den%20Hamster%20StruktogrammEditor%20zu%20verbessern:%20...%0D%0A%0D%0A"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		case GUESTBOOK:
			try {
				Desktop desktop = Desktop.getDesktop();
				desktop.browse(new URI(
						"http://www.schmaeck.de/hase/guestbook/guestbook.php"));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;

		case NEWMETHOD:
			// TODO: undo/redo!
			// nullpointer
			this.editor.controlAPI.newMethod();
			return;
		}

		// --- Mainipulationsfunktionalitt -----
		try {
			CursorPosition cp = this.editor.viewAPI.getCursorPosition();
			CursorPosition cpCopy = cp.copy();
			JComponent structureChartComponent = this.editor.viewAPI
					.getSelectedStructureChartComponent();
			this.editor.viewAPI.markStructureElementMethodAsChanged();

			switch (this.actionTyp) {
			case UP:
				cp.moveCursorUp();
				break;
			case DOWN:
				cp.moveCursorDown();
				break;
			case LEFT:
				cp.moveCursorLeft();
				break;
			case RIGHT:
				cp.moveCursorRight();
				break;
			case BACKSPACE:
				// Gibt es das SE berhaupt?
				if (cp.getIndex() <= 0)
					break;
				cp.setIndex(cp.getIndex() - 1);

			case DELETE: {
				// Gibt es das SE berhaupt?
				if (cp.getIndex() >= cp.getMotherSEL().size())
					break;

				// bentigt: se, sel, index, methodSE
				int index = cp.getIndex();
				ArrayList<StructureElement> sel = cp.getMotherSEL();
				StructureElement se = sel.get(index);
				StructureElementMethod seMethod = this.editor.viewAPI
						.getSelectedStructureElementMethod();

				this.editor.controlAPI.doInstruction(new Instruction(
						this.editor, Instruction.DELETE, new Object[] {
								editor.viewAPI.getSelectedProgramView(),
								editor.viewAPI
										.getSelectedStructureChartComponent(),
								cpCopy, se, sel, index, seMethod }));
			}
				// this.editor.controlAPI.doInstruction(new
				// Instruction(Instruction.DELETE,
				// new Object[]{}));
				break;

			case PRINT:
				this.editor.controlAPI.printMethod();
				break;
			case UNDO:
				this.editor.controlAPI.undo();
				break;
			case REDO:
				this.editor.controlAPI.redo();
				break;
			case TEST: {

				System.out.println("proof");
				StructureElement se = this.editor.viewAPI
						.getSelectedStructureElementMethod();
				editor.controlAPI.proofStructure(se, 0);

				StructureChartComponentMouseAndMotionListener ml = editor.viewAPI
						.getHaSEMouseListener();
				System.out.println(ml.modeToString());
				System.out.println(ml.isDown());
				StructureChartSelectionList sl = editor.viewAPI
						.getSelectionList();
				System.out.println(sl.toString());
				CursorPosition cpx = editor.viewAPI.getCursorPosition();
				System.out.println(cpx.toString());

			}
				break;

			default:
				// TODO
				if (this.actionTyp < 100) {
					editor.controlAPI.newSE(this.actionTyp,
							(AtomicItem) ((Object[]) this.param)[0]);
				}
				break;
			}
		} catch (Exception e) {
		}

		// TODO: nur bei tatschlicher vernderung... also bspw nicht bei
		// cursorbewegungen
		// -> auslagern in die controlAPI methoden
		// this.editor.viewAPI.getStructureElementMethod().updateSize(editor);
		// structureChartComponent.repaint();
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		// TODO Auto-generated method stub
	}

	public Object getValue(String key) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isEnabled() {
		// TODO Auto-generated method stub
		return true;
	}

	public void putValue(String key, Object value) {
		// TODO Auto-generated method stub

	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		// TODO Auto-generated method stub

	}

	public void setEnabled(boolean b) {
		// TODO Auto-generated method stub

	}

	// ===[ PopupMenuListener ]=====
	public void popupMenuCanceled(PopupMenuEvent arg0) {
		if (this.actionTyp == DNDCANCEL) {
			this.editor.controlAPI.dndCancel(
					(Object[]) ((Object[]) this.param)[0],
					(CursorPosition) ((Object[]) this.param)[1]);
		}
	}

	public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
	}

	public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
	}
	// ---
}
