package de.schmaeck.struktogrammeditor.controller;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;

import javax.print.DocFlavor;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.HaSEClipboardManager;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.ConditionComposition;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.environment.KeyBinding;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementBlock;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementFactory;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.dialog.ConditionDialog;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

/**
 * Wichtigste Quasiglobale Kommunikationsschnittstelle vergl ViewAPI Enthlt
 * oder delegiert die meisten Aktionen, die durch Events (Button, Key, Menu)
 * ausgelst werden
 * 
 * Realisiert Applikationweites Undo/Redo
 * 
 */
public class ControlAPI implements Printable {

	private HaSE editor;

	// Manager fr die Kommunikation mit der Systemzwischenablage / Cut, Copy,
	// Paste
	public HaSEClipboardManager clipboard;

	// speichert diejenigen Aktionen, die via UNDO und REDO rckgngig gemacht
	// bzw.
	// wiederhergestellt werden knnen sollen.
	ArrayList<Instruction> undoList;

	// Maximale Anzahl der Rckgngimachbaren Aktionen
	int undoDepth;

	// aktueller Index in der UndoListe
	int undoIndex;

	// true, falls es mindestens ein rckgngig machbares Undo gibt
	boolean undoMode;

	public ControlAPI(HaSE editor) {
		this.editor = editor;
		this.clipboard = new HaSEClipboardManager(editor);
		this.undoDepth = editor.environment.getUndoDepth(); // -> aus der
															// config-Datei
		this.undoList = new ArrayList<Instruction>(this.undoDepth);
		this.undoIndex = 0; // Index der letzten ausgefhrten Aktion
		this.undoMode = false;
	}

	/**
	 * Aktuelles SE vom Typ Block bekommt neuen Inhalt
	 * 
	 * @param ai
	 */
	// public void instructionChangeBlockType (AtomicItem ai) {
	// try {
	// StructureElement se = editor.viewAPI.getSelectedSE();
	// if (se.getStructureTyp() == StructureElement.BLOCK) {
	// ((StructureElementBlock) se).setText(ai.getCodeText());
	// editor.viewAPI.markStructureElementMethodAsChanged();
	// }
	// } catch (Exception e) {
	// editor.environment.errorLog.println("ControlAPI.changeBlockType (AtomicItem ai)");
	// editor.environment.errorLog.println(e.toString());
	// }
	// }
	public void changeBlockType(AtomicItem ai, int type) {
		try {
			StructureElement se = editor.viewAPI.getSelectedSE();
			if (se.isBlockEquivalent()) {
				((StructureElementBlock) se).setText(ai.getCodeText());
				((StructureElementBlock) se).setStructureType(type);
				editor.viewAPI.markStructureElementMethodAsChanged();
			}
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.changeBlockType (AtomicItem ai)");
			editor.environment.errorLog.println(e.toString());
		}
	}

	/**
	 * Methode zum ndern der Bedingung wie sie in passenden StructureElements
	 * vorkommt (Bedingte Anweisung bzw. Schleife mit Wiederholungsbedingung).
	 * Object o ist null (-> initiert ein Popupmenu) oder enthlt einen Wert in
	 * Form eines AtomicItem oder einer ConditionComposition
	 * 
	 * dialog ist null oder enthlt einen dialog, der aktualisiert wird
	 */
	public void changeCondition(Object o, ConditionDialog dialog,
			Condition condition) {
		if (o == null) {

			try {
				// Popup Bedingsbearbeitungsfenster
				StructureElement se = editor.viewAPI.getSelectedSE();
				editor.viewAPI.popupConditionDialog(condition, se);
			} catch (Exception ex) {
				editor.environment.errorLog
						.println("ControlAPI.changeCondition (Object o, ConditionDialog dialog, Condition condition)");
				editor.environment.errorLog.println(ex.toString());
			}

		} else {
			try {
				AtomicItem item = (AtomicItem) o;
				condition.setText(item.getCodeText());
			} catch (Exception e) {
				ConditionComposition cc = (ConditionComposition) o;
				condition.changeToComposition(cc, editor);
			}
		}

		editor.viewAPI.markStructureElementMethodAsChanged();

		if (dialog != null) {
			dialog.updateWorkPanel();
		}
	}

	public void changeMethodName() {
		editor.viewAPI.popupChnageMethodNameDialog();
	}

	public void closeAllTabs() {
		// TODO
	}

	public boolean closeCurrentTab() {
		boolean closed = true;
		// TODO
		// is Saved?
		// then -> wanna close? abbort
		// else -> wanna save? wanna close? abbort

		// not saved?
		// return false
		// else:

		editor.gui.getMainFrameContentPanel().closeSelectedTab();
		return true;
	}

	public void copyMethod() {
		// TODO Auto-generated method stub
	}

	// Veranlasst den ClipboardManager sich die aktuelle Selektion zu kopieren
	public void copySelection() {
		this.clipboard.copySelection();
	}

	// Kopiert die aktuelle Selektion in eine SEL
	public ArrayList<StructureElement> copySelectionToList(
			StructureElement motherSE, int motherSELIndex) {
		ArrayList<StructureElement> outList = new ArrayList<StructureElement>();
		try {

			if (editor.viewAPI.getSelectionList().isMethodSelected()) {
				outList.add(editor.viewAPI.getSelectedStructureElementMethod()
						.copy());
			} else {
				ArrayList<StructureElement> sel = this.editor.viewAPI
						.getSelectionList().getSel();
				for (int i = 0; i < this.editor.viewAPI.getSelectionList()
						.getLength(); i++) {
					StructureElement se = sel.get(
							i
									+ this.editor.viewAPI.getSelectionList()
											.getFirstIndex()).copy();
					se.setParentStructureElement(motherSE);
					se.setParentStructureElementListIndex(motherSELIndex);
					outList.add(se);
				}
			}
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.copySelectionToList(StructureElement motherSE, int motherSELIndex)");
			editor.environment.errorLog.println(e.toString());
		}
		return outList;
	}

	public void cutMethod() {
		// TODO Auto-generated method stub
	}

	public void cutSelection() {
		// TODO: Undo -> Selektion lschen
		System.out.println("cut");
		try {
			if (editor.viewAPI.getSelectionList().isReturnEquivalent(editor)
					&& editor.viewAPI.getSelectionList().isReturnRequired(
							editor))
				return;

			this.editor.viewAPI.getCursorPosition().setMotherSE(
					this.editor.viewAPI.getSelectionList().getFirstSE()
							.getParentStructureElement());
			this.editor.viewAPI.getCursorPosition().setIndex(
					this.editor.viewAPI.getSelectionList().getFirstIndex());
			this.editor.viewAPI.getCursorPosition()
					.setStructureElementListIndex(
							this.editor.viewAPI.getSelectionList().getFirstSE()
									.getParentStructureElementListIndex());

			System.out.println(editor.viewAPI.getCursorPosition());
			System.out.println(editor.viewAPI.getSelectionList());
			this.clipboard.moveSelection();
			this.editor.viewAPI.getSelectionList().unSelect();
			this.editor.viewAPI.getSelectedStructureElementMethod().updateSize(
					editor);
			this.editor.viewAPI.markStructureElementMethodAsChanged();
		} catch (Exception e) {
			editor.environment.errorLog.println("ControlAPI.cutSelection ()");
			editor.environment.errorLog.println(e.toString());
			e.printStackTrace();
		}
	}

	public void deleteMethod() {
		// TODO Auto-generated method stub
		// Lschen erlaubt: gdw. typnderung erlaubt

		try {
			if (!isMethodEditAllowed())
				return;
			if (!isMethodTypeChangeAllowed())
				return;
			editor.viewAPI.getSelectedProgramView().deleteMethod();
			// editor.viewAPI.getSelectedProgramView()
			// if
			// (editor.viewAPI.getSelectedStructureElementMethod().getType().equals(returnType))
			// return;
			// editor.viewAPI.getSelectedStructureElementMethod().setType(returnType);
			// if
			// (returnType.equals(editor.environment.targetProgrammingLanguage.getTypeList()[1]))
			// {
			// editor.viewAPI.getSelectedStructureElementMethod().addReturnIfRequired();
			// }
			//
			// editor.viewAPI.markStructureElementMethodAsChanged();
			// editor.gui.repaint();
		} catch (Exception e) {

		}

	}

	public void deleteSelection() {
		try {
			if (editor.viewAPI.getSelectionList().isReturnEquivalent(editor)
					&& editor.viewAPI.getSelectionList().isReturnRequired(
							editor))
				return;

			this.editor.viewAPI.getCursorPosition().setMotherSE(
					this.editor.viewAPI.getSelectionList().getFirstSE()
							.getParentStructureElement());
			this.editor.viewAPI.getCursorPosition().setIndex(
					this.editor.viewAPI.getSelectionList().getFirstIndex());
			this.editor.viewAPI.getCursorPosition()
					.setStructureElementListIndex(
							this.editor.viewAPI.getSelectionList().getFirstSE()
									.getParentStructureElementListIndex());
			// TODO UNDO/REDO

			// - CP des ersten SE merken
			// - AL merken
			ArrayList<StructureElement> backup = this.moveSelectionToList(null,
					0);

			this.editor.viewAPI.getSelectionList().unSelect();
			this.editor.viewAPI.getSelectedStructureElementMethod().updateSize(
					editor);
			this.editor.viewAPI.markStructureElementMethodAsChanged();
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.deleteSelection ()");
			editor.environment.errorLog.println(e.toString());
		}
	}

	public void dndCancel(Object[] o, CursorPosition cp) {
		try {
			this.editor.viewAPI.getHaSEMouseListener().resetMode();
		} catch (Exception e) {
		}
		// nothing to do :-)
	}

	// dndCopy -> source an bergebene cp kopieren
	public void dndCopy(Object[] o, CursorPosition cp) {
		try {
			ArrayList<StructureElement> source = (ArrayList<StructureElement>) o[0];

			if ((Boolean) o[4])
				return; // Methode
			if ((Boolean) o[5])
				return; // Empty

			// Return allowed oder kein Return im code
			if (isReachableCode(cp))
				if (StructureElement.isNewReturnAllowed(cp.getMotherSE(), cp
						.getStructureElementListIndex(), cp.getIndex(), editor)
						|| !((Boolean) o[3]))
					this.pasteFromDrag(source, cp);
			this.editor.viewAPI.getHaSEMouseListener().resetMode();
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.dndCopy (ArrayList<StructureElement> source, CursorPosition cp)");
			editor.environment.errorLog.println(e.toString());
		}
	}

	// source an cp kopieren, alten selektionsinhalt lschen; verschieben in
	// sich
	// selbst verhindern
	public void dndMove(Object[] o, CursorPosition cp) {
		try {
			ArrayList<StructureElement> source = (ArrayList<StructureElement>) o[0];

			if ((Boolean) o[4])
				return; // Methode
			if ((Boolean) o[5])
				return; // Empty

			// !Return allowed und Return im code
			if ((!isReachableCode(cp))
					|| (!StructureElement.isNewReturnAllowed(cp.getMotherSE(),
							cp.getStructureElementListIndex(), cp.getIndex(),
							editor) && ((Boolean) o[3])))
				return;

			// bentigtes return soll verschoben werden
			if (editor.viewAPI.getSelectionList().isReturnEquivalent(editor)
					&& editor.viewAPI.getSelectionList().isReturnRequired(
							editor))
				return;

			// TODO: ACHTUNG: nicht bercksichtigter fall:
			// ein return soll so verschoben werden, dass dadurch wieder ein
			// stabiler zustand entsteht.
			// wird zur zeit nicht erlaubt. das ist zwar sicher, aber nicht
			// maximal komfortabel

			StructureChartSelectionList selList = editor.viewAPI
					.getSelectionList();

			// -> Ziel (= cp) muss ausserhalb der selektion liegen (sonst:
			// verschieben in sich selbst hinein)
			// if (Ziel ist VOR Selektion || Ziel und Selektion sind in
			// unterschiedlichen listen)
			// -> Selektion lschen, dann einfgen
			// if (Ziel ist nach Selektion in selber SEL)
			// -> cp um selektions-lnge zurck setzten & selektion lschen,
			// dann einfgen
			try {
				if (this.isTargetAfterSelection(cp, selList)) {
					cp.setIndex(cp.getIndex() - selList.getLength());
				}
			} catch (Exception ex) {
				// Verschieben in sich selbst hinein ist sinnfrei und bleibt
				// daher effektlos.
				return;
			}

			this.deleteSelection();
			this.pasteFromDrag(source, cp);
			this.editor.viewAPI.getHaSEMouseListener().resetMode();
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.dndMove (ArrayList<StructureElement> source, CursorPosition cp)");
			editor.environment.errorLog.println(e.toString());
		}

	}

	// fhrt eine Instruktion aus und fgt diese in die undoList ein
	// Undos werden erkannt und ausgefhrt...
	public void doInstruction(Instruction ins) {
		if (ins.getTyp() == Instruction.UNDO) {
			if (this.undoList.size() > 0 && this.undoIndex >= 0) {
				try {
					this.undoList.get(this.undoIndex).undo();
				} catch (Exception e) {
					editor.environment.errorLog
							.println("ControlAPI.doInstruction (Instruction ins) :: UNDO");
					editor.environment.errorLog.println(e.toString());
				}
				this.undoMode = true;
				this.undoIndex--;
			}
		} else if (ins.getTyp() == Instruction.REDO) {
			if (this.undoMode) {
				if (this.undoList.size() > 0
						&& (this.undoIndex + 1) < this.undoList.size()) {
					// auerdem gilt: undoIndex+1 >= 0
					try {
						this.undoList.get(this.undoIndex + 1).redo();
						this.undoIndex++;
					} catch (Exception e) {
						editor.environment.errorLog
								.println("ControlAPI.doInstruction (Instruction ins) :: REDO");
						editor.environment.errorLog.println(e.toString());
					}
				}
			}
		} else {

			if (this.undoMode) {
				// Der Fall: Nach einem UNDO wird eine neue Instruktion
				// ausgefhrt
				// Neue Aktionen machen den aktuellen REDO-Listenabschnitt
				// unbrauchbar
				// Deshalb werden hier potentielle REDO Kanditaten gelscht.
				while (this.undoList.size() > this.undoIndex + 1) {
					this.undoList.remove(this.undoIndex + 1);
				}
				this.undoMode = false;
			}

			// aktuelle Instruktion der undoListe hinzufgen
			this.undoList.add(ins);
			// Die erste undoListen-Instruktion wird gelscht, sobald die
			// Maximallnge erreicht wurde.
			if (this.undoList.size() > this.undoDepth) {
				this.undoList.remove(0);
			}

			// der aktuelle undoIndex wird auf die letzte Instruktion innerhalb
			// der Liste gesetzt.
			this.undoIndex = this.undoList.size() - 1;

			// Die Instruktion wird ausgefhrt
			ins.doit();
		}
	}

	public ArrayList<ProgramModel> getProgramList() {
		return this.editor.model;
	}

	/**
	 * Hilfsmethode, true falls
	 * 
	 * @param cp
	 * @param sel
	 * @return
	 */
	// private boolean isChild (CursorPosition cp, ArrayList<StructureElement>
	// sel) {
	// for (int i = 0; i < sel.size(); i++) {
	// for (int j = 0; j < sel.get(i).getNumberOfStructureElementLists(); j++) {
	// ArrayList<StructureElement> sel2 = sel.get(i).getStructureElementList(j);
	// if (cp.getMotherSEL() == sel2) {
	// return true;
	// } else if (isChild(cp, sel2)) { return true; }
	// }
	// }
	// return false;
	// }
	// true, falls Einfgbare Objekte in der Zwischenablage verfgbar sind
	public boolean isClipboardWithSEL() {
		return this.clipboard.isHasContent();
	}

	/**
	 * Hilfsmethode die testet, ob bei einem dndMove das einfgeziel hinter der
	 * aktuellen Selektion lieget. ist dieses der fall, ... true -> liegt
	 * dahinter flase -> nicht Exception -> liegt IN selektion
	 * 
	 * @param cp
	 * @param selList
	 * @return
	 * @throws Exception
	 */
	private boolean isTargetAfterSelection(CursorPosition cp,
			StructureChartSelectionList selList) throws Exception {

		int index = StructureChartSelectionList.cpChildSearch(selList.getSel(),
				cp);

		System.out.println("index " + index + ", " + selList.getFirstIndex()
				+ " " + selList.getLength());

		if (index == -1) {
			// cp ist weder direkt noch als kindeskind in selList.sel enthalten
			return false;
		} else if ((selList.getSel() == cp.getMotherSEL())
				&& (index >= (selList.getFirstIndex() + selList.getLength()))) {
			// cp in gleicher liste und hinter selektion
			return true;
		} else if ((index >= selList.getFirstIndex())
				&& (index < (selList.getFirstIndex() + selList.getLength()))) {
			throw new Exception(
					"Ungltige CursorPosition beim Drag and Drop Move");
		} else {
			return false;
		}
	}

	public boolean isUndoPossible() {
		return this.undoMode;
	}

	public boolean isRedoPossible() {
		return ((this.undoIndex + 1) < this.undoList.size());
	}

	public ArrayList<StructureElement> moveSelectionToList(
			StructureElement motherSE, int motherSELIndex) {
		ArrayList<StructureElement> outList = new ArrayList<StructureElement>();
		try {
			if (editor.viewAPI.getSelectionList().isMethodSelected()) {
				// Methoden lassen sich nicht verschieben
				outList.add(editor.viewAPI.getSelectedStructureElementMethod()
						.copy());
			} else {
				ArrayList<StructureElement> sel = this.editor.viewAPI
						.getSelectionList().getSel();
				for (int i = 0; i < this.editor.viewAPI.getSelectionList()
						.getLength(); i++) {
					StructureElement se = sel.remove(this.editor.viewAPI
							.getSelectionList().getFirstIndex());
					se.setParentStructureElement(motherSE);
					se.setParentStructureElementListIndex(motherSELIndex);
					outList.add(se);
				}
			}
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.moveSelectionToList (StructureElement motherSE, int motherSELIndex)");
			editor.environment.errorLog.println(e.toString());
		}
		return outList;
	}

	public void newMethod() {
		try {
			editor.viewAPI.getSelectedProgramView().addNewMethod();
		} catch (Exception e) {
			editor.environment.errorLog.println("ControlAPI.newMethod ()");
			editor.environment.errorLog.println(e.toString());
		}
	}

	public void newProgram() {
		try {
			editor.gui.getMainFrameContentPanel().addNewProgram();
		} catch (Exception e) {
			editor.environment.errorLog.println("ControlAPI.newProgram ()");
			editor.environment.errorLog.println(e.toString());
		}
	}

	public void newSE(int type, AtomicItem ai) {

		// TODO: undo und so
		try {
			CursorPosition cp = this.editor.viewAPI.getCursorPosition();
			if (ai == null) {
				StructureElementFactory.createNewStructureElement(cp, type,
						editor);
				editor.viewAPI.markStructureElementMethodAsChanged();
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							changeCondition(null, null, editor.viewAPI
									.getSelectedSE().getCondition());
						} catch (Exception ex) {
						}
					}
				});
			} else {
				StructureElementFactory.createNewStructureElement(cp, type,
						editor, ai.getCodeText());
			}
			cp.moveCursorDown();

			this.editor.viewAPI.getSelectedStructureElementMethod().updateSize(
					editor);
			editor.viewAPI.markStructureElementMethodAsChanged();
			this.editor.viewAPI.getSelectedStructureChartComponent().repaint();
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.newSE (int seId, AtomicItem ai)");
			editor.environment.errorLog.println(e.toString());
		}

	}

	// mit auswahl-popup
	public void newSE(int seId, int x, int y) {
		if (seId == StructureElement.BLOCK) {
			editor.viewAPI.popupSelectSETypeMenu(x, y, true);
		} else {
			editor.viewAPI.popupSelectConditionMenu(x, y, seId);
		}
	}

	public static JFileChooser fc = new JFileChooser("./Programme"); // dibo

	public void openProgram() {
		try {
			FileFilter filter = new HaseFileFilter(editor);
			fc.setFileFilter(filter);
			int returnVal = fc.showOpenDialog(editor.gui);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				editor.gui.getMainFrameContentPanel().addNewProgramm(
						Environment.loadXMLFile(file.getAbsolutePath()),
						file.getAbsolutePath());
			}
		} catch (Exception e) {
			editor.viewAPI.setStatusText(editor.environment.language
					.get(EnvironmentLanguage.STATUSOPENFAILED));
		}
	}

	public void pasteFromClipboard() {
		try {
			ArrayList<StructureElement> source = this.clipboard.pasteContent();
			CursorPosition cp = editor.viewAPI.getCursorPosition();

			if (clipboard.isMethodInClipboard())
				return;
			if (clipboard.isEmptyInClipboard())
				return;

			if (isReachableCode(cp)) {
				if (!clipboard.isReturnEquivalentInClipboard()
						|| StructureElement.isNewReturnAllowed(
								cp.getMotherSE(), cp
										.getStructureElementListIndex(), cp
										.getIndex(), editor)) {
					ArrayList<StructureElement> sel = cp.getMotherSEL();
					for (int i = 0; i < source.size(); i++) {
						StructureElement se = source.get(i).copy();
						se.setParentStructureElement(cp.getMotherSE());
						se.setParentStructureElementListIndex(cp
								.getStructureElementListIndex());
						sel.add(cp.getIndex() + i, se);
					}
					this.repairDataStructure(cp.getMotherSE());
					this.editor.viewAPI.getSelectionList().setSelection(
							cp.getIndex(), source.size(), sel);
					this.editor.viewAPI.getSelectedStructureElementMethod()
							.updateSize(editor);
					this.editor.viewAPI.markStructureElementMethodAsChanged();
				}
			}

		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.pasteFromClipboard ()");
			editor.environment.errorLog.println(e.toString());
		}
	}

	public void pasteFromDrag(ArrayList<StructureElement> source,
			CursorPosition cp) {
		try {

			// TODO ---
			// if (clipboard.isMethodInClipboard()) return;
			// if (clipboard.isEmptyInClipboard()) return;
			//      
			// if (isReachableCode(cp)) {
			// if (!clipboard.isReturnEquivalentInClipboard() ||
			// StructureElement.isNewReturnAllowed(cp.getMotherSE(),
			// cp.getStructureElementListIndex(), cp.getIndex(), editor)) {
			// }
			// }
			// ---

			ArrayList<StructureElement> sel = cp.getMotherSEL();
			for (int i = 0; i < source.size(); i++) {
				StructureElement se = source.get(i).copy();
				se.setParentStructureElement(cp.getMotherSE());
				se.setParentStructureElementListIndex(cp
						.getStructureElementListIndex());
				sel.add(cp.getIndex() + i, se);
			}
			this.editor.viewAPI.getSelectionList().setSelection(cp.getIndex(),
					source.size(), sel);
			this.editor.viewAPI.getSelectedStructureElementMethod().updateSize(
					editor);
			this.editor.viewAPI.markStructureElementMethodAsChanged();
		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.pasteFromDrag (ArrayList<StructureElement> source, CursorPosition cp)");
			editor.environment.errorLog.println(e.toString());
		}

		System.out.println("DragPasteTest");
		this.repairDataStructure(cp.getMotherSE());

	}

	public void pasteMethod() {
		// TODO Auto-generated method stub

	}

	public int print(Graphics g, PageFormat pf, int pageIndex)
			throws PrinterException {
		try {
			int NUMBEROFPAGES = 1;
			// TODO... -> mehrseitig -> SG oder ganzes programm drucken?!
			// DIALOG! auf n Seiten aufteilen? bzw. welche SG?
			// Seitenbereich merken/beim drucken bergeben
			if (pageIndex >= NUMBEROFPAGES)
				return Printable.NO_SUCH_PAGE;
			Graphics2D g2 = (Graphics2D) g;
			double tranX = (int) pf.getImageableX() + 1;
			double tranY = (int) pf.getImageableY() + 1;
			g2.setStroke(new BasicStroke(1.3f, BasicStroke.CAP_ROUND,
					BasicStroke.JOIN_ROUND));
			g2.translate(tranX, tranY);
			this.editor.viewAPI.getSelectedStructureChartComponent()
					.paintLargeForPrinters(g, pf);

		} catch (Exception e) {
			editor.environment.errorLog
					.println("ControlAPI.pasteFromDrag (ArrayList<StructureElement> source, CursorPosition cp)");
			editor.environment.errorLog.println(e.toString());
			return Printable.NO_SUCH_PAGE;
		}
		return Printable.PAGE_EXISTS;
	}

	public void printMethod() {
		PrinterJob pjob = PrinterJob.getPrinterJob();
		try {
			DocFlavor df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
			PrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
			pras.add(MediaSizeName.ISO_A4);
			pras.add(new MediaPrintableArea(10, 10, 190, 277,
					MediaPrintableArea.MM));
			if (pjob.printDialog(pras) == false)
				return;
			pjob.setPrintable(this); // Optional + PageFormat
			pjob.print();
		} catch (PrinterException e) {
			e.printStackTrace();
		}
	}

	public void redo() {
		this.doInstruction(new Instruction(editor, Instruction.REDO, null));
	}

	public void registerKeyBindings(JComponent targetJComponent) {
		ArrayList<KeyBinding> kb = editor.environment.getKeyBindings();
		for (int i = 0; i < kb.size(); i++) {
			// Die KeyBindings sollen so gloabl wie mglich gelten
			targetJComponent.getInputMap(JComponent.WHEN_FOCUSED).put(
					KeyStroke.getKeyStroke(kb.get(i).getKey()),
					kb.get(i).getAction());
			targetJComponent.getInputMap(
					JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(
					KeyStroke.getKeyStroke(kb.get(i).getKey()),
					kb.get(i).getAction());
			targetJComponent.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
					.put(KeyStroke.getKeyStroke(kb.get(i).getKey()),
							kb.get(i).getAction());
		}

		// Die zu den Bindings passenden Aktione festlegen
		// --- Cursor bewegen ---
		targetJComponent.getActionMap().put("CursorUp",
				new EditorAction(EditorAction.UP, editor));
		targetJComponent.getActionMap().put("CursorDown",
				new EditorAction(EditorAction.DOWN, editor));
		targetJComponent.getActionMap().put("CursorLeft",
				new EditorAction(EditorAction.LEFT, editor));
		targetJComponent.getActionMap().put("CursorRight",
				new EditorAction(EditorAction.RIGHT, editor));

		targetJComponent.getActionMap().put("Delete",
				new EditorAction(EditorAction.DELETE, editor));
		targetJComponent.getActionMap().put("BackSpace",
				new EditorAction(EditorAction.BACKSPACE, editor));

		// --- SElemente erstellen ---
		targetJComponent.getActionMap().put("CreateBlock",
				new EditorAction(StructureElement.BLOCK, editor));
		targetJComponent.getActionMap().put("CreateIf",
				new EditorAction(StructureElement.IFBLOCK, editor));
		targetJComponent.getActionMap().put("CreateDoWhile",
				new EditorAction(StructureElement.DOWHILELOOP, editor));

		// --- Drucken ---
		targetJComponent.getActionMap().put("Print",
				new EditorAction(EditorAction.PRINT, editor));

		// --- Drucken ---
		targetJComponent.getActionMap().put("Undo",
				new EditorAction(EditorAction.UNDO, editor));
		// --- Drucken ---
		targetJComponent.getActionMap().put("Redo",
				new EditorAction(EditorAction.REDO, editor));

		targetJComponent.getActionMap().put("NewMethod",
				new EditorAction(EditorAction.NEWMETHOD, editor));

		// --- Test & Debug ---
		targetJComponent.getActionMap().put("Test",
				new EditorAction(EditorAction.TEST, editor));

	}

	public void replaceWithConditionChildA(ConditionDialog dialog,
			Condition condition) {
		condition.replaceWithChildA();
		editor.viewAPI.markStructureElementMethodAsChanged();
		if (dialog != null) {
			dialog.updateWorkPanel();
		}
	}

	public void replaceWithConditionChildB(ConditionDialog dialog,
			Condition condition) {
		condition.replaceWithChildB();
		editor.viewAPI.markStructureElementMethodAsChanged();
		if (dialog != null) {
			dialog.updateWorkPanel();
		}
	}

	public void saveAsProgram() {
		// Filename ermitteln
		// speichern
		try {
			this.editor.viewAPI.setStatusText(this.editor.environment.language
					.get(EnvironmentLanguage.STATUSSAVING), 0);
			FileFilter filter = new HaseFileFilter(editor);
			fc.setFileFilter(filter);
			int returnVal = fc.showSaveDialog(this.editor.gui);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				String name = file.getAbsolutePath();
				if (!name.endsWith(".hase")) {
					name = name + ".hase";
				}
				this.editor.viewAPI.getSelectedProgramView().getProg()
						.setFileName(name);
				saveProgram();
			} else {
				this.editor.viewAPI
						.setStatusText(this.editor.environment.language
								.get(EnvironmentLanguage.STATUSNONSAVED));
				// TODO: bei abbruch oder fehler: nicht speichern, meldung
			}
		} catch (Exception e) {
			editor.environment.errorLog.println("ControlAPI.saveAsProgram ()");
			editor.environment.errorLog.println(e.toString());
		}
	}

	public void saveProgram() {
		try {
			if (this.editor.viewAPI.getSelectedProgramView().getProg()
					.getFileName() == null) {
				saveAsProgram();
			}
			Environment.writeXMLFile(this.editor.viewAPI
					.getSelectedProgramView().getProg().getFileName(),
					this.editor.viewAPI.getSelectedProgramView().getProg()
							.toXML());
			this.editor.viewAPI.setStatusText(this.editor.environment.language
					.get(EnvironmentLanguage.STATUSSAVED));
		} catch (Exception e) {
			editor.environment.errorLog.println("ControlAPI.saveProgram ()");
			editor.environment.errorLog.println(e.toString());
		}

	}

	public void surroundWithCondition(Object o, ConditionDialog dialog,
			Condition condition) {

		ConditionComposition cc = (ConditionComposition) o;
		condition.surroundWithComposition(cc, editor);
		editor.viewAPI.markStructureElementMethodAsChanged();
		if (dialog != null) {
			dialog.updateWorkPanel();
		}
	}

	public void undo() {
		this.doInstruction(new Instruction(editor, Instruction.UNDO, null));
	}

	public static StructureElement removeSE(ArrayList<StructureElement> sel,
			int index) {
		return sel.remove(index);
	}

	public static void restoreSE(StructureElement se,
			ArrayList<StructureElement> sel, int index) {
		sel.add(index, se);
	}

	// setzt bei allen kindern korrekt die vorgnger als eltern.
	// aufruf ist nach einem einfgen via DnD/C&P erforderlich
	public void repairDataStructure(StructureElement root) {
		for (int i = 0; i < root.getNumberOfStructureElementLists(); i++) {
			ArrayList<StructureElement> sel = root.getStructureElementList(i);
			for (int j = 0; j < sel.size(); j++) {
				StructureElement se = sel.get(j);
				se.setParentStructureElement(root);
				se.setParentStructureElementListIndex(i);
				repairDataStructure(se);
			}

		}
	}

	// Debug-Testmethode
	public void proofStructure(StructureElement seIn, int spacey) {
		for (int i = 0; i < seIn.getNumberOfStructureElementLists(); i++) {
			for (int k = 0; k < spacey; k++)
				System.out.print(" ");
			System.out.println("sel: " + i);
			System.out.println();

			ArrayList<StructureElement> sel = seIn.getStructureElementList(i);
			for (int j = 0; j < sel.size(); j++) {
				StructureElement se = sel.get(j);
				for (int k = 0; k < spacey; k++)
					System.out.print(" ");
				System.out.println("-se: " + se);
				for (int k = 0; k < spacey; k++)
					System.out.print(" ");
				System.out.println(" type: " + se.getStructureTyp());
				for (int k = 0; k < spacey; k++)
					System.out.print(" ");
				System.out.println(" Parent: ("
						+ (se.getParentStructureElement() == seIn) + ") "
						+ se.getParentStructureElement());
				for (int k = 0; k < spacey; k++)
					System.out.print(" ");
				System.out.println(" pSEL: ("
						+ (se.getParentStructureElementList() == sel) + ") "
						+ se.getParentStructureElementList());
				for (int k = 0; k < spacey; k++)
					System.out.print(" ");
				System.out.println(" pSEL_index: ("
						+ (se.getParentStructureElementListIndex() == i) + ") "
						+ se.getParentStructureElementListIndex());
				proofStructure(se, spacey + 3);
			}

		}
	}

	public boolean isReachableCode(CursorPosition cp) {
		try {
			return StructureElement.isReachableCode(cp.getMotherSEL(), cp
					.getIndex(), editor);
		} catch (Exception ex) {
		}
		return false;
	}

	public boolean isReachableCode() {
		try {
			CursorPosition cp = editor.viewAPI.getCursorPosition();
			return isReachableCode(cp);
		} catch (Exception ex) {
		}
		return false;
	}

	public boolean isMethodEditAllowed() {
		try {
			// die erste Methode ist die main-Methode und soll als solche
			// erhalten bleiben
			if (editor.viewAPI.getSelectedProgramView().getProg().getMethod(0) == editor.viewAPI
					.getSelectedStructureElementMethod()) {
				return false;
			} else {
				return true;
			}
		} catch (Exception e) {
		}
		return false;
	}

	// Seiteneffekt: lscht passive Conditions die treffer wren
	public static boolean isMethodUsedAsCondtion(Condition c,
			String methodName, HaSE editor) {
		if (c == null)
			return false;
		if (c.getText().equals(methodName + "()")) {
			if (c.isAtomic()) {
				return true;
			} else {
				c.resetText(editor);
			}
		}
		if (isMethodUsedAsCondtion(c.getA(), methodName, editor)) {
			if (c.isAtomic()) {
				c.setA(null);
			} else {
				return true;
			}
		}
		if (isMethodUsedAsCondtion(c.getB(), methodName, editor)) {
			if (c.isAtomic() || c.getComposition().isSingleValue()) {
				c.setB(null);
			} else {
				return true;
			}
		}
		return false;
	}

	// Seiteneffekt: lscht passive Conditions die treffer wren
	public static boolean isMethodUsedAsCondtion(StructureElement se,
			String methodName, HaSE editor) {
		for (int i = 0; i < se.getNumberOfStructureElementLists(); i++) {
			ArrayList<StructureElement> sel = se.getStructureElementList(i);
			for (int j = 0; j < sel.size(); j++) {
				Condition c = sel.get(j).getCondition();
				if (c != null) {
					if (isMethodUsedAsCondtion(c, methodName, editor))
						return true;
				}
				if (isMethodUsedAsCondtion(sel.get(j), methodName, editor))
					return true;
			}
		}
		return false;
	}

	// TODO: nutzen
	public static boolean isMethodUsedAsStructureElement(StructureElement se,
			String methodName) {
		for (int i = 0; i < se.getNumberOfStructureElementLists(); i++) {
			ArrayList<StructureElement> sel = se.getStructureElementList(i);
			for (int j = 0; j < sel.size(); j++) {
				if (sel.get(j).getStructureTyp() == StructureElement.SUBROUTINE) {
					StructureElementBlock seb = (StructureElementBlock) sel
							.get(j);
					if (seb.toString().equals(methodName + "();"))
						return true;
				}
				if (isMethodUsedAsStructureElement(sel.get(j), methodName))
					return true;
			}
		}
		return false;
	}

	public boolean isMethodTypeChangeAllowed() {
		try {
			ProgramModel prog = editor.viewAPI.getSelectedProgramView()
					.getProg();
			for (int i = 0; i < prog.getMethodList().size(); i++) {
				if (isMethodUsedAsCondtion(prog.getMethod(i), editor.viewAPI
						.getSelectedStructureElementMethod().getName(), editor))
					return false;
				if (isMethodUsedAsStructureElement(prog.getMethod(i),
						editor.viewAPI.getSelectedStructureElementMethod()
								.getName()))
					return false;
			}
			return true;
		} catch (Exception ex) {
			return false;
		}
	}

	public void changeMethodType(String returnType) {
		try {
			if (!isMethodEditAllowed())
				return;
			if (!isMethodTypeChangeAllowed())
				return;
			if (editor.viewAPI.getSelectedStructureElementMethod().getType()
					.equals(returnType))
				return;
			editor.viewAPI.getSelectedStructureElementMethod().setType(
					returnType);
			if (returnType.equals(editor.environment.targetProgrammingLanguage
					.getTypeList()[1])) {
				editor.viewAPI.getSelectedStructureElementMethod()
						.addReturnIfRequired();
			}

			editor.viewAPI.markStructureElementMethodAsChanged();
			editor.gui.repaint();
		} catch (Exception e) {

		}
	}

	public static void replaceInCondition(Condition c, String newName,
			String oldName) {
		if (c == null)
			return;
		if (c.getText().equals(oldName + "()")) {
			c.setText(newName + "()");
		}
		replaceInCondition(c.getA(), newName, oldName);
		replaceInCondition(c.getB(), newName, oldName);
	}

	public static void replaceMethodName(StructureElement se, String newName,
			String oldName) {
		for (int i = 0; i < se.getNumberOfStructureElementLists(); i++) {
			ArrayList<StructureElement> sel = se.getStructureElementList(i);
			for (int j = 0; j < sel.size(); j++) {
				if (sel.get(j).getStructureTyp() == StructureElement.SUBROUTINE) {
					StructureElementBlock seb = (StructureElementBlock) sel
							.get(j);
					if (seb.toString().equals(oldName + "();")) {
						seb.setText(newName + "();"); // Hart gecodet.
														// Alternative:
														// environment.targetLanguage...
					}
				} else {
					replaceMethodName(sel.get(j), newName, oldName);
					Condition c = sel.get(j).getCondition();
					if (c != null) {
						replaceInCondition(c, newName, oldName);
					}
				}
			}
		}
	}

	public void renameMethod(StructureElementMethod se, String newName,
			String oldName) {
		try {
			ProgramModel prog = editor.viewAPI.getSelectedProgramView()
					.getProg();
			if (prog.verifyMethodName(newName, oldName)) {
				for (int i = 0; i < prog.getMethodList().size(); i++) {
					replaceMethodName(prog.getMethod(i), newName, oldName);
				}
				se.setName(newName);
				editor.viewAPI.markStructureElementMethodAsChanged();
			}
		} catch (Exception ex) {
		}
	}

}
