package de.schmaeck.struktogrammeditor;

/**
 * Ist fr das Starten einer HaSE-Struktogrammeditor-Instanz zustndig.
 * 
 * @author Martin Schmaeck
 * 
 */
public class Main {
	
	public static HaSE hase; // dibo

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if (args.length > 0) {
			if (args[0].equals("help") || args[0].equals("-help")
					|| args[0].equals("--help") || args[0].equals("?")
					|| args[0].equals("-?") || args[0].equals("--?")
					|| args[0].equals("/?") || args[0].equals("/help")) {

				printHelp();
				return;
			}

			// Pfadangabe einer Config-Datei als Parameter
			hase = new HaSE(args[0]);
			// }
		} else {
			
			try {
				Thread.sleep(2000);
			} catch (Exception exc) {
				
			}

			// Default Config-Dateien suchen/verwenden
			hase = new HaSE(null);
		}
	}

	private static void printHelp() {
		System.out.println();
		System.out.println();
		System.out.println("HaSE - Der Hamster StruktogrammEditor");
		System.out.println("=====================================");
		System.out.println();
		System.out.println("possible parameters: ");
		System.out
				.println("  - none                 ->  load settings from default config file");
		System.out.println("    example: \"...  \"");
		System.out.println();
		System.out
				.println("  - Path-To-Config-File  ->  load settings from specified config file");
		System.out
				.println("    example: \"... /path/.HamsterStruktogrammEditor.config\"");
		// System.out.println();
		// System.out.println("  - NOCONFIG             ->  load built in settings");
		// System.out.println("    example: \"... NOCONFIG\"");
		System.out.println();
		System.out
				.println("                                          http://www.schmaeck.de/hase");
		System.out
				.println("                                              ... have a nice day :-)");
		System.out.println();
	}

}
