package de.schmaeck.struktogrammeditor;

import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.controller.ControlAPI;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.view.MainFrame;
import de.schmaeck.struktogrammeditor.view.ViewAPI;

/**
 * Hamster StruktogrammEditor
 * @author Martin Schmaeck
 *
 */
public class HaSE {
  
  public MainFrame gui; // JFrame-GUI
  public ViewAPI viewAPI; // Zusammenfassende Schnittstelle fr GUI-Methoden
  public ControlAPI controlAPI; // Zusammenfassende Schnittstelle fr Manipulations-Methoden
  public ArrayList<ProgramModel> model; // Datenstruktur/geffnete Dateien

  public Environment environment; // quais globale Umgebungsvariablen


  /**
   * Wird i.d.R. direkt von der Main.java aufgerufen, startet den HamsterStruktogrammEditor und stellt die Wurzel der
   * HamsterStruktogrammEditor-Datenstruktur dar. // Start mit explizitem configFileName == Pfad+File-Angabe // xoder
   * mit configFileName equals "NOCONFIG" fr eingebaute Defaultwerte // xoder mit configFileName == null fr die
   * default Config-File-Suche
   * 
   * @param configFileName kann einen der folgenden Werte enthalten:
   *          <ul>
   *          <li>Pfad zur Konfigurations-Datei (siehe auch {@link Environment}) </li>
   *          <li>xoder "NOCONFIG" fr den Betrieb mit Standardwerten </li>
   *          <li>xoder null fr die Verwendung einer Standard-Konfigurations-Datei. </li>
   *          </ul>
   */
  public HaSE (String configFileName) {


    this.viewAPI = new ViewAPI(this);
    // controlAPI wird von environment erstelltm, da environment-parameter bentigt werden
    this.controlAPI = null;
    
    // Environment-Initialisierung als nebenlufiger Thread, der teilparallel
    // zur GUI-Initialisierung luft.    
    this.environment = new Environment(configFileName, this);
    //this.environment.start(); // Init der Umgebungsvariablen (aus der config-datei)
    this.environment.run(); // dibo

    this.model = new ArrayList<ProgramModel>();
    this.gui = new MainFrame(this); // synchronisiert sich mit dem environment-thread.
  }

  public void setControlAPI (ControlAPI controlAPI) {
    this.controlAPI = controlAPI;
  }
}
