package de.schmaeck.simulator.view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.schmaeck.simulator.controller.SimulatorActionListener;
import de.schmaeck.simulator.controller.SimulatorControllerAPI;
import de.schmaeck.simulator.controller.SimulatorMouseListener;
import de.schmaeck.simulator.model.Field;
import de.schmaeck.simulator.model.Hamster;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.view.ToolBarButton;
import de.schmaeck.struktogrammeditor.view.ToolBarToggleButton;

public class SimulatorPanel extends JPanel {

	// Oben Toolbar
	// Mitte Feldansicht
	// Unten HamsterZustand
	private JPanel toolbar;
	private JPanel fieldView;
	private JPanel fieldViewContainer;
	private JLabel[][] fieldViewIconLabels;
	private JPanel hamsterStatus;
	private HaSE editor;
	private Field field; // Das Hamster-Feld
	private JLabel hamsterStatusLabel;
	private SimulatorControllerAPI controller;
	public ToolBarToggleButton wallButton = null;
	public ToolBarToggleButton cornButton = null;
	public ToolBarToggleButton hamsterButton = null;

	private SizeDialog sizeDialog;

	public SimulatorPanel(HaSE editor) {
		super();
		this.editor = editor;
		this.field = new Field(editor);
		this.controller = new SimulatorControllerAPI(editor, field, this);
		this.editor.environment.simulator.selectScaleLevel(32);
		this.sizeDialog = new SizeDialog(this);
		this.setLayout(new BorderLayout());
		this.add(BorderLayout.NORTH, genToolBar());
		this.add(BorderLayout.CENTER, genFieldViewContainer());
		this.add(BorderLayout.SOUTH, genStatusBar());
		this.addComponentListener(this.controller);
	}

	public void updateView(boolean rescale) {
		if (rescale) {
			Dimension size = fieldViewContainer.getSize();
			editor.environment.simulator.selectScaleLevel(Math.min(size.width
					/ (field.getCols() + 2), size.height
					/ (field.getRows() + 2)));
			// DONE: Das Skalieren in einem Extrathread ist nicht mehr
			// erforderlich, da
			// die Icons jetzt in mehreren Stufen vorskaliert werden.

			// remove(fieldViewContainer);
			// add(BorderLayout.CENTER, genFieldViewContainer());
		}
		for (int row = -1; row <= field.getRows(); row++) {
			for (int col = -1; col <= field.getCols(); col++) {
				updateTile(row, col);
			}
		}
		updateStatusBar();
	}

	public void buildNewView() {
		Dimension size = fieldViewContainer.getSize();
		editor.environment.simulator.selectScaleLevel(Math.min(size.width
				/ (field.getCols() + 2), size.height / (field.getRows() + 2)));

		remove(fieldViewContainer);
		add(BorderLayout.CENTER, genFieldViewContainer());

		updateStatusBar();
	}

	private JPanel genToolBar() {
		toolbar = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		toolbar.setBorder(BorderFactory.createEtchedBorder());

		ToolBarButton newButton = new ToolBarButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2New0,
						this.editor.environment.simulator.iconTTB2New1,
						this.editor.environment.simulator.iconTTB2New2 },
				// editor.environment.language.get(EnvironmentLanguage.STATUSNEW),
				// TODO: language: Alle folgenden Statusnachrichten durch
				// language-aufrufe ersetzten! s.u.
				"Gre des Territoriums neu festlegen ...",
				new ActionListener() {

					public void actionPerformed(ActionEvent ae) {
						final Dimension dim = sizeDialog.requestSize();
						field.setDimension(dim.height, dim.width);
						buildNewView();
					}

				});

		// ToolBarButton newButton = new ToolBarButton(
		// toolbar,
		// this.editor,
		// new Icon[] { this.editor.environment.simulator.iconTTB2New0,
		// this.editor.environment.simulator.iconTTB2New1,
		// this.editor.environment.simulator.iconTTB2New2 },
		// // editor.environment.language.get(EnvironmentLanguage.STATUSNEW),
		// // TODO: language: Alle folgenden Statusnachrichten durch
		// // language-aufrufe ersetzten! s.u.
		// "Kachelauflsung der Hamsterwelt neu festlegen ...",
		// new ActionListener() {
		//
		// public void actionPerformed(ActionEvent ae) {
		// JDialog d = new JDialog(editor.gui);
		// d
		// .setTitle("Kachelanzahl der Zeilen und Spalten ndern");
		// JPanel p = new JPanel(new GridBagLayout());
		// GridBagConstraints c;
		// c = new GridBagConstraints();
		// c.gridx = 0;
		// c.gridy = 0;
		// p.add(new JLabel("Anzahl Zeilen:"), c);
		//
		// c = new GridBagConstraints();
		// c.gridx = 0;
		// c.gridy = 1;
		// p.add(new JLabel("Anzahl Spalten:"), c);
		//
		// c = new GridBagConstraints();
		// c.gridx = 1;
		// c.gridy = 0;
		// SpinnerNumberModel snm = new SpinnerNumberModel(field
		// .getRows(), 1, 30, 1);
		// JSpinner s = new JSpinner(snm);
		// snm.addChangeListener(new ChangeListener() {
		//
		// public void stateChanged(ChangeEvent ce) {
		// field.setDimension(((SpinnerNumberModel) ce
		// .getSource()).getNumber().intValue(),
		// field.getCols());
		// buildNewView();
		// }
		// });
		// p.add(s, c);
		//
		// c = new GridBagConstraints();
		// c.gridx = 1;
		// c.gridy = 1;
		// snm = new SpinnerNumberModel(field.getCols(), 1, 30, 1);
		// snm.addChangeListener(new ChangeListener() {
		//
		// public void stateChanged(ChangeEvent ce) {
		// field.setDimension(field.getRows(),
		// ((SpinnerNumberModel) ce.getSource())
		// .getNumber().intValue());
		// buildNewView();
		// }
		// });
		// s = new JSpinner(snm);
		// p.add(s, c);
		//
		// d.setContentPane(p);
		// d.pack();
		// d.setVisible(true);
		// }
		//
		// });

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2Open0,
				this.editor.environment.simulator.iconTTB2Open1,
				this.editor.environment.simulator.iconTTB2Open2 }, "Laden ...",
				new SimulatorActionListener(editor, controller,
						SimulatorActionListener.OPEN));

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2Save0,
				this.editor.environment.simulator.iconTTB2Save1,
				this.editor.environment.simulator.iconTTB2Save2 },
				"Speichern ...", new SimulatorActionListener(editor,
						controller, SimulatorActionListener.SAVEAS));

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2Reset0,
				this.editor.environment.simulator.iconTTB2Reset1,
				this.editor.environment.simulator.iconTTB2Reset2 },
				"Die zuletzt gespeicherte Hamsterwelt wiederherstellen.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						field.restore();
						controller.stop();
						updateView(false);
					}
				});

		toolbar.add(new JLabel(editor.environment.iconTTBSeperator));

		this.cornButton = new ToolBarToggleButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2Korn0,
						this.editor.environment.simulator.iconTTB2Korn1,
						this.editor.environment.simulator.iconTTB2Korn2 },
				"Krner auf einer Kachel hinzufgen / entfernen (Linke / Rechte Maustaste)",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						ToolBarToggleButton button = (ToolBarToggleButton) ae
								.getSource();
						if (button.isSelected()
								&& controller.getState() != SimulatorControllerAPI.CORNEDIT) {
							controller
									.setState(SimulatorControllerAPI.CORNEDIT);
							wallButton.setSelected(false);
							hamsterButton.setSelected(false);
						} else if (!button.isSelected()
								&& controller.getState() == SimulatorControllerAPI.CORNEDIT) {
							cornButton.setSelected(true);
						}
					}
				});

		this.wallButton = new ToolBarToggleButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2Wall0,
						this.editor.environment.simulator.iconTTB2Wall1,
						this.editor.environment.simulator.iconTTB2Wall2 },
				"Mauer auf eine Kachel setzten / entfernen (Linke / Rechte Maustaste)",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						ToolBarToggleButton button = (ToolBarToggleButton) ae
								.getSource();
						if (button.isSelected()
								&& controller.getState() != SimulatorControllerAPI.WALLEDIT) {
							controller
									.setState(SimulatorControllerAPI.WALLEDIT);
							cornButton.setSelected(false);
							hamsterButton.setSelected(false);
						} else if (!button.isSelected()
								&& controller.getState() == SimulatorControllerAPI.WALLEDIT) {
							wallButton.setSelected(true);
						}
					}
				});
		this.wallButton.setSelected(true);

		this.hamsterButton = new ToolBarToggleButton(toolbar, this.editor,
				new Icon[] {
						this.editor.environment.simulator.iconTTB2Hamster0,
						this.editor.environment.simulator.iconTTB2Hamster1,
						this.editor.environment.simulator.iconTTB2Hamster2 },
				"Hamster platzieren und durch weitere Klicks drehen.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						ToolBarToggleButton button = (ToolBarToggleButton) ae
								.getSource();
						if (button.isSelected()
								&& controller.getState() != SimulatorControllerAPI.HAMSTEREDIT) {
							controller
									.setState(SimulatorControllerAPI.HAMSTEREDIT);
							cornButton.setSelected(false);
							wallButton.setSelected(false);
						} else if (!button.isSelected()
								&& controller.getState() == SimulatorControllerAPI.HAMSTEREDIT) {
							hamsterButton.setSelected(true);
						}
					}
				});

		toolbar.add(new JLabel(editor.environment.iconTTBSeperator));

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2HamKornPlus0,
				this.editor.environment.simulator.iconTTB2HamKornPlus1,
				this.editor.environment.simulator.iconTTB2HamKornPlus2 },
				"Ein Korn zum Vorrat im Hamstermaul hinzufgen.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						field.hamster.addCorn();
						updateTile(field.hamster.getRow(), field.hamster
								.getCol());
						updateStatusBar();
					}
				});

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2HamKornMinus0,
				this.editor.environment.simulator.iconTTB2HamKornMinus1,
				this.editor.environment.simulator.iconTTB2HamKornMinus2 },
				"Ein Korn aus dem Vorrat im Hamstermaul entfernen.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						field.hamster.subCorn();
						updateTile(field.hamster.getRow(), field.hamster
								.getCol());
						updateStatusBar();
					}
				});

		toolbar.add(new JLabel(editor.environment.iconTTBSeperator));

		new ToolBarButton(toolbar, this.editor, new Icon[] {
				this.editor.environment.simulator.iconTTB2Play0,
				this.editor.environment.simulator.iconTTB2Play1,
				this.editor.environment.simulator.iconTTB2Play2 },
				"PLAY: Das aktuelle Hamsterprogramm abarbeiten.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						controller.play();
					}
				});

		new ToolBarButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2Pause0,
						this.editor.environment.simulator.iconTTB2Pause1,
						this.editor.environment.simulator.iconTTB2Pause2 },
				"PAUSE: Die Abarbeitung des Aktuellen Hamsterprogramms pausiern / fortsetzten.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						controller.pause();
					}
				});

		new ToolBarButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2Step0,
						this.editor.environment.simulator.iconTTB2Step1,
						this.editor.environment.simulator.iconTTB2Step2 },
				"STEP: Nur den nchsten Hamsterprogramm-Anweisungsschritt ausfhren.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						controller.step();
					}
				});

		new ToolBarButton(
				toolbar,
				this.editor,
				new Icon[] { this.editor.environment.simulator.iconTTB2Stop0,
						this.editor.environment.simulator.iconTTB2Stop1,
						this.editor.environment.simulator.iconTTB2Stop2 },
				"STOPP: Die Abarbeitung des aktuellen Hamsterprogrammes beenden.",
				new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						controller.stop();
					}
				});

		toolbar.add(new JLabel(editor.environment.iconTTBSeperator));

		// new ToolBarButton(
		// toolbar,
		// this.editor,
		// new Icon[] {
		// this.editor.environment.simulator.iconTTB2Edit0,
		// this.editor.environment.simulator.iconTTB2Edit1,
		// this.editor.environment.simulator.iconTTB2Edit2
		// },
		// "Verzgerungszeit fr Anweisungsschritte festlegen.",
		// new ActionListener() {
		// public void actionPerformed (ActionEvent ae) {
		//                  
		// JDialog d = new JDialog(editor.gui);
		// d.setTitle("Verzgerungszeit fr Hamsterbefehle in msec");
		// JPanel p = new JPanel(new GridBagLayout());
		// GridBagConstraints c;
		// c = new GridBagConstraints();
		// c.gridx = 0;
		// c.gridy = 0;
		// p.add(new
		// JLabel("Verzgerungszeit pro Befehl in [ms] (1000ms = 1s):"), c);
		//            
		// c = new GridBagConstraints();
		// c.gridx = 1;
		// c.gridy = 0;
		// SpinnerNumberModel snm = new
		// SpinnerNumberModel(controller.getDelay(), 1, 60000, 250);
		// JSpinner s = new JSpinner(snm);
		// snm.addChangeListener(new ChangeListener() {
		// public void stateChanged (ChangeEvent ce) {
		// controller.setDelay(((SpinnerNumberModel)
		// ce.getSource()).getNumber().intValue());
		// }});
		// p.add(s, c);
		//            
		//            
		// d.setContentPane(p);
		// d.pack();
		// d.setVisible(true);
		// }
		// });

		final JSlider speedSlider = new JSlider(SwingConstants.HORIZONTAL, 0,
				100, 50);
		controller.setDelay(50);
		speedSlider.setMajorTickSpacing(50);
		speedSlider.setMinorTickSpacing(25);
		speedSlider.setPaintTicks(true);
		speedSlider.setPaintLabels(false);
		speedSlider.setSnapToTicks(false);

		speedSlider.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent ae) {
				controller.setDelay(speedSlider.getValue());
			}
		});

		toolbar.add(speedSlider);

		// JButton saveButton = new JButton("S");
		// saveButton.addActionListener(new SimulatorActionListener(editor,
		// controller, SimulatorActionListener.SAVE));
		// toolbar.add(saveButton);

		// JButton printButton = new JButton("Drucken");
		// toolbar.add(printButton);

		// JButton reloadButton = new JButton("Re");
		// toolbar.add(reloadButton);

		// JButton hamsterLeftButton = new JButton("<");
		// hamsterLeftButton.addActionListener(new ActionListener() {
		// public void actionPerformed (ActionEvent ae) {
		// field.hamster.linksUm();
		// updateTile(field.hamster.getRow(), field.hamster.getCol());
		// }
		// });
		// toolbar.add(hamsterLeftButton);
		//
		// JButton hamsterRightButton = new JButton(">");
		// hamsterRightButton.addActionListener(new ActionListener() {
		// public void actionPerformed (ActionEvent ae) {
		// field.hamster.rechtsUm();
		// // updateView(false);
		// updateTile(field.hamster.getRow(), field.hamster.getCol());
		// }
		// });
		// toolbar.add(hamsterRightButton);

		// ---

		return toolbar;
	}

	private JPanel genFieldViewContainer() {
		fieldView = new JPanel();
		fieldViewIconLabels = new JLabel[this.field.getRows() + 2][this.field
				.getCols() + 2];
		fieldView.setLayout(new GridLayout(this.field.getRows() + 2, this.field
				.getCols() + 2, 0, 0));
		for (int row = -1; row < this.field.getRows() + 1; row++) {
			for (int col = -1; col < this.field.getCols() + 1; col++) {
				JLabel tile = null;
				if (field.hamster.getRow() == row
						&& field.hamster.getCol() == col) {
					if (field.hamster.getCornCounter() > 0) {
						switch (field.hamster.getDirection()) {
						case Hamster.NORTH: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCornNorth());
							break;
						}
						case Hamster.EAST: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCornEast());
							break;
						}
						case Hamster.SOUTH: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCornSouth());
							break;
						}
						case Hamster.WEST: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCornWest());
							break;
						}
						}
					} else {
						switch (field.hamster.getDirection()) {
						case Hamster.NORTH: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconNorth());
							break;
						}
						case Hamster.EAST: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconEast());
							break;
						}
						case Hamster.SOUTH: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconSouth());
							break;
						}
						case Hamster.WEST: {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconWest());
							break;
						}
						}
					}

				} else {
					// kein Hamster
					switch (field.getState(row, col)) {
					case Field.WALL: {
						tile = new JLabel(editor.environment.simulator
								.getScaledIconWall());
						break;
					}
					case Field.EMPTY: {
						tile = new JLabel(editor.environment.simulator
								.getScaledIconBlank());
						break;
					}
					default: {
						if (field.getState(row, col) < 24) {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCorn()[field.getState(row,
									col)]);
							break;
						} else {
							tile = new JLabel(editor.environment.simulator
									.getScaledIconCorn()[24]);
							break;
						}
					}
					}
				}
				// Der MouseListener erlaubt das Editieren der Hamsterwelt :-)
				tile.addMouseListener(new SimulatorMouseListener(row, col,
						editor, controller, field));
				fieldViewIconLabels[row + 1][col + 1] = tile;
				fieldView.add(tile);

			}
		}

		fieldView.setMinimumSize(new Dimension(32, 32));

		fieldViewContainer = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		fieldViewContainer.add(fieldView);

		return fieldViewContainer;
	}

	// row, col jeweils von -1 bis maxRow/col +1; der rnder wegen
	public void updateTile(int row, int col) {
		if (field.hamster.getRow() == row && field.hamster.getCol() == col) {
			if (field.hamster.getCornCounter() > 0) {
				switch (field.hamster.getDirection()) {
				case Hamster.NORTH: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCornNorth());
					break;
				}
				case Hamster.EAST: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCornEast());
					break;
				}
				case Hamster.SOUTH: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCornSouth());
					break;
				}
				case Hamster.WEST: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCornWest());
					break;
				}
				}
			} else {
				switch (field.hamster.getDirection()) {
				case Hamster.NORTH: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconNorth());
					break;
				}
				case Hamster.EAST: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconEast());
					break;
				}
				case Hamster.SOUTH: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconSouth());
					break;
				}
				case Hamster.WEST: {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconWest());
					break;
				}
				}
			}

		} else {
			// kein Hamster
			switch (field.getState(row, col)) {
			case Field.WALL: {
				this.fieldViewIconLabels[row + 1][col + 1]
						.setIcon(editor.environment.simulator
								.getScaledIconWall());
				break;
			}
			case Field.EMPTY: {
				this.fieldViewIconLabels[row + 1][col + 1]
						.setIcon(editor.environment.simulator
								.getScaledIconBlank());
				break;
			}
			default: {
				if (field.getState(row, col) < 24) {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCorn()[field.getState(row,
									col)]);
					break;
				} else {
					this.fieldViewIconLabels[row + 1][col + 1]
							.setIcon(editor.environment.simulator
									.getScaledIconCorn()[24]);
					break;
				}
			}
			}
		}
	}

	private JPanel genStatusBar() {
		this.hamsterStatus = new JPanel(new FlowLayout(FlowLayout.CENTER, 0, 0));
		this.hamsterStatusLabel = new JLabel(this.field.hamster.toString());
		this.hamsterStatus.add(this.hamsterStatusLabel);
		this.hamsterStatus.setBorder(BorderFactory.createEtchedBorder());
		return this.hamsterStatus;
	}

	private void updateStatusBar() {
		int hamsterCornCounter = field.hamster.getCornCounter();
		int fieldCornCounter = field.getState(field.hamster.getRow(),
				field.hamster.getCol());
		// TODO: Language!
		hamsterStatusLabel.setText(hamsterCornCounter + " Krner im Maul, "
				+ fieldCornCounter + " Krner auf der aktuellen Kachel.");

	}

}
