package de.schmaeck.simulator.model;

import de.schmaeck.simulator.exceptions.GibException;
import de.schmaeck.simulator.exceptions.NimmException;
import de.schmaeck.simulator.exceptions.VorException;

public class Hamster {

  // Anzal Krner im Hamstermaul
  private int cornCounter;
  
  // Koordinaten des Hamsters
  private int row;
  private int col;
  
  // Blickrichtung (NORTH, EAST, SOUTH oder WEST)
  private int direction;
  
  private Field field;
  
  public static final int NORTH = 0;
  public static final int EAST  = 1;
  public static final int SOUTH = 2;
  public static final int WEST  = 3;
  
  public Hamster (Field field, int row, int col, int direction) {
    this.field = field;
    this.row = row;
    this.col = col;
    this.direction = direction;
    this.cornCounter = 0;
  }

  public Hamster (Field field, int row, int col, int direction, int cornCounter) {
    this(field, row, col, direction);
    this.cornCounter = cornCounter;
  }
  
  public static String directionToString(int direction) {
    switch (direction) {
      case NORTH: {
        return "Norden";
      }
      case EAST: {
        return "Osten";
      }
      case SOUTH: {
        return "Sden";
      }
      case WEST: {
        return "Westen";
      }
      default: {
        return "-";
      }
    }
  }
  
  // Ungenutzt, debugging-info
  public String toString() {
    return "Hamster (Zeile, Spalte: " + this.row + ", " + this.col + "; Krner: " + this.cornCounter + "; " 
    + directionToString(this.direction) +")\n";
  }
  
  public int getCol () {
    return this.col;
  }

  public int getRow () {
    return this.row;
  }
  
  public int getDirection() {
    return this.direction;
  }
  
  public char getDirectionChar() {
    switch (direction) {
      case NORTH: {
        return '^';
      }
      case EAST: {
        return '>';
      }
      case SOUTH: {
        return 'v';
      }
      case WEST: {
        return '<';
      }
      default: {
        return '-';
      }
    }
  }
  
  // ===[ Hamster-Befehle ]======

  public void linksUm() {
    this.direction = (this.direction+3) % 4;
  }

  public void rechtsUm() {
    this.direction = (this.direction+1) % 4;
  }

  public void vor() throws VorException {
    // 1. neue Koordinate ermitteln
    int row = this.row;
    int col= this.col;
    switch (this.direction) {
      case NORTH: {
        row--;
        break;
      }
      case EAST: {
        col++;
        break;
      }
      case SOUTH: {
        row++;
        break;
      }
      case WEST: {
        col--;
        break;
      }
    }
    
    // 2. Ist die neue Kachel passierbar?
    if (field.getState(row, col) == Field.WALL) {
      throw new VorException();
    } else {
      this.col = col;
      this.row = row;
    }
  }
  
  public void gib() throws GibException {
    if (this.cornCounter == 0) {
      throw new GibException();
    } else {
      this.cornCounter--;
      field.addCorn(this.row, this.col);
    }
  }

  public void nimm() throws NimmException {
    if (this.field.getState(this.row, this.col) < 1) {
      throw new NimmException();
    } else {
      this.cornCounter++;
      field.subCorn(this.row, this.col);
    }
  }
  
  // ===[ Hamster-Bedigungen ]======
  
  public boolean maulLeer() {
    return this.cornCounter == 0;
  }
  
  public boolean kornDa() {
    return this.field.getState(this.row, this.col) > 0;
  }
  
  public boolean vornFrei() {
    int row = this.row;
    int col= this.col;
    switch (this.direction) {
      case NORTH: {
        row--;
        break;
      }
      case EAST: {
        col++;
        break;
      }
      case SOUTH: {
        row++;
        break;
      }
      case WEST: {
        col--;
        break;
      }
    }
    return this.field.getState(row, col) != Field.WALL;
  }

  // ---
  
  public void addCorn() {
    this.cornCounter++;
  }
  
  public void subCorn() {
    if (this.cornCounter > 0) this.cornCounter--;
  }
  
  
  public void setCornCounter (int cornCounter) {
    this.cornCounter = cornCounter;
  }

  public int getCornCounter () {
    return this.cornCounter;
  }

  public void locate (int row, int col) {
    this.row = row;
    this.col = col;
  }
  
  

}
