package de.schmaeck.simulator.controller;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import de.schmaeck.simulator.model.Field;
import de.schmaeck.struktogrammeditor.HaSE;

public class SimulatorMouseListener implements MouseListener {

	private HaSE editor;

	private SimulatorControllerAPI controller;

	private Field field;

	private int row;

	private int col;

	public SimulatorMouseListener(int row, int col, HaSE editor,
			SimulatorControllerAPI controller, Field field) {
		this.row = row;
		this.col = col;
		this.editor = editor;
		this.controller = controller;
		this.field = field;
	}

	public void mousePressed(MouseEvent me) {
		switch (controller.getState()) {
		case SimulatorControllerAPI.WALLEDIT: {
			field.toggleWall(row, col);
			break;
		}
		case SimulatorControllerAPI.CORNEDIT: {
			// if (me.getClickCount() > 1) {
			// } else
			if (me.getButton() == MouseEvent.BUTTON1) {
				field.addCorn(row, col);
			} else {
				field.subCorn(row, col);
			}
			break;
		}
		case SimulatorControllerAPI.HAMSTEREDIT: {
			int oldRow = field.hamster.getRow();
			int oldCol = field.hamster.getCol();
			field.locateHamster(row, col, me.getButton() == MouseEvent.BUTTON1);
			controller.updateTile(oldRow, oldCol);
			break;
		}
		}
		controller.updateTile(row, col);
	}

	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

}
