package de.schmaeck.simulator.controller;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import de.schmaeck.simulator.model.Field;
import de.schmaeck.simulator.view.SimulatorPanel;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.ControlAPI;

public class SimulatorControllerAPI implements ComponentListener {

	HaSE editor;
	Field field;
	SimulatorPanel view;
	int state;
	long delay;
	Interpreter interpreter;

	public final static int WALLEDIT = 0;
	public final static int HAMSTEREDIT = 1;
	public final static int CORNEDIT = 2;

	public SimulatorControllerAPI(HaSE editor, Field field, SimulatorPanel view) {
		this.editor = editor;
		this.field = field;
		this.view = view;
		this.delay = 250;
		this.state = WALLEDIT;
		this.interpreter = new Interpreter(editor, this);
	}

	public void updateView(boolean rescale) {
		view.updateView(rescale);
	}

	public void updateTile(int row, int col) {
		view.updateTile(row, col);
	}

	public void buildNewView() {
		view.buildNewView();
	}

	public void setWallEdit() {
		this.state = WALLEDIT;
	}

	public void setHamsterEdit() {
		this.state = HAMSTEREDIT;
	}

	public void setCornEdit() {
		this.state = CORNEDIT;
	}

	JFileChooser fc = ControlAPI.fc;// new JFileChooser("./Programme"); // dibo

	public void openField() {
		try {
			FileFilter filter = new FieldFileFilter();
			fc.setFileFilter(filter);
			int returnVal = fc.showOpenDialog(editor.gui);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();

				field.loadFromFile(file.getAbsolutePath());
				buildNewView();

			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void saveAsField() {
		// Filename ermitteln
		// speichern
		try {
			FileFilter filter = new FieldFileFilter();
			fc.setFileFilter(filter);
			int returnVal = fc.showSaveDialog(this.editor.gui);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				String name = file.getAbsolutePath();
				if (!name.endsWith(".ter")) { // dibo
					name = name + ".ter";
				}
				this.field.setFileName(name);
				saveField();
			} else {
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void saveField() {
		try {
			if (field.getFileName() == null) {
				saveAsField();
			} else {
				field.saveToFile(field.getFileName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public int getState() {

		return this.state;
	}

	public void componentHidden(ComponentEvent arg0) {
	}

	public void componentMoved(ComponentEvent arg0) {
	}

	public void componentResized(ComponentEvent arg0) {
		// editor.viewAPI.setStatusText("Territorium wird neu skaliert ...");
		updateView(true);
	}

	public void componentShown(ComponentEvent arg0) {
	}

	public void setState(int state) {
		this.state = state;
	}

	public long getDelay() {
		return this.delay;
	}

	public void setDelay(long delay) {
		this.delay = delay;
	}

	public void step() {
		if (this.interpreter.runningProg) {
			this.interpreter.step();
		} else {
			if (this.interpreter.init())
				this.interpreter.step();
		}
	}

	public void play() {
		this.interpreter.play();
	}

	public void pause() {
		this.interpreter.pause();
	}

	public void stop() {
		this.interpreter.stopPlay();
	}

}
