package de.schmaeck.simulator.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.schmaeck.struktogrammeditor.HaSE;

public class SimulatorActionListener implements ActionListener {

  HaSE editor;
  int type;
  SimulatorControllerAPI controller;
  
  public static final int OPEN = 0;
  public static final int SAVE = 1;
  public static final int SAVEAS = 2;
  
  public SimulatorActionListener(HaSE editor, SimulatorControllerAPI controller, int type) {
    this.editor = editor;
    this.controller = controller;
    this.type = type;
  }
  
  public void actionPerformed (ActionEvent arg0) {
    switch (type) {
      case OPEN: {
        controller.openField();
        break;
      }
      case SAVE: {
        controller.saveField();
        break;
      }
      case SAVEAS: {
        controller.saveAsField();
        break;
      }
    }
    
  }

}
