package de.schmaeck.simulator.controller;

import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class ProgramFlowPosition implements InterpreterStep {
  
  public ArrayList<StructureElement> sel;
  public int index;
  
  public ProgramFlowPosition(ArrayList<StructureElement> sel, int index) {
    this.sel = sel;
    this.index = index;
  }
  
  public StructureElement getSE() {
    if (index < sel.size()) return sel.get(index);
    return null;
  }
  
  public StructureElement getLastSE() {
    if (index-1 < sel.size()) return sel.get(index-1);
    return null;
  }
  
  public boolean hasMoreSE() {
    return (index < sel.size());
  }
  
  public void nextSE() {
    index++;
  }

  public int getType () {
    return INSTRUCTION;
  }

  public void decreaseIndex () {
    index--;
  }

}
