package de.schmaeck.simulator.controller;

import java.util.ArrayList;

import javax.swing.SwingUtilities;

import de.schmaeck.simulator.exceptions.GibException;
import de.schmaeck.simulator.exceptions.NimmException;
import de.schmaeck.simulator.exceptions.VorException;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementBlock;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementDoWhile;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementIf;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementWhile;
import de.schmaeck.struktogrammeditor.view.dialog.InfoPopupDialog;

public class Interpreter {

	final private static int PROGEND = 0;
	final private static int PROGVOREXCEPTION = 1;
	final private static int PROGGIBEXCEPTION = 2;
	final private static int PROGNIMMEXCEPTION = 3;

	HaSE editor;

	SimulatorControllerAPI controller;

	boolean runningProg;

	InterpreterThread thread;

	// sequenzen und position, jngste zuerst.
	ArrayList<InterpreterStep> nextStep;

	// aktive Schleifen, jngste zuerst. fr break/continue
	ArrayList<StructureElement> activeLoopMemory;

	// bei boolschen Methoden fr den rckgabewert.
	private boolean lastBooleanValue;

	private ProgramModel prog;

	private StructureElement lastSE;

	public Interpreter(HaSE editor, SimulatorControllerAPI controller) {
		this.editor = editor;
		this.controller = controller;
		this.runningProg = false;
		this.lastBooleanValue = false;
		this.lastSE = null;
		this.thread = new InterpreterThread(this);
	}

	// true falls erfolgreich
	public boolean init() {
		try {
			this.prog = editor.viewAPI.getSelectedProgramView().getProg();
			this.nextStep = new ArrayList<InterpreterStep>();
			// die erste methode ist die main-Methode
			this.nextStep.add(new ProgramFlowPosition(prog.getMethod(0)
					.getSel(), 0));
			this.activeLoopMemory = new ArrayList<StructureElement>();
		} catch (Exception ex) {
			this.runningProg = false;
			return false;
		}
		this.runningProg = true;
		return true;
	}

	public void step() {
		if (!runningProg)
			return;
		try {
			// Es gibt NICHTS mehr zu tun -> fertig
			if (this.nextStep.size() == 0) {
				this.stopPlay();
				this.genInfoPopupDialog(PROGEND);
				return;
			}

			// === Instruction ====
			if (this.nextStep.get(0).getType() == InterpreterStep.INSTRUCTION) {
				StructureElement se = ((ProgramFlowPosition) this.nextStep
						.get(0)).getSE();
				if (se == null) {
					this.nextStep.remove(0);
					step();
					return;
				} else {
					((ProgramFlowPosition) this.nextStep.get(0)).nextSE();
					executeSE(se);
				}

				// === Call-Ende ====
			} else if (this.nextStep.get(0).getType() == InterpreterStep.METHODCALLSTEP) {
				this.nextStep.remove(0);
				step();

				// === Loop-Blockende ====
			} else if (this.nextStep.get(0).getType() == InterpreterStep.LOOPSTEP) {
				this.nextStep.remove(0);
				step();

				// === Condition ====
			} else if (this.nextStep.get(0).getType() == InterpreterStep.CONDITION) {
				ProgramFlowPosition pfp = ((ConditionToDoFlowPosition) this.nextStep
						.get(0)).getPFPosition();
				((ConditionToDoFlowPosition) this.nextStep.get(0)).next();
				// das zuletzt berechnet Boolean-Ergebnis merken
				((ConditionToDoFlowPosition) this.nextStep.get(0))
						.addResult(this.lastBooleanValue);
				if (pfp == null) {
					ConditionToDoFlowPosition ctdfp = (ConditionToDoFlowPosition) this.nextStep
							.remove(0);
					if (this.nextStep.get(0).getType() == InterpreterStep.INSTRUCTION) {
						StructureElement se = ((ProgramFlowPosition) this.nextStep
								.get(0)).getLastSE();
						this.lastBooleanValue = executePart2SE(se, ctdfp);
					} else {
						// es ist ein doWhile-Marker dazwischen.
						StructureElement se = ((ProgramFlowPosition) this.nextStep
								.get(1)).getLastSE();
						this.lastBooleanValue = executePart2SE(se, ctdfp);
					}
				} else {
					this.nextStep.add(0, new MethodCallMarker(true));
					this.nextStep.add(0, pfp);
				}

			} else if (this.nextStep.get(0).getType() == InterpreterStep.DOWHILESTEP) {
				StructureElementDoWhile seb = (StructureElementDoWhile) ((ProgramFlowPosition) this.nextStep
						.get(1)).getLastSE();
				Condition c = seb.getCondition();
				this.analyseConditionStepOne(c);
			}
		} catch (Exception ex) {
			this.stopPlay();
		}
		// this.controller.updateView(false);
		this.editor.viewAPI.markStructureElementMethodAsChanged();
	}

	// true, falls eine boolsche Methode true liefert
	// false, sonst
	private boolean executeSE(StructureElement se) {
		if (se == null)
			return false;
		if (this.lastSE != null)
			this.lastSE.setIsActive(false);
		this.lastSE = se;
		this.lastSE.setIsActive(true);
		try {
			switch (se.getStructureTyp()) {
			case StructureElement.BLOCK: {
				StructureElementBlock seb = (StructureElementBlock) se;

				// UpdateView-Code
				int lastRow = controller.field.hamster.getRow();
				int lastCol = controller.field.hamster.getCol();

				if (seb.toString().equals("vor();"))
					controller.field.hamster.vor();
				else if (seb.toString().equals("linksUm();"))
					controller.field.hamster.linksUm();
				else if (seb.toString().equals("nimm();"))
					controller.field.hamster.nimm();
				else if (seb.toString().equals("gib();"))
					controller.field.hamster.gib();

				// UpdateView-Code
				this.controller.updateTile(lastRow, lastCol);
				this.controller.updateTile(controller.field.hamster.getRow(),
						controller.field.hamster.getCol());

				break;
			}
			case StructureElement.SUBROUTINE: {
				StructureElementBlock seb = (StructureElementBlock) se;
				this.nextStep.add(0, new MethodCallMarker(false));
				String cs = (seb.toString().endsWith("();")) ? seb.toString()
						.substring(0, seb.toString().length() - 3) : seb
						.toString();

				for (int i = 0; i < prog.getMethodList().size(); i++) {
					if (prog.getMethod(i).getName().equals(cs)) {
						this.nextStep.add(0, new ProgramFlowPosition(prog
								.getMethod(i).getSel(), 0));
						break;
					}
				}
				break;
			}

			case StructureElement.RETURNBLOCK: {
				StructureElementBlock seb = (StructureElementBlock) se;
				// return mit oder ohne boolean-Value?
				boolean isBoolean = false;
				for (int i = 0; i < this.nextStep.size(); i++) {
					if (this.nextStep.get(i).getType() == InterpreterStep.METHODCALLSTEP) {
						MethodCallMarker mcm = (MethodCallMarker) this.nextStep
								.get(i);
						isBoolean = mcm.isBoolean();
						break;
					}
				}

				if (isBoolean) {
					Condition c = seb.getCondition();
					// Condition zerlegen und als todo-liste vormerken
					this.analyseConditionStepOne(c);
					break;
				} else {
					// alle nextStep-Listen lschen, bis der jngste
					// MethodenMarker gefunden
					while (this.nextStep.get(0).getType() != InterpreterStep.METHODCALLSTEP) {
						this.nextStep.remove(0);
					}
					break;
				}
			}

			case StructureElement.CONTINUEBLOCK: {
				StructureElementBlock seb = (StructureElementBlock) se;

				while (this.nextStep.get(0).getType() != InterpreterStep.LOOPSTEP) {
					this.nextStep.remove(0);
				}
				break;
			}

			case StructureElement.BREAKBLOCK: {
				StructureElementBlock seb = (StructureElementBlock) se;

				while (this.nextStep.get(0).getType() != InterpreterStep.LOOPSTEP) {
					this.nextStep.remove(0);
				}
				if (((LoopMarker) this.nextStep.get(0)).isWhileLoop()) {
					this.nextStep.remove(0);
					((ProgramFlowPosition) this.nextStep.get(0)).nextSE();
				}
				break;
			}

			case StructureElement.IFBLOCK: {
				StructureElementIf seb = (StructureElementIf) se;
				Condition c = seb.getCondition();
				// Condition zerlegen und als todo-liste vormerken
				this.analyseConditionStepOne(c);
				break;
			}
			case StructureElement.WHILELOOP: {
				StructureElementWhile seb = (StructureElementWhile) se;
				Condition c = seb.getCondition();
				// Condition zerlegen und als todo-liste vormerken
				this.analyseConditionStepOne(c);
				break;
			}
			case StructureElement.DOWHILELOOP: {
				StructureElementDoWhile seb = (StructureElementDoWhile) se;
				this.nextStep.add(0, new DoWhileMarker());
				this.nextStep.add(0, new LoopMarker(false));
				this.nextStep.add(0, new ProgramFlowPosition(seb.getLoopList(),
						0));
				break;
			}
			}
		} catch (VorException ve) {
			stopPlay();
			this.genInfoPopupDialog(PROGVOREXCEPTION);
			System.out.println("VOR-EXCEPTION");
		} catch (NimmException ne) {
			stopPlay();
			this.genInfoPopupDialog(PROGNIMMEXCEPTION);
			System.out.println("NIMM-EXCEPTION");
		} catch (GibException ge) {
			stopPlay();
			this.genInfoPopupDialog(PROGGIBEXCEPTION);
			System.out.println("GIB-EXCEPTION");
		}

		return false;
	}

	// Zweite Ausfhrung von Condition-SEs
	private boolean executePart2SE(StructureElement se,
			ConditionToDoFlowPosition ctdfp) {
		if (se == null)
			return false;

		switch (se.getStructureTyp()) {
		case StructureElement.RETURNBLOCK: {
			StructureElementBlock seb = (StructureElementBlock) se;
			Condition c = seb.getCondition();

			// alle nextStep-Listen lschen, bis der jngste MethodenMarker
			// gefunden
			while (this.nextStep.get(0).getType() != InterpreterStep.METHODCALLSTEP) {
				this.nextStep.remove(0);
			}

			return this.analyseConditionStepTwo(c, ctdfp);
		}
		case StructureElement.IFBLOCK: {
			StructureElementIf seb = (StructureElementIf) se;
			Condition c = seb.getCondition();
			if (this.analyseConditionStepTwo(c, ctdfp)) {
				this.nextStep.add(0, new ProgramFlowPosition(seb.getTrueList(),
						0));
			} else {
				this.nextStep.add(0, new ProgramFlowPosition(
						seb.getFalseList(), 0));
			}
			break;
		}
		case StructureElement.WHILELOOP: {
			StructureElementWhile seb = (StructureElementWhile) se;
			Condition c = seb.getCondition();
			if (this.analyseConditionStepTwo(c, ctdfp)) {
				((ProgramFlowPosition) this.nextStep.get(0)).decreaseIndex();
				this.nextStep.add(0, new LoopMarker(true));
				this.nextStep.add(0, new ProgramFlowPosition(seb.getLoopList(),
						0));
			}
			break;
		}
		case StructureElement.DOWHILELOOP: {
			StructureElementDoWhile seb = (StructureElementDoWhile) se;
			Condition c = seb.getCondition();
			if (this.analyseConditionStepTwo(c, ctdfp)) {
				this.nextStep.add(0, new ProgramFlowPosition(seb.getLoopList(),
						0));
			} else {
				this.nextStep.remove(0);
			}
			break;
		}
		}

		return false;
	}

	private boolean analyseConditionStepTwo(Condition c,
			ConditionToDoFlowPosition ctdfp) {
		if (!c.isAtomic()) {
			boolean a = analyseConditionStepTwo(c.getA(), ctdfp);
			boolean b = false;
			if (!c.getComposition().isSingleValue()) {
				b = analyseConditionStepTwo(c.getB(), ctdfp);
			}
			switch (c.getComposition().getIndex()) {
			case 0: // nicht
				return !a;
			case 1: // und
				return a && b;
			case 2: // oder
				return a || b;
			case 3: // xor / ungleich
				return a != b;
			case 4: // quivalent / gleich
				return a == b;
			}
		} else {
			String cs = (c.getText().endsWith("()")) ? c.getText().substring(0,
					c.getText().length() - 2) : c.getText();
			if (cs.equals("true")) {
				return true;
			} else if (cs.equals("false")) {
				return false;
			} else if (cs.equals("maulLeer")) {
				return controller.field.hamster.maulLeer();
			} else if (cs.equals("vornFrei")) {
				return controller.field.hamster.vornFrei();
			} else if (cs.equals("kornDa")) {
				return controller.field.hamster.kornDa();
			} else {
				return ctdfp.getNextBoolean();
			}
		}
		return false;
	}

	private void analyseConditionStepOne(Condition c) {
		ArrayList<ProgramFlowPosition> callList = buildConditionToDoList(
				new ArrayList<ProgramFlowPosition>(), c);
		this.nextStep.add(0, new ConditionToDoFlowPosition(callList, 0));
		step(); // TODO: Optional weglassen...
	}

	private ArrayList<ProgramFlowPosition> buildConditionToDoList(
			ArrayList<ProgramFlowPosition> callList, Condition c) {
		if (!c.isAtomic()) {
			callList = buildConditionToDoList(callList, c.getA());
			if (!c.getComposition().isSingleValue()) {
				callList = buildConditionToDoList(callList, c.getB());
			}
		} else {
			String cs = (c.getText().endsWith("()")) ? c.getText().substring(0,
					c.getText().length() - 2) : c.getText();
			if (cs.equals("true")) {
			} else if (cs.equals("false")) {
			} else if (cs.equals("maulLeer")) {
			} else if (cs.equals("vornFrei")) {
			} else if (cs.equals("kornDa")) {
			} else {
				for (int i = 0; i < prog.getMethodList().size(); i++) {
					if (prog.getMethod(i).getType().equals("boolean")) {
						if (prog.getMethod(i).getName().equals(cs)) {
							// boolMethode gefunden
							callList.add(new ProgramFlowPosition(prog
									.getMethod(i).getSel(), 0));
							break;
						}
					}
				}

			}
		}
		return callList;
	}

	public void play() {
		this.thread.kill();
		if (this.runningProg) {
			this.thread = new InterpreterThread(this);
			this.thread.start();
		} else {
			if (init()) {
				this.thread = new InterpreterThread(this);
				this.thread.start();
			}
		}
	}

	public void pause() {
		this.thread.kill();
	}

	public void stopPlay() {
		if (this.lastSE != null)
			this.lastSE.setIsActive(false);
		this.lastSE = null;
		this.runningProg = false;
		this.thread.kill();
	}

	public void waitDelayTime() {
		try {
			double speed = controller.getDelay();
			if (speed <= 0) {
				speed = 0.5;
			}
			long value = (int) ((-Math.log(speed) + Math.log(100)) * 80);
			Thread.sleep(value);
		} catch (Exception ex) {
		}
	}

	private void genInfoPopupDialog(int dialogType) {
		// TODO: Textparameter durch Language ersetzten
		switch (dialogType) {
		case (PROGEND): {
			new InfoPopupDialog(
					editor.gui,
					editor,
					"Hamsterprogramm erfolgreich beendet!",
					"<html>Herzlichen Glckwunsch,<br> "
							+ "der Hamster hat das Hamsterprogramm erfolgreich beendet.<br>"
							+ " :-)</html>",
					this.editor.environment.hamster2bOrNot2b);
			break;
		}
		case (PROGVOREXCEPTION): {
			new InfoPopupDialog(editor.gui, editor,
					"Autsch! Hamster luft gegen Mauer.", "<html>Fehler: <br>"
							+ "Hamster luft gegen eine Mauer!<br>"
							+ " :-(</html>",
					this.editor.environment.hamster2bOrNot2b);
			break;
		}
		case (PROGNIMMEXCEPTION): {
			new InfoPopupDialog(
					editor.gui,
					editor,
					"Autsch! Hamster greift ins Leere.",
					"Fehler: Hamster versucht ein Korn aufzunehmen, das nicht da ist. :-(",
					this.editor.environment.hamster2bOrNot2b);
			break;
		}
		case (PROGGIBEXCEPTION): {
			new InfoPopupDialog(
					editor.gui,
					editor,
					"Autsch! Hamster hat keine Krner zu geben.",
					"Fehler: Hamster versucht ein Korn abzulegen, obwohl er keine Krner im Maul hat. :-(",
					this.editor.environment.hamster2bOrNot2b);
			break;
		}
		}
	}

}

class InterpreterThread extends Thread {

	private boolean isAlife;

	private Interpreter interpreter;

	public InterpreterThread(Interpreter interpreter) {
		this.isAlife = true;
		this.interpreter = interpreter;
	}

	public void kill() {
		this.isAlife = false;
	}

	public boolean isAlife() {
		return isAlife;
	}

	public void run() {
		while (this.isAlife) {
			try {
				SwingUtilities.invokeAndWait(new Runnable() {

					public void run() {
						interpreter.step();
					}
				});
				interpreter.waitDelayTime();
			} catch (Exception ex) {
				this.isAlife = false;
			}
		}
	}

}
