//Befehle

Blockly.Blocks['forward'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("vor");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(260);
        this.setTooltip("eine Stelle in Blickrichtung gehen");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['left'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("drehe_links");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(260);
        this.setTooltip("sich um 90° nach links drehen");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['put'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("gib_ab");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(260);
        this.setTooltip("einen Gegenstand ablegen");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['take'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("nimm_auf");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(260);
        this.setTooltip("einen Gegenstand aufnehmen");
        this.setHelpUrl("");
    }
};

//Test-Befehle

Blockly.Blocks['noWallFront'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("vorne_frei");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn vor Niki keine Wand ist");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['noWallRight'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("rechts_frei");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn rechts von Niki keine Wand ist");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['noWallLeft'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("links_frei");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn links von Niki kein Wand ist");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['onItem'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("Platz_belegt");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn ein Gegenstand auf dem Feld liegt");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['hasItem'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("hat_Vorrat");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn Niki mindestens einen Gegenstand trägt");
        this.setHelpUrl("");
    }
};
Blockly.Blocks['facingNorth'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("nordwärts");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn Niki in Richtung Norden blickt");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['facingSouth'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("südwärts");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn Niki in Richtung Süden blickt");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['facingWest'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("westwärts");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn Niki in Richtung Westen blickt");
        this.setHelpUrl("");
    }
};

Blockly.Blocks['facingEast'] = {
    init: function() {
        this.appendDummyInput()
            .setAlign(Blockly.ALIGN_CENTRE)
            .appendField("ostwärts");
        this.setOutput(true, null);
        this.setColour(330);
        this.setTooltip("Wahr, wenn Niki in Richtung Osten blickt");
        this.setHelpUrl("");
    }
};

//Generator stub : Befehle

Blockly.JavaScript['forward'] = function(block) {
    var code = 'move();\n';
    return code;
};
Blockly.JavaScript['left'] = function(block) {

    var code = 'turnLeft();\n';
    return code;
};
Blockly.JavaScript['put'] = function(block) {
    var code = 'putItem();\n';
    return code;
};
Blockly.JavaScript['take'] = function(block) {
    var code = 'takeItem();\n';
    return code;
};

//Generator stub : Test-Befehle

Blockly.JavaScript['noWallFront'] = function(block) {
    var code = 'noWallFront()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['noWallRight'] = function(block) {
    var code = 'noWallRight()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['noWallLeft'] = function(block) {
    var code = 'noWallLeft()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['onItem'] = function(block) {
    var code = 'onItem()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['hasItem'] = function(block) {
    var code = 'hasItem()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['facingNorth'] = function(block) {
    var code = 'facingNorth()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['facingSouth'] = function(block) {
    var code = 'facingSouth()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['facingWest'] = function(block) {
    var code = 'facingWest()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};
Blockly.JavaScript['facingEast'] = function(block) {
    var code = 'facingEast()';
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};

//Interpreter

function initApi(interpreter, scope) {

    var wrapperTurnLeft = function(text) {
        text = text ? text.toString() : '';
        return turnLeft();
    };
    interpreter.setProperty(scope, 'turnLeft', interpreter.createNativeFunction(wrapperTurnLeft));

    var wrapperMove = function(text) {
        text = text ? text.toString() : '';
        return move();
    };
    interpreter.setProperty(scope, 'move', interpreter.createNativeFunction(wrapperMove));

    var wrapperTakeItem = function(text) {
        text = text ? text.toString() : '';
        return takeItem();
    };
    interpreter.setProperty(scope, 'takeItem', interpreter.createNativeFunction(wrapperTakeItem));

    var wrapperPutItem = function(text) {
        text = text ? text.toString() : '';
        return putItem();
    };
    interpreter.setProperty(scope, 'putItem', interpreter.createNativeFunction(wrapperPutItem));

    var wrapperNoWallFront = function(text) {
        text = text ? text.toString() : '';
        return noWallFront();
    };
    interpreter.setProperty(scope, 'noWallFront', interpreter.createNativeFunction(wrapperNoWallFront));

    var wrapperNoWallRight = function(text) {
        text = text ? text.toString() : '';
        return noWallRight();
    };
    interpreter.setProperty(scope, 'noWallRight', interpreter.createNativeFunction(wrapperNoWallRight));

    var wrapperNoWallLeft = function(text) {
        text = text ? text.toString() : '';
        return noWallLeft();
    };
    interpreter.setProperty(scope, 'noWallLeft', interpreter.createNativeFunction(wrapperNoWallLeft));

    var wrapperOnItem = function(text) {
        text = text ? text.toString() : '';
        return onItem();
    };
    interpreter.setProperty(scope, 'onItem', interpreter.createNativeFunction(wrapperOnItem));

    var wrapperHasItem = function(text) {
        text = text ? text.toString() : '';
        return hasItem();
    };
    interpreter.setProperty(scope, 'hasItem', interpreter.createNativeFunction(wrapperHasItem));

    var wrapperFacingNorth = function(text) {
        text = text ? text.toString() : '';
        return facingNorth();
    };
    interpreter.setProperty(scope, 'facingNorth', interpreter.createNativeFunction(wrapperFacingNorth));

    var wrapperFacingSouth = function(text) {
        text = text ? text.toString() : '';
        return facingSouth();
    };
    interpreter.setProperty(scope, 'facingSouth', interpreter.createNativeFunction(wrapperFacingSouth));

    var wrapperFacingWest = function(text) {
        text = text ? text.toString() : '';
        return facingWest();
    };
    interpreter.setProperty(scope, 'facingWest', interpreter.createNativeFunction(wrapperFacingWest));

    var wrapperFacingEast = function(text) {
        text = text ? text.toString() : '';
        return facingEast();
    };
    interpreter.setProperty(scope, 'facingEast', interpreter.createNativeFunction(wrapperFacingEast));
} 