function turnLeft() {
    if ("south" == actorDirection) {
        actorDirection = "east";
        actorImageSrc = "./images/niki_right.png";
    } else if ("east" == actorDirection) {
        actorDirection = "north";
        actorImageSrc = "./images/niki_top.png";
    } else if ("north" == actorDirection) {
        actorDirection = "west";
        actorImageSrc = "./images/niki_left.png";
    } else {
        actorDirection = "south";
        actorImageSrc = "./images/niki_bottom.png";
    }
    drawBasicTerritory();
    drawTerritoryContent();
    actorImage.src = actorImageSrc;
}

function move() {
    if (noWallFront()) {
        territoryContent[actorRow][actorColumn].setActor(false);
        if ("south" == actorDirection) {
            actorRow = (actorRow + 1) % row;
            currentY = actorRow * cellHeight + 25;
        } else if ("east" == actorDirection) {
            actorColumn = (actorColumn + 1) % column;
            currentX = actorColumn * cellWidth + 30;
        } else if ("north" == actorDirection) {
            actorRow = (actorRow + row - 1) % row;
            currentY = actorRow * cellHeight + 25;
        } else {
            actorColumn = (actorColumn + column - 1) % column;
            currentX = actorColumn * cellWidth + 30;
        }
        territoryContent[actorRow][actorColumn].setActor(true);
        drawBasicTerritory();
        drawTerritoryContent();
        drawActor();
    } else {
        window.alert("Niki kann nicht gegen eine Wand laufen.");
        stopCode();
    }
}

function takeItem() {
    /*
    if (nikiItems == 9) {
        window.alert("Niki kann nicht mehr als neun Gegenstände haben!");
        stopCode();
    } else 
    */
    if (onItem()) {
        nikiItems++;
        document.getElementById("number").value = nikiItems;
        territoryContent[actorRow][actorColumn].decrementItem();
        drawBasicTerritory();
        drawTerritoryContent();
        drawActor();
    } else {
        window.alert("Auf diesem Feld liegt kein Gegenstand.");
        stopCode();
    }
}

function putItem() {
    if (nikiItems == 0) {
        window.alert("Niki hat keine Gegenstände zum Ablegen.");
        stopCode();
    } else {
        currentDraggableToCanvas = "itemImage";
        var x = cellWidth * actorColumn + (cellWidth / 2);
        var y = cellHeight * actorRow + (cellHeight / 2);
        var position = [x, y];
        setCellContent(actorRow, actorColumn, position, [0, 0]);
        nikiItems--;
        document.getElementById("number").value = nikiItems;
    }
}

function onItem() {
    return territoryContent[actorRow][actorColumn].getItem();
}

function itemAmount() {
    return territoryContent[actorRow][actorColumn].getItemAmount();
}

function hasItem() {
    if (nikiItems > 0) {
        return true;
    } else {
        return false;
    }
}

/*
function noWallFront() {
    var result = true;
    if ("south" == actorDirection && actorRow + 1 < row) {
        result = (territoryContent[actorRow][actorColumn].getSouthWall() || territoryContent[actorRow + 1][actorColumn].getNorthWall());
    } else if ("east" == actorDirection && actorColumn + 1 < column) {
        result = (territoryContent[actorRow][actorColumn].getEastWall() || territoryContent[actorRow][actorColumn + 1].getWestWall());
    } else if ("north" == actorDirection && actorRow > 0) {
        result = (territoryContent[actorRow][actorColumn].getNorthWall() || territoryContent[actorRow - 1][actorColumn].getSouthWall());
    } else if ("west" == actorDirection && actorColumn > 0) {
        result = territoryContent[actorRow][actorColumn].getWestWall() || territoryContent[actorRow][actorColumn - 1].getEastWall();
    }
    console.log("result noWallFront: ", !result);
    return !result;
}

function noWallLeft() {
    var result = false;
    if ("west" == actorDirection && actorRow + 1 < row) {
        result = (territoryContent[actorRow][actorColumn].getSouthWall() || territoryContent[actorRow + 1][actorColumn].getNorthWall());
        console.log("südliche wand: " + territoryContent[actorRow][actorColumn].getSouthWall() + " nördliche wand: " + territoryContent[actorRow + 1][actorColumn].getNorthWall())
    } else if ("south" == actorDirection) {
        result = territoryContent[actorRow][actorColumn].getEastWall();
    } else if ("east" == actorDirection) {
        result = territoryContent[(actorRow + row) % row][actorColumn].getNorthWall();
    } else {
        result = territoryContent[actorRow][(actorColumn + column) % column].getWestWall();
    }
    console.log("result: ", result);
    return !result;
}

function noWallRight() {
    var result = false;
    if ("east" == actorDirection) {
        result = territoryContent[actorRow % row][actorColumn].getSouthWall();
    } else if ("north" == actorDirection) {
        result = territoryContent[actorRow][(actorColumn) % column].getEastWall();
    } else if ("west" == actorDirection) {
        result = territoryContent[(actorRow + row) % row][actorColumn].getNorthWall();
    } else {
        result = territoryContent[actorRow][(actorColumn + column) % column].getWestWall();
    }
    console.log("result: ", result);
    return result;
}
*/
function noWallFront() {
    if ("south" == actorDirection) {
        return actorRow + 1 < row && !territoryContent[actorRow][actorColumn].getSouthWall();
    } else if ("east" == actorDirection) {
        return actorColumn + 1 < column && !territoryContent[actorRow][actorColumn].getEastWall();
    } else if ("north" == actorDirection) {
        return actorRow > 0 && !territoryContent[actorRow][actorColumn].getNorthWall();
    } else if ("west" == actorDirection) {
        return actorColumn > 0 && !territoryContent[actorRow][actorColumn].getWestWall();
    }
    return false;
}

function noWallLeft() {
    if ("west" == actorDirection) {
        return actorRow + 1 < row && !territoryContent[actorRow][actorColumn].getSouthWall();
    } else if ("south" == actorDirection) {
        return actorColumn + 1 < column && !territoryContent[actorRow][actorColumn].getEastWall();
    } else if ("east" == actorDirection) {
        return actorRow > 0 && !territoryContent[actorRow][actorColumn].getNorthWall();
    } else if ("north" == actorDirection) {
        return actorColumn > 0 && !territoryContent[actorRow][actorColumn].getWestWall();
    }
    return false;
}

function noWallRight() {
    if ("east" == actorDirection) {
        return actorRow + 1 < row && !territoryContent[actorRow][actorColumn].getSouthWall();
    } else if ("north" == actorDirection) {
        return actorColumn + 1 < column && !territoryContent[actorRow][actorColumn].getEastWall();
    } else if ("west" == actorDirection) {
        return actorRow > 0 && !territoryContent[actorRow][actorColumn].getNorthWall();
    } else if ("south" == actorDirection) {
        return actorColumn > 0 && !territoryContent[actorRow][actorColumn].getWestWall();
    }
    return false;
}

function facingNorth() {
    var result = false;
    if ("north" == actorDirection) {
        result = true;
    }
    console.log("result: ", result);
    return result;
}

function facingSouth() {
    var result = false;
    if ("south" == actorDirection) {
        result = true;
    }
    console.log("result: ", result);
    return result;
}

function facingWest() {
    var result = false;
    if ("west" == actorDirection) {
        result = true;
    }
    console.log("result: ", result);
    return result;
}

function facingEast() {
    var result = false;
    if ("east" == actorDirection) {
        result = true;
    }
    console.log("result: ", result);
    return result;
}
