class CellContent {

    constructor() {
        this.actor = false;
        this.northWall = false;
        this.southWall = false;
        this.westWall = false;
        this.eastWall = false;
        this.item = false;
        this.itemAmount = 0;

    }
    getActor() {
        return this.actor;
    }
    getNorthWall() {
        return this.northWall;
    }
    getSouthWall(){
        return this.southWall;
    }
    getWestWall() {
        return this.westWall;
    }
    getEastWall() {
        return this.eastWall;
    }
    getWall() {
        return (this.northWall || this.southWall || this.westWall || this.eastWall)
    }
    getItem() {
        return this.item;
    }
    getItemAmount() {
        return this.itemAmount;
    }
    setActor(a) {
        this.actor = a;
    }
    setNorthWall(n) {
        this.northWall = n;
    }
    setSouthWall(s) {
        this.southWall = s;
    }
    setWestWall(w) {
        this.westWall = w;
    }
    setEastWall(e) {
        this.eastWall = e;
    }
    setWall(w) {
        this.northWall = w;
        this.southWall = w;
        this.westWall = w;
        this.eastWall = w;
    }
    setItem(i) {
        this.item = i;
    }
    setItemAmount(i) {
        if (i >= 0) {
            this.itemAmount = i;
            if (i > 0) {
                this.item = true;
            } else {
                this.item = false;
            }
        }
    }
    incrementItem() {
        this.itemAmount++;
        if (this.itemAmount > 0) {
            this.item = true;
        }
    }
    decrementItem() {
        if (this.itemAmount > 0) {
            this.itemAmount--;
        }
        if (this.itemAmount == 0) {
            this.item = false;
        }
    }
    isEmpty() {
        if (this.actor == false && this.getWall() == false && this.item == false) {
            return true;
        } else {
            return false;
        }
    }
}