package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;

import model.Play;
import util.ResourceManager;
import view.PlayFrame;
import debugger.SolistDebugger;
import editor.SolistEditor;

public class DebuggerListener implements ActionListener {

	private static JToggleButton button;
	private static JCheckBoxMenuItem item;

	public DebuggerListener(JToggleButton b) {
		button = b;
	}

	public DebuggerListener(JCheckBoxMenuItem i) {
		item = i;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button) {
			SolistEditor.getSolistEditor().getEditorPanel()
					.removeLineHighlight();
			if (button.isSelected()) {
				item.setSelected(true);
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOff"));
				PlayFrame frame = Play.getPlay().getPlayFrame();
				frame.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOn"));
			} else {
				item.setSelected(false);
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOn"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOff"));
			}
		} else {
			button.setSelected(!button.isSelected());
			if (button.isSelected()) {
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOff"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOn"));
			} else {
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOn"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOff"));
			}
		}
		SolistDebugger.getSolistDebugger().setTracing(button.isSelected());
	}

}
