package theater;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Eine Actor- oder Prop-Methode, die als Invisible deklariert ist, wird nicht
 * im Popup-Menu der Komponente und auch nicht im Befehlsfenster angezeigt.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (03.11.2009)
 */
@Documented
@Target( { ElementType.METHOD, ElementType.CONSTRUCTOR })
@Retention(RetentionPolicy.RUNTIME)
public @interface Invisible {

}
