package scratch;

import model.Play;

/**
 * Reprsentation des Standard-Hamsters als Scratch-Hamster
 * 
 * @author dibo
 * 
 */
public class ScratchSolist { // extends Hamster {

	public static ScratchSolist hamster = new ScratchSolist();

	public static ScratchSolist getScratchSolist() {
		return hamster;
	}

	/**
	 * Wird beim Start des Hamster-Simulators einmal aufgerufen, wenn das
	 * Property sratch gesetzt ist. Hier koennen generelle Initialisierungen
	 * vorgenommen werden
	 * 
	 * @return true, wenn die Initialisierung erfolgreich war; false, sonst
	 */
	public static boolean initScratch() {
		return true;
	}

	private ScratchProgram program = null;

	private ScratchSolist() {
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer den Start-Button klickt
	 * 
	 * @param file
	 *            die auszufhrende Datei/Programm
	 */
	public void startProgram(ScratchProgram p) {
		if (program == null) {
			program = new ScratchProgram(p);
			// dibo
			// Hamster._re_init();
			// program = new ScratchProgram();
			// program.setProgram(file.getProgram().getProgram());
			// program.setRefreshHandler(file.getProgram().getRefreshHandler());
			// program.setNextMethodHandler(file.getProgram().getNextMethodHandler());
			// program.setFile(file);
			program.start();
		}
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer den Stop-Button klickt
	 */
	@SuppressWarnings("deprecation")
	public void stopProgram() {
		ScratchProgram hProgram = program;
		if (hProgram != null) {
			hProgram.stopProgram();
			try {
				hProgram.join(2000);
			} catch (InterruptedException exc) {
			}
			if (hProgram.isAlive()) {
				hProgram.stop();
				try {
					hProgram.join();
				} catch (InterruptedException e) {
				}
			}
		}
		program = null;
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer den Pause-Button klickt
	 */
	public void pauseProgram() {
		if (program != null) {
			program.pauseProgram();
		}
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer whrend das Programm pausiert den
	 * Start-Button klickt
	 */
	public void resumeProgram() {
		if (program != null) {
			program.resumeProgram();
		}
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer den StepOver-Button klickt
	 */
	public void stepOver(ScratchProgram p) {
		if (program == null) { // Programm noch nicht gestarted
			program = new ScratchProgram(p);
			program.pauseProgram();
			program.start();
		} else {
			program.stepOver();
		}
	}

	/**
	 * Wird aufgerufen, wenn der Nutzer den StepInto-Button klickt
	 */
	public void stepInto(ScratchProgram p) {
		// in dieser Demo gibt es keine Prozeduren
		stepOver(p); // Dummy
	}

	void setProgramFinished() {
		program = null;
		ScratchProgram.setActive(null);
	}

}
