package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.JOptionPane;

import util.ResourceManager;
import editor.Editor;

/**
 * Listener zum Schlieen eines Editors. Ist der Inhalt noch nicht
 * abgespeichert, wird nachgefragt.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class CloseEditorListener implements ActionListener {

	protected Editor editor;

	public CloseEditorListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		this.closeEditor();
	}

	public void closeEditor() {
		if (!this.editor.isSaved()) {
			java.awt.Component parent = this.editor;
			int answer = JOptionPane.showConfirmDialog(parent, ResourceManager
					.getResourceManager().getValue("msg.editor.saverequest"),
					ResourceManager.getResourceManager()
							.getValue("msg.request"),
					JOptionPane.YES_NO_CANCEL_OPTION);
			if (answer == JOptionPane.YES_OPTION) {
				try {
					this.editor.save();
					this.editor.close();
					this.editor.getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.editor.filesaved"));
				} catch (IOException exc) {
					JOptionPane.showMessageDialog(parent, ResourceManager
							.getResourceManager().getValue(
									"msg.editor.saveerror"), ResourceManager
							.getResourceManager().getValue("msg.error"),
							JOptionPane.ERROR_MESSAGE);
				}
			} else if (answer == JOptionPane.NO_OPTION) {
				this.editor.setSaved();
				this.editor.setChanged(false);
				this.editor.close();
			} else {
				this.editor.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.editor.closeaborted"));
				this.editor.toFront();
			}
		} else {
			this.editor.close();
		}

	}

}
