package theater;

import model.Play;

/**
 * Die Klasse Cell reprsentiert eine Zelle der Bhne. Sie implementiert das
 * Interface PixelArea, so dass mit dieser Klasse Kollisionen von Zellen mit
 * anderen Gebieten der Bhne berprft werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (17.07.2009)
 * 
 */
public class Cell implements PixelArea {

	/**
	 * Reihe der Zelle
	 */
	protected int row;

	/**
	 * Spalte der Zelle
	 */
	protected int col;

	/**
	 * Konstruktor zum Initialisieren einer Zelle mit seiner Spalte und Reihe.
	 * 
	 * @param col
	 *            die Spalte der Zelle
	 * @param row
	 *            die Reihe der Zelle
	 */
	public Cell(int col, int row) {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			this.col = col;
			this.row = row;
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * berprft, ob der Punkt mit den als Parameter bergebenen Koordinaten
	 * innerhalb der aufgerufenen Zelle liegt.
	 * 
	 * @param x
	 *            x-Koordinate des Punktes
	 * @param y
	 *            y-Koordinate des Punktes
	 * @return genau dann true, wenn der Punkt mit den als Parameter bergebenen
	 *         Koordinaten innerhalb der aufgerufenen Zelle liegt
	 * 
	 * @see theater.PixelArea#contains(int, int)
	 */
	public boolean contains(int x, int y) {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return new Rectangle(Play.getPlay().getStagePanel()
					.getCellRectangle(row, col)).contains(x, y);
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * berprft, ob die aufgerufene Zelle innerhalb der als Parameter
	 * bergebenen PixelArea liegt.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene Zelle innerhalb der als
	 *         Parameter bergebenen PixelArea liegt
	 * 
	 * @see theater.PixelArea#isInside(theater.PixelArea)
	 */
	public boolean isInside(PixelArea area) {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return new Rectangle(Play.getPlay().getStagePanel()
					.getCellRectangle(row, col)).isInside(area);
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * berprft, ob die aufgerufene Zelle die als Parameter bergebene
	 * PixelArea schneidet.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene Zelle die als Parameter
	 *         bergebene PixelArea schneidet
	 * @see theater.PixelArea#intersects(theater.PixelArea)
	 */
	public boolean intersects(PixelArea area) {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return new Rectangle(Play.getPlay().getStagePanel()
					.getCellRectangle(row, col)).intersects(area);
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * Liefert die Spalte der Zelle.
	 * 
	 * @return die Spalte der Zelle
	 */
	public int getCol() {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return this.col;
		} finally {
			Performance.getPerformance().unlock();
		}
	}

	/**
	 * Liefert die Reihe der Zelle.
	 * 
	 * @return die Reihe der Zelle
	 */
	public int getRow() {
		Play.getPlay().getActivePerformance().checkStop();
		Performance.getPerformance().lock();
		try {
			return this.row;
		} finally {
			Performance.getPerformance().unlock();
		}
	}
}
