package theater;

import model.ActionButton;

/**
 * Oberklasse fr die Handler-Klassen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (03.11.2009)
 * 
 */
public abstract class ButtonHandler {

	private ActionButton button;

	public ButtonHandler() {
		this.button = null;
	}

	public void setActionButton(ActionButton b) {
		this.button = b;
	}

	protected String getTooltip() {
		return this.button.getDynTooltip();
	}

	protected void setTooltip(String tip) {
		this.button.setDynTooltip(tip);
	}

	protected String getIcon() {
		return this.button.getDynIconFilename();
	}

	protected void setIcon(String filename) {
		this.button.setDynIconFilename(filename);
	}

}
