package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import model.Play;
import scratch.ScratchFile;
import scratch.ScratchPanel;
import scratch.ScratchProgram;
import theater_intern.TheaterObservable;
import util.IO;
import util.PropertyManager;
import util.ResourceManager;
import editor.Editor;
import editor.SolistEditor;

public class LoadProgramListener implements ActionListener, Observer {

	JMenuItem item;
	JButton button;

	public LoadProgramListener(JMenuItem item, JButton button) {
		this.item = item;
		this.button = button;
		TheaterObservable.getObservable().addObserver(this);
	}

	public void actionPerformed(ActionEvent e) {
		Play play = Play.getPlay();

		if (!PropertyManager.getPropertyManager().isScratch()) {
			Editor editor = SolistEditor.getSolistEditor().getEditor();
			if (!editor.isSavedAs()) {
				int answer = JOptionPane.showConfirmDialog(Play.getPlay()
						.getPlayFrame(), ResourceManager.getResourceManager()
						.getValue("msg.savequestion2")
						+ "\n"
						+ ResourceManager.getResourceManager().getValue(
								"msg.savequestion"), ResourceManager
						.getResourceManager().getValue("msg.request"),
						JOptionPane.YES_NO_CANCEL_OPTION);
				if (answer == JOptionPane.YES_OPTION) {
					if (!SaveProgramListener.saveProgram()) {
						return;
					}
				} else if (answer == JOptionPane.CANCEL_OPTION) {
					return;
				}
			}
		} else {
			ScratchPanel scratchPanel = Play.getPlay().getPlayFrame()
					.getScratchPanel();
			if (scratchPanel.isModified()) {
				int answer = JOptionPane.showConfirmDialog(Play.getPlay()
						.getPlayFrame(), ResourceManager.getResourceManager()
						.getValue("msg.savequestion2")
						+ "\n"
						+ ResourceManager.getResourceManager().getValue(
								"msg.savequestion"), ResourceManager
						.getResourceManager().getValue("msg.request"),
						JOptionPane.YES_NO_CANCEL_OPTION);
				if (answer == JOptionPane.YES_OPTION) {
					if (!SaveProgramListener.saveProgram()) {
						return;
					}
				} else if (answer == JOptionPane.CANCEL_OPTION) {
					return;
				}
			}
		}

		JFileChooser chooser = SaveProgramListener.getFileChooser();
		int returnVal = chooser.showOpenDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				File from = chooser.getSelectedFile();
				if (!(play.isSimulator() && PropertyManager
						.getPropertyManager().isScratch())) {
					Editor editor = SolistEditor.getSolistEditor().getEditor();
					File to = new File(play.getDirectory() + File.separatorChar
							+ SolistEditor.CLASS_NAME + ".txt");
					IO.copyMediaFile(from, to);
					editor.getEditorPanel().loadFile(to);
					editor.setChanged(true);
					editor.setSavedAs();
					Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.program.loaded"));
				} else {
					try {
						ScratchProgram p = ScratchFile.loadProgram(from);
						Play.getPlay().getPlayFrame().getScratchPanel()
								.setProgram(p);
						Play
								.getPlay()
								.getPlayFrame()
								.getMessagePanel()
								.writeInfo(
										ResourceManager.getResourceManager()
												.getValue("msg.program.loaded"));
					} catch (Exception exc) {
						JOptionPane
								.showMessageDialog(Play.getPlay()
										.getPlayFrame(), ResourceManager
										.getResourceManager().getValue(
												"msg.editor.loaderror"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
					}
				}
			} catch (Throwable th) {
				th.printStackTrace();
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}

	}

	@Override
	public void update(Observable o, Object arg) {
		if (!Play.getPlay().getActivePerformance().simulationStopped()) {
			item.setEnabled(false);
			if (button != null) {
				button.setEnabled(false);
			}
		} else {
			item.setEnabled(true);
			if (button != null) {
				button.setEnabled(true);
			}
		}

	}

}
