package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.MessageFormat;

import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.swing.JOptionPane;

import model.Play;
import scratch.ScratchPanel;
import scratch.ScratchPanelPrintable;
import util.PropertyManager;
import util.ResourceManager;
import util.Utils;
import editor.Editor;

/**
 * Druckt den Inhalt des Editors aus
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class PrintListener implements ActionListener {

	Editor editor;

	public PrintListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		PropertyManager pMan = PropertyManager.getPropertyManager();
		if (!(Play.getPlay().isSimulator() && pMan.isScratch())) {
			printText();
		} else {
			printScratch();
		}
	}

	public void printScratch() {
		ScratchPanel panel = Play.getPlay().getPlayFrame().getScratchPanel();
		PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
		aset.add(new JobName("Scratch-Programm", null));

		PrinterJob pj = PrinterJob.getPrinterJob();
		pj.setPrintable(new ScratchPanelPrintable(panel, pj.defaultPage()));

		try {
			if (pj.printDialog()) {
				pj.print(aset);
			}
		} catch (Throwable e) {
			JOptionPane.showMessageDialog(
					Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.printerror"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
		}
	}

	private void printText() {
		try {
			if (editor != Play.getPlay().getPlayFrame().getSolistEditor()
					.getEditor()) {
				String fileName = this.editor.getFileName();
				String fName = fileName.substring(
						fileName.lastIndexOf(File.separator) + 1,
						fileName.length());
				MessageFormat header = new MessageFormat(fName);
				MessageFormat footer = new MessageFormat(
						"Programming Theater (www.programming-theater.de)");
				this.editor.getEditorPanel().print(header, footer);
				this.editor.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.editor.print"));
			} else {
				String fName = "Solist";
				MessageFormat header = new MessageFormat(fName);
				MessageFormat footer = new MessageFormat(
						"Programming Theater (www.programming-theater.de)");
				Play.getPlay().getPlayFrame().getSolistEditor()
						.getEditorPanel().print(header, footer);
				Play.getPlay()
						.getPlayFrame()
						.getMessagePanel()
						.writeInfo(
								ResourceManager.getResourceManager().getValue(
										"msg.editor.print"));
			}

		} catch (Throwable e1) {
			e1.printStackTrace();
		}
	}

}
