package theater;

import java.util.List;

/**
 * Klasse fr die Realisierung von Aktionsbuttons, bei denen Mausklicks auf der
 * Bhne zu bestimmten Aktionen fhren sollen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (17.07.2009)
 * 
 */
public abstract class ClickHandler {

	/**
	 * Die berschriebene Methode wird aufgerufen, wenn der Aktionsbutton
	 * aktiviert ist und der Benutzer auf die Bhne klickt.
	 * 
	 * @param stage
	 *            die aktuelle Bhne
	 * @param solist
	 *            der Solist
	 * @param col
	 *            die Spalte der Bhne, auf der der Mausklick erfolgt ist
	 * @param row
	 *            die Reihe der Bhne, auf der der Mausklick erfolgt ist
	 * @param clickedComponents
	 *            u.U. angeklickte Komponenten auf der Bhne (in der Reihenfolge
	 *            ihrer Z-Koordinaten)
	 */
	public abstract void handleClick(Stage stage, Actor solist, int col,
			int row, List<Component> clickedComponents);

}
