package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Arrays;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import listener.SolistMethodInvocation;
import listener.SolistMethodWithParamInvocation;
import model.Play;
import theater.Component;
import theater.Description;
import theater.Invisible;
import theater_intern.IComponent;
import util.ResourceManager;

public class InstructionFrame extends JFrame {

	private Color color = new Color(255, 245, 210);
	private Color ncolor = new Color(240, 252, 202);
	private JPanel panel;

	private static InstructionFrame iFrame = null;

	public static InstructionFrame getInstructionFrame() {
		if (iFrame == null) {
			iFrame = new InstructionFrame();
		}
		return iFrame;
	}

	protected InstructionFrame() {
		super(ResourceManager.getResourceManager().getValue("iframe.title"));
		setLocation(40, 40);
		this.addWindowListener(new CloseListener(this));

		this.setLayout(new BorderLayout());
		this.panel = new JPanel();
		this.panel.setLayout(new GridLayout(0, 1));
		this.add(this.panel, BorderLayout.CENTER);

		JLabel l = new JLabel(" "
				+ ResourceManager.getResourceManager().getValue(
						"iframe.noinstruction") + " ");
		l.setBackground(this.color);
		this.panel.add(l);

		this.pack();
	}

	public void build(IComponent icomp) {
		this.panel.removeAll();
		this.remove(this.panel);
		this.panel = new JPanel();
		this.panel.setLayout(new GridLayout(0, 1));
		this.add(this.panel);

		if (icomp == null) {
			JLabel l = new JLabel(" "
					+ ResourceManager.getResourceManager().getValue(
							"iframe.nosolist") + " ");
			l.setBackground(this.color);
			this.panel.add(l);
			this.pack();
			return;
		}

		MethodComparator comparator = new MethodComparator();

		Component comp = IComponent.getComp(icomp);
		Class<?> cls = comp.getClass();
		cls = cls.getSuperclass();
		Method[] methods = ComponentPopupMenu.getMethods(comp, cls);
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			Invisible inv = method.getAnnotation(Invisible.class);
			if (inv == null) {
				JButton b = new JButton(ComponentPopupMenu
						.genShortMethodName(method));
				b.setBackground(this.color);
				Description desc = method.getAnnotation(Description.class);
				if (desc != null) {
					b.setToolTipText(desc.value());
				} else {
					b.setToolTipText(ComponentPopupMenu.genMethodName(method));
				}
				if (method.getParameterTypes().length == 0) {
					b.addActionListener(new SolistMethodInvocation(method));
				} else {
					b.addActionListener(new SolistMethodWithParamInvocation(
							method));
				}
				this.panel.add(b);
			}
		}

		methods = ComponentPopupMenu.getMethods(comp, comp.getClass());
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			Invisible inv = method.getAnnotation(Invisible.class);
			if (inv == null) {
				JButton b = new JButton(ComponentPopupMenu
						.genShortMethodName(method));
				b.setBackground(this.ncolor);
				Description desc = method.getAnnotation(Description.class);
				if (desc != null) {
					b.setToolTipText(desc.value());
				} else {
					b.setToolTipText(ComponentPopupMenu.genMethodName(method));
				}
				if (method.getParameterTypes().length == 0) {
					b.addActionListener(new SolistMethodInvocation(method));
				} else {
					b.addActionListener(new SolistMethodWithParamInvocation(
							method));
				}
				this.panel.add(b);
			}
		}

		if (this.panel.getComponentCount() == 0) {
			JLabel l = new JLabel(" "
					+ ResourceManager.getResourceManager().getValue(
							"iframe.noinstruction") + " ");
			l.setBackground(this.color);
			this.panel.add(l);
		}

		this.pack();
	}

	public void enableButtons() {
		for (java.awt.Component c : this.panel.getComponents()) {
			if (c instanceof JButton) {
				((JButton) c).setEnabled(true);
			}
		}
	}

	public void disableButtons() {
		for (java.awt.Component c : this.panel.getComponents()) {
			if (c instanceof JButton) {
				((JButton) c).setEnabled(false);
			}
		}
	}

}

class CloseListener extends WindowAdapter implements ActionListener {
	InstructionFrame iFrame;

	CloseListener(InstructionFrame iFrame) {
		this.iFrame = iFrame;
	}

	public void windowClosing(WindowEvent evt) {
		close();
	}

	public void actionPerformed(ActionEvent e) {
		close();
	}

	public void close() {
		iFrame.setVisible(false);
		Play.getPlay().getPlayFrame().getIFrameMenuItem().setSelected(false);
	}

}
