package listener;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import model.Play;
import util.ResourceManager;

public class SaveScratchProgramAsGifListener implements ActionListener {

	private static JFileChooser fChooser = null;

	public static JFileChooser getFileChooser() {
		if (fChooser == null) {
			fChooser = new JFileChooser();
		}
		return fChooser;
	}

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = getFileChooser();
		FileFilter filter = new GifFilter();
		chooser.setFileFilter(filter);
		int returnVal = chooser.showSaveDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				File to = chooser.getSelectedFile();
				String fname = to.getAbsolutePath();
				if (!fname.toLowerCase().endsWith(".gif")) {
					to = new File(fname + ".gif");
				}
				Image im = Play.getPlay().getPlayFrame().getScratchPanel().getImage();
				BufferedImage bim = new BufferedImage(im.getWidth(null), im
						.getHeight(null), BufferedImage.TYPE_INT_ARGB);
				Graphics g = bim.createGraphics();
				g.drawImage(im, 0, 0, null);
				ImageIO.write(bim, "gif", to);
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.program.gifsaved"));
			} catch (Throwable th) {
				th.printStackTrace();
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
	}
}

