package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import model.Play;
import scratch.ScratchFile;
import scratch.ScratchProgram;
import util.IO;
import util.PropertyManager;
import util.ResourceManager;
import editor.SolistEditor;

public class SaveProgramListener implements ActionListener {

	private static JFileChooser fChooser = null;

	public static JFileChooser getFileChooser() {
		if (SaveProgramListener.fChooser == null) {
			String path = Play.getPlay().getDirectory() + File.separatorChar
					+ "programs";
			SaveProgramListener.fChooser = new JFileChooser(path);
		}
		return SaveProgramListener.fChooser;
	}

	public void actionPerformed(ActionEvent e) {
		SaveProgramListener.saveProgram();
	}

	public static boolean saveProgram() {
		Play play = Play.getPlay();
		JFileChooser chooser = SaveProgramListener.getFileChooser();
		int returnVal = chooser.showSaveDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				if (!(play.isSimulator() && PropertyManager
						.getPropertyManager().isScratch())) {
					SolistEditor.getSolistEditor().save(true);
					File to = chooser.getSelectedFile();
					File from = new File(play.getDirectory()
							+ File.separatorChar + SolistEditor.CLASS_NAME
							+ ".txt");
					IO.copyMediaFile(from, to);
					Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.program.saved"));
					SolistEditor.getSolistEditor().getEditor().setSavedAs();
					return true;
				} else {
					File to = chooser.getSelectedFile();
					ScratchProgram program = Play.getPlay().getPlayFrame()
							.getScratchPanel().getProgram();
					try {
						ScratchFile.saveProgram(program, to);
						Play.getPlay().getPlayFrame().getMessagePanel()
								.writeInfo(
										ResourceManager.getResourceManager()
												.getValue("msg.program.saved"));
						return true;
					} catch (Exception exc) {
						JOptionPane
								.showMessageDialog(Play.getPlay()
										.getPlayFrame(), ResourceManager
										.getResourceManager().getValue(
												"msg.editor.saveerror"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
					}
				}
			} catch (Throwable th) {
				if (!play.isSimulator()) {
					th.printStackTrace();
				}
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
		return false;

	}

}
