package editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import model.Play;

import compiler.CompilerErrorPanel;
import compiler.JavaImportHandler;
import compiler.precompiler.JavaParser;

public class SolistEditor {

	public static final String CLASS_NAME = "Solist";

	private JavaEditor editor;
	private static SolistEditor solistEditor = null;

	protected SolistEditor() {
		editor = new JavaEditor(Play.getPlay().getDirectory()
				+ File.separatorChar + CLASS_NAME + ".txt", Play.getPlay()
				.getName());
		editor.setVisible(false);
	}

	public static SolistEditor getSolistEditor() {
		if (solistEditor == null) {
			solistEditor = new SolistEditor();
		}
		return solistEditor;
	}

	public JavaEditor getEditor() {
		return editor;
	}

	public EditorPanel getEditorPanel() {
		return editor.getEditorPanel();
	}

	public LineNumberPanel getLineNumberPanel() {
		return editor.getLineNumberPanel();
	}

	public CompilerErrorPanel getErrorPanel() {
		return editor.getErrorPanel();
	}

	private boolean precompileok = true;

	public void save(boolean withDeletion) throws IOException {
		this.editor.save();
		String wcode = this.editor.getEditorPanel().getText();
		String filename = Play.getPlay().getDirectory() + File.separatorChar
				+ CLASS_NAME;
		if (Play.getPlay().isImperativeParadigma()) {
			JavaImportHandler impHandler = new JavaImportHandler();
			String javaCode = impHandler.handleImport(SolistEditor.getPrefix(),
					wcode, SolistEditor.getPostfix());
			this.saveIntern(filename, "tmp", javaCode, withDeletion);
			// this.saveIntern(filename, "tmp", SolistEditor.getPrefix() + wcode
			// + SolistEditor.getPostfix());
		} else {
			this.saveIntern(filename, "tmp", wcode, withDeletion);
		}

		String code = precompile(filename + ".tmp");
		if (code == null) {
			precompileok = false;
			this.save2(withDeletion);
		} else {
			precompileok = true;
			this.saveIntern(filename, "java", code, withDeletion);
		}
	}

	public boolean isPrecompileOK() {
		return precompileok;
	}

	private void saveIntern(String filename, String suffix, String code, boolean withDeletion)
			throws IOException {
		File cfile = new File(filename + ".class");
		if (cfile != null && cfile.exists() && withDeletion) {
			cfile.delete();
		}
		File file = new File(filename + "." + suffix);
		FileWriter fw = null;
		try {
			fw = new FileWriter(file);
			// fw = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");

			fw.write(code);
			fw.flush();
		} finally {
			if (fw != null) {
				fw.close();
			}
		}
	}

	public void save2(boolean withDeletion) throws IOException {
		String wcode = this.editor.getEditorPanel().getText();
		File cfile = new File(Play.getPlay().getDirectory()
				+ File.separatorChar + CLASS_NAME + ".class");
		if (cfile != null && cfile.exists() && withDeletion) {
			cfile.delete();
		}
		File file = new File(Play.getPlay().getDirectory() + File.separatorChar
				+ CLASS_NAME + ".java");
		FileWriter fw = null;
		try {
			fw = new FileWriter(file);
			// fw = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
			if (Play.getPlay().isImperativeParadigma()) {
				fw.write(SolistEditor.getPrefix() + precompile2(wcode)
						+ SolistEditor.getPostfix());
			} else {
				fw.write(precompile2(wcode));
			}
			fw.flush();
		} finally {
			if (fw != null) {
				fw.close();
			}
		}
	}

	public File getJavaFile() {
		return new File(Play.getPlay().getDirectory() + File.separatorChar
				+ CLASS_NAME + ".java");
	}

	public static String getPrefix() {
		String classname = Play.getPlay().getActiveActorName();
		if (classname == null) {
			classname = "theater.Actor";
		}

		return "public class " + SolistEditor.CLASS_NAME + " extends "
				+ classname + " { ";
	}

	public static String getPrefixOld() {
		String classname = Play.getPlay().getActiveActorName();
		if (classname == null) {
			classname = "theater.Actor";
		}

		return "public class "
				+ SolistEditor.CLASS_NAME
				+ " extends "
				+ classname
				// Flag: SolistDebugger
				// + " implements "
				// + SolistDebugger.DEBUG_INTERFACE_NAME
				+ " { static final long serialVersionUID = 8962277232270632278L; "
				+ "public " + SolistEditor.CLASS_NAME + "() { super(); } "
				+ "public " + SolistEditor.CLASS_NAME + "("
				+ SolistEditor.CLASS_NAME + " solist) { super(solist); } ";
	}

	public static String getPostfix() {
		return " }";
	}

	public static String precompile2(String code) {
		String oldCode = code;
		do {
			oldCode = new String(code);
			code = code.replace("  ", " ");
		} while (oldCode.length() != code.length());

		String[] tokens = code.split(" ");
		StringBuffer buffer = new StringBuffer(code.length());
		for (int i = 0; i < tokens.length; i++) {
			if (tokens[i].equals("main()")
					|| (tokens[i].equals("main(") && i + 1 < tokens.length && (tokens[i + 1]
							.startsWith(")")))
					|| (tokens[i].equals("main") && i + 1 < tokens.length && (tokens[i + 1]
							.equals("()") || (i + 2 < tokens.length
							&& tokens[i + 1].equals("(") && tokens[i + 2]
							.startsWith(")"))))) {
				if ((i - 1 >= 0 && tokens[i - 1].endsWith("void"))
						&& (i - 2 < 0 || !tokens[i - 2].endsWith("public"))) {
					buffer.replace(buffer.length() - 5, buffer.length(),
							" public void ");
				}

			}
			buffer.append(tokens[i]);
			buffer.append(' ');
		}
		String res = buffer.toString();
		return res;
	}

	public static String precompile(String filename) {
		return JavaParser.parseFile(filename);
	}

}
