package theater;

import java.io.Serializable;
import java.lang.reflect.Constructor;

import theater_intern.IComponent;
import view.InstructionFrame;

import compiler.CompileManager;

import editor.SolistEditor;

/**
 * Die Klasse Actor ist die Basisklasse aller Akteure. Sie erbt alle Methoden
 * ihrer Oberklasse Component.
 * <p>
 * </p>
 * Im Normalfall gibt es in Solist nur eine Actor-Klasse. Dies ist die
 * Oberklasse der Solist-Klasse, von der der Solist erzuegt wird. Sollte es
 * mehrere Actor-Klassen geben, muss der Programmierer die Solist-Oberklasse
 * explizit auswhlen.
 * <p>
 * </p>
 * Im Solist-Programm muss die Methode "public void main()" berschrieben
 * werden. In dieser wird das Eigenleben des Solisten festgelegt, wobei u. a.
 * die geerbten Methoden der Klasse Component genutzt werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (17.07.2009)
 * 
 */
public class Actor extends Component implements Serializable {

	/**
	 * Default-Konstruktor der Klasse Actor
	 */
	public Actor() {
		super(true);
	}

	/**
	 * Copy-Konstruktor der Klasse Actor
	 * 
	 * @param actor
	 *            der zu klonende Akteur
	 */
	public Actor(Actor actor) {
		super(actor);
	}

	/**
	 * die von der Solist-Klasse zu berschreibende Methode
	 */
	public void main() {
	}

	/**
	 * erzeugt eine Instanz der Klasse Solist
	 * 
	 * @return der Solist
	 */
	public static Actor createSolist() {
		try {
			ClassLoader cl = CompileManager.getCompileManager()
					.getClassLoader();
			Class<?> cls = cl.loadClass(SolistEditor.CLASS_NAME);
			Actor solist = (Actor) cls.newInstance();
			IComponent iSolist = IComponent.getIComp(solist);
			InstructionFrame.getInstructionFrame().build(iSolist);
			return solist;
		} catch (Exception exc) {
			exc.printStackTrace();
			return null;
			// todo: Fehlerbehandlung
		}
	}

	/**
	 * erzeugt einen Clon des uebergebenen Solist
	 * 
	 * @param solist
	 *            der zu klonende Solist
	 * @return der geklonte Solist
	 */
	public static Actor cloneSolist(Actor solist) {
		try {
			ClassLoader cl = CompileManager.getCompileManager()
					.getClassLoader();
			Class<?> cls = cl.loadClass(SolistEditor.CLASS_NAME);
			Constructor<?> con = cls.getConstructor(cls);
			return (Actor) con.newInstance(solist);
		} catch (Exception exc) {
			exc.printStackTrace();
			return null;
			// todo: Fehlerbehandlung
		}
	}

}
