import theater.*;


/**
 * Die Klasse stellt eine Repraesentation des Spielfeldes dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (01.10.2009)
 *
 */
public class Spielfeld extends Stage {
    private Spielzug zug;
    private int figur;
    private Sync syncObject = new Sync(); // nicht Object wegen Serialisierbarkeit!

    public Spielfeld() {
        // Beispiel: Erzeuge eine Bhne mit 3 * 3 Zellen, die jeweils 78
        // Pixel hoch und breit sind
        super(3, 3, 78);
        setBackground("feld.png");

        // erzeugt den Solist 
        setSolist(Actor.createSolist(), 0, 0);

        // Solist ist unsichtbar
    }

    public void mousePressed(MouseInfo e) {
        zug = new Spielzug();
        zug.figur = this.figur;
        zug.spalte = e.getColumn();
        zug.reihe = e.getRow();

        Koordinator k = (Koordinator) getSolist();

        if (k.ueberpruefeMenschZug(zug)) {
            synchronized (syncObject) {
                syncObject.notify();
            }
        }
    }

    Spielzug warteAufKlick(int figur) {
        this.figur = figur;

        synchronized (syncObject) {
            setHandlingMouseEvents(true);

            try {
                syncObject.wait();
            } catch (InterruptedException exc) {
            }

            setHandlingMouseEvents(false);
        }

        return zug;
    }

    void loeschen() {
        remove(getComponents());
    }
}
