import theater.*;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;


/**
 * ActionHandler zum Verndern der Terminal-Gre
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (23.10.2009)
 *
 */
public class Groesse extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        if (((TPerformance) Performance.getPerformance()).isRunning()) {
            return;
        }

        SizeDialog dialog = new SizeDialog(stage);
        dialog.setVisible(true);
    }
}


class SizeDialog extends JDialog {
    JTextField reihen;
    JTextField spalten;
    JTextField cellsize;
    Stage stage;

    public SizeDialog(Stage stage) {
        super((Frame) null, "Terminal-Gre", true);
        this.stage = stage;

        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setLayout(new GridLayout(0, 1));

        JPanel rPanel = new JPanel();
        rPanel.setLayout(new FlowLayout());

        JLabel nR = new JLabel("Reihen: ");
        rPanel.add(nR);
        this.reihen = new JTextField(15);
        this.reihen.setText("" + stage.getNumberOfRows());
        this.reihen.addActionListener(new OKButtonAction(this));
        rPanel.add(this.reihen);
        this.add(rPanel);

        JPanel sPanel = new JPanel();
        sPanel.setLayout(new FlowLayout());

        JLabel nS = new JLabel("Spalten: ");
        sPanel.add(nS);
        this.spalten = new JTextField(15);
        this.spalten.setText("" + stage.getNumberOfColumns());
        this.spalten.addActionListener(new OKButtonAction(this));
        sPanel.add(this.spalten);
        this.add(sPanel);

        JPanel cPanel = new JPanel();
        cPanel.setLayout(new FlowLayout());

        JLabel nC = new JLabel("Zellgre: ");
        cPanel.add(nC);
        this.cellsize = new JTextField(15);
        this.cellsize.setText("" + stage.getCellSize());
        this.cellsize.addActionListener(new OKButtonAction(this));
        cPanel.add(this.cellsize);
        this.add(cPanel);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));

        JButton ok = new JButton("Ok");
        ok.addActionListener(new OKButtonAction(this));
        buttonPanel.add(ok);

        JButton cancel = new JButton("Abbrechen");
        cancel.addActionListener(new CancelButtonAction(this));
        buttonPanel.add(cancel);
        this.add(buttonPanel);

        this.pack();
        this.setResizable(false);

        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width / 2) - (this.getWidth() / 2),
            (d.height / 2) - (this.getHeight() / 2));
    }
}


class OKButtonAction implements ActionListener {
    SizeDialog dialog;

    OKButtonAction(SizeDialog d) {
        this.dialog = d;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int spalten = new Integer(dialog.spalten.getText());
            int reihen = new Integer(dialog.reihen.getText());
            int cellsize = new Integer(dialog.cellsize.getText());
            ((Terminal) dialog.stage).resize(spalten, reihen, cellsize);
            this.dialog.dispose();
        } catch (NumberFormatException exc) {
        }
    }
}


class CancelButtonAction implements ActionListener {
    JDialog dialog;

    CancelButtonAction(JDialog d) {
        this.dialog = d;
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog.dispose();
    }
}
